// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model



/**
 * Information about cluster attributes that can be updated via update APIs.
 */
class MutableClusterInfo private constructor(builder: BuilderImpl) {
    /**
     * Specifies the size of the EBS volume and the ID of the associated broker.
     */
    val brokerEbsVolumeInfo: List<BrokerEbsVolumeInfo>? = builder.brokerEbsVolumeInfo
    /**
     * Includes all client authentication information.
     */
    val clientAuthentication: ClientAuthentication? = builder.clientAuthentication
    /**
     * Information about the changes in the configuration of the brokers.
     */
    val configurationInfo: ConfigurationInfo? = builder.configurationInfo
    /**
     * Includes all encryption-related information.
     */
    val encryptionInfo: EncryptionInfo? = builder.encryptionInfo
    /**
     * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
     */
    val enhancedMonitoring: EnhancedMonitoring? = builder.enhancedMonitoring
    /**
     * Information about the Amazon MSK broker type.
     */
    val instanceType: String? = builder.instanceType
    /**
     * The Kafka version.
     */
    val kafkaVersion: String? = builder.kafkaVersion
    /**
     * You can configure your MSK cluster to send broker logs to different destination types. This is a container for the configuration details related to broker logs.
     */
    val loggingInfo: LoggingInfo? = builder.loggingInfo
    /**
     * The number of broker nodes in the cluster.
     */
    val numberOfBrokerNodes: Int? = builder.numberOfBrokerNodes
    /**
     * The settings for open monitoring.
     */
    val openMonitoring: OpenMonitoring? = builder.openMonitoring

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MutableClusterInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MutableClusterInfo(")
        append("brokerEbsVolumeInfo=$brokerEbsVolumeInfo,")
        append("clientAuthentication=$clientAuthentication,")
        append("configurationInfo=$configurationInfo,")
        append("encryptionInfo=$encryptionInfo,")
        append("enhancedMonitoring=$enhancedMonitoring,")
        append("instanceType=$instanceType,")
        append("kafkaVersion=$kafkaVersion,")
        append("loggingInfo=$loggingInfo,")
        append("numberOfBrokerNodes=$numberOfBrokerNodes,")
        append("openMonitoring=$openMonitoring)")
    }

    override fun hashCode(): kotlin.Int {
        var result = brokerEbsVolumeInfo?.hashCode() ?: 0
        result = 31 * result + (clientAuthentication?.hashCode() ?: 0)
        result = 31 * result + (configurationInfo?.hashCode() ?: 0)
        result = 31 * result + (encryptionInfo?.hashCode() ?: 0)
        result = 31 * result + (enhancedMonitoring?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kafkaVersion?.hashCode() ?: 0)
        result = 31 * result + (loggingInfo?.hashCode() ?: 0)
        result = 31 * result + (numberOfBrokerNodes ?: 0)
        result = 31 * result + (openMonitoring?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MutableClusterInfo

        if (brokerEbsVolumeInfo != other.brokerEbsVolumeInfo) return false
        if (clientAuthentication != other.clientAuthentication) return false
        if (configurationInfo != other.configurationInfo) return false
        if (encryptionInfo != other.encryptionInfo) return false
        if (enhancedMonitoring != other.enhancedMonitoring) return false
        if (instanceType != other.instanceType) return false
        if (kafkaVersion != other.kafkaVersion) return false
        if (loggingInfo != other.loggingInfo) return false
        if (numberOfBrokerNodes != other.numberOfBrokerNodes) return false
        if (openMonitoring != other.openMonitoring) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MutableClusterInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MutableClusterInfo
        /**
         * Specifies the size of the EBS volume and the ID of the associated broker.
         */
        fun brokerEbsVolumeInfo(brokerEbsVolumeInfo: List<BrokerEbsVolumeInfo>): FluentBuilder
        /**
         * Includes all client authentication information.
         */
        fun clientAuthentication(clientAuthentication: ClientAuthentication): FluentBuilder
        /**
         * Information about the changes in the configuration of the brokers.
         */
        fun configurationInfo(configurationInfo: ConfigurationInfo): FluentBuilder
        /**
         * Includes all encryption-related information.
         */
        fun encryptionInfo(encryptionInfo: EncryptionInfo): FluentBuilder
        /**
         * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
         */
        fun enhancedMonitoring(enhancedMonitoring: EnhancedMonitoring): FluentBuilder
        /**
         * Information about the Amazon MSK broker type.
         */
        fun instanceType(instanceType: String): FluentBuilder
        /**
         * The Kafka version.
         */
        fun kafkaVersion(kafkaVersion: String): FluentBuilder
        /**
         * You can configure your MSK cluster to send broker logs to different destination types. This is a container for the configuration details related to broker logs.
         */
        fun loggingInfo(loggingInfo: LoggingInfo): FluentBuilder
        /**
         * The number of broker nodes in the cluster.
         */
        fun numberOfBrokerNodes(numberOfBrokerNodes: Int): FluentBuilder
        /**
         * The settings for open monitoring.
         */
        fun openMonitoring(openMonitoring: OpenMonitoring): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies the size of the EBS volume and the ID of the associated broker.
         */
        var brokerEbsVolumeInfo: List<BrokerEbsVolumeInfo>?
        /**
         * Includes all client authentication information.
         */
        var clientAuthentication: ClientAuthentication?
        /**
         * Information about the changes in the configuration of the brokers.
         */
        var configurationInfo: ConfigurationInfo?
        /**
         * Includes all encryption-related information.
         */
        var encryptionInfo: EncryptionInfo?
        /**
         * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
         */
        var enhancedMonitoring: EnhancedMonitoring?
        /**
         * Information about the Amazon MSK broker type.
         */
        var instanceType: String?
        /**
         * The Kafka version.
         */
        var kafkaVersion: String?
        /**
         * You can configure your MSK cluster to send broker logs to different destination types. This is a container for the configuration details related to broker logs.
         */
        var loggingInfo: LoggingInfo?
        /**
         * The number of broker nodes in the cluster.
         */
        var numberOfBrokerNodes: Int?
        /**
         * The settings for open monitoring.
         */
        var openMonitoring: OpenMonitoring?

        fun build(): MutableClusterInfo
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ClientAuthentication] inside the given [block]
         */
        fun clientAuthentication(block: ClientAuthentication.DslBuilder.() -> kotlin.Unit) {
            this.clientAuthentication = ClientAuthentication.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ConfigurationInfo] inside the given [block]
         */
        fun configurationInfo(block: ConfigurationInfo.DslBuilder.() -> kotlin.Unit) {
            this.configurationInfo = ConfigurationInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.EncryptionInfo] inside the given [block]
         */
        fun encryptionInfo(block: EncryptionInfo.DslBuilder.() -> kotlin.Unit) {
            this.encryptionInfo = EncryptionInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.LoggingInfo] inside the given [block]
         */
        fun loggingInfo(block: LoggingInfo.DslBuilder.() -> kotlin.Unit) {
            this.loggingInfo = LoggingInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.OpenMonitoring] inside the given [block]
         */
        fun openMonitoring(block: OpenMonitoring.DslBuilder.() -> kotlin.Unit) {
            this.openMonitoring = OpenMonitoring.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var brokerEbsVolumeInfo: List<BrokerEbsVolumeInfo>? = null
        override var clientAuthentication: ClientAuthentication? = null
        override var configurationInfo: ConfigurationInfo? = null
        override var encryptionInfo: EncryptionInfo? = null
        override var enhancedMonitoring: EnhancedMonitoring? = null
        override var instanceType: String? = null
        override var kafkaVersion: String? = null
        override var loggingInfo: LoggingInfo? = null
        override var numberOfBrokerNodes: Int? = null
        override var openMonitoring: OpenMonitoring? = null

        constructor(x: MutableClusterInfo) : this() {
            this.brokerEbsVolumeInfo = x.brokerEbsVolumeInfo
            this.clientAuthentication = x.clientAuthentication
            this.configurationInfo = x.configurationInfo
            this.encryptionInfo = x.encryptionInfo
            this.enhancedMonitoring = x.enhancedMonitoring
            this.instanceType = x.instanceType
            this.kafkaVersion = x.kafkaVersion
            this.loggingInfo = x.loggingInfo
            this.numberOfBrokerNodes = x.numberOfBrokerNodes
            this.openMonitoring = x.openMonitoring
        }

        override fun build(): MutableClusterInfo = MutableClusterInfo(this)
        override fun brokerEbsVolumeInfo(brokerEbsVolumeInfo: List<BrokerEbsVolumeInfo>): FluentBuilder = apply { this.brokerEbsVolumeInfo = brokerEbsVolumeInfo }
        override fun clientAuthentication(clientAuthentication: ClientAuthentication): FluentBuilder = apply { this.clientAuthentication = clientAuthentication }
        override fun configurationInfo(configurationInfo: ConfigurationInfo): FluentBuilder = apply { this.configurationInfo = configurationInfo }
        override fun encryptionInfo(encryptionInfo: EncryptionInfo): FluentBuilder = apply { this.encryptionInfo = encryptionInfo }
        override fun enhancedMonitoring(enhancedMonitoring: EnhancedMonitoring): FluentBuilder = apply { this.enhancedMonitoring = enhancedMonitoring }
        override fun instanceType(instanceType: String): FluentBuilder = apply { this.instanceType = instanceType }
        override fun kafkaVersion(kafkaVersion: String): FluentBuilder = apply { this.kafkaVersion = kafkaVersion }
        override fun loggingInfo(loggingInfo: LoggingInfo): FluentBuilder = apply { this.loggingInfo = loggingInfo }
        override fun numberOfBrokerNodes(numberOfBrokerNodes: Int): FluentBuilder = apply { this.numberOfBrokerNodes = numberOfBrokerNodes }
        override fun openMonitoring(openMonitoring: OpenMonitoring): FluentBuilder = apply { this.openMonitoring = openMonitoring }
    }
}
