// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model



/**
 * The settings for encrypting data in transit.
 */
class EncryptionInTransit private constructor(builder: BuilderImpl) {
    /**
     * Indicates the encryption setting for data in transit between clients and brokers. The following are the possible values.
     * TLS means that client-broker communication is enabled with TLS only.
     * TLS_PLAINTEXT means that client-broker communication is enabled for both TLS-encrypted, as well as plaintext data.
     * PLAINTEXT means that client-broker communication is enabled in plaintext only.
     * The default value is TLS_PLAINTEXT.
     */
    val clientBroker: ClientBroker? = builder.clientBroker
    /**
     * When set to true, it indicates that data communication among the broker nodes of the cluster is encrypted. When set to false, the communication happens in plaintext.
     * The default value is true.
     */
    val inCluster: Boolean? = builder.inCluster

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): EncryptionInTransit = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptionInTransit(")
        append("clientBroker=$clientBroker,")
        append("inCluster=$inCluster)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientBroker?.hashCode() ?: 0
        result = 31 * result + (inCluster?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EncryptionInTransit

        if (clientBroker != other.clientBroker) return false
        if (inCluster != other.inCluster) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): EncryptionInTransit = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): EncryptionInTransit
        /**
         * Indicates the encryption setting for data in transit between clients and brokers. The following are the possible values.
         * TLS means that client-broker communication is enabled with TLS only.
         * TLS_PLAINTEXT means that client-broker communication is enabled for both TLS-encrypted, as well as plaintext data.
         * PLAINTEXT means that client-broker communication is enabled in plaintext only.
         * The default value is TLS_PLAINTEXT.
         */
        fun clientBroker(clientBroker: ClientBroker): FluentBuilder
        /**
         * When set to true, it indicates that data communication among the broker nodes of the cluster is encrypted. When set to false, the communication happens in plaintext.
         * The default value is true.
         */
        fun inCluster(inCluster: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates the encryption setting for data in transit between clients and brokers. The following are the possible values.
         * TLS means that client-broker communication is enabled with TLS only.
         * TLS_PLAINTEXT means that client-broker communication is enabled for both TLS-encrypted, as well as plaintext data.
         * PLAINTEXT means that client-broker communication is enabled in plaintext only.
         * The default value is TLS_PLAINTEXT.
         */
        var clientBroker: ClientBroker?
        /**
         * When set to true, it indicates that data communication among the broker nodes of the cluster is encrypted. When set to false, the communication happens in plaintext.
         * The default value is true.
         */
        var inCluster: Boolean?

        fun build(): EncryptionInTransit
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientBroker: ClientBroker? = null
        override var inCluster: Boolean? = null

        constructor(x: EncryptionInTransit) : this() {
            this.clientBroker = x.clientBroker
            this.inCluster = x.inCluster
        }

        override fun build(): EncryptionInTransit = EncryptionInTransit(this)
        override fun clientBroker(clientBroker: ClientBroker): FluentBuilder = apply { this.clientBroker = clientBroker }
        override fun inCluster(inCluster: Boolean): FluentBuilder = apply { this.inCluster = inCluster }
    }
}
