// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeConfigurationRevisionResponse private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the configuration.
     */
    val arn: String? = builder.arn
    /**
     * The time when the configuration was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The description of the configuration.
     */
    val description: String? = builder.description
    /**
     * The revision number.
     */
    val revision: Long? = builder.revision
    /**
     * Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the contents of the file are base64 encoded.
     * When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties</filename> can be in plaintext.
     */
    val serverProperties: ByteArray? = builder.serverProperties

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeConfigurationRevisionResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeConfigurationRevisionResponse(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("revision=$revision,")
        append("serverProperties=$serverProperties)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (revision?.hashCode() ?: 0)
        result = 31 * result + (serverProperties?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeConfigurationRevisionResponse

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (revision != other.revision) return false
        if (serverProperties != null) {
            if (other.serverProperties == null) return false
            if (!serverProperties.contentEquals(other.serverProperties)) return false
        } else if (other.serverProperties != null) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeConfigurationRevisionResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeConfigurationRevisionResponse
        /**
         * The Amazon Resource Name (ARN) of the configuration.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The time when the configuration was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The description of the configuration.
         */
        fun description(description: String): FluentBuilder
        /**
         * The revision number.
         */
        fun revision(revision: Long): FluentBuilder
        /**
         * Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the contents of the file are base64 encoded.
         * When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties</filename> can be in plaintext.
         */
        fun serverProperties(serverProperties: ByteArray): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the configuration.
         */
        var arn: String?
        /**
         * The time when the configuration was created.
         */
        var creationTime: Instant?
        /**
         * The description of the configuration.
         */
        var description: String?
        /**
         * The revision number.
         */
        var revision: Long?
        /**
         * Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the contents of the file are base64 encoded.
         * When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties</filename> can be in plaintext.
         */
        var serverProperties: ByteArray?

        fun build(): DescribeConfigurationRevisionResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var creationTime: Instant? = null
        override var description: String? = null
        override var revision: Long? = null
        override var serverProperties: ByteArray? = null

        constructor(x: DescribeConfigurationRevisionResponse) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.description = x.description
            this.revision = x.revision
            this.serverProperties = x.serverProperties
        }

        override fun build(): DescribeConfigurationRevisionResponse = DescribeConfigurationRevisionResponse(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun revision(revision: Long): FluentBuilder = apply { this.revision = revision }
        override fun serverProperties(serverProperties: ByteArray): FluentBuilder = apply { this.serverProperties = serverProperties }
    }
}
