// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model



class CreateConfigurationRequest private constructor(builder: BuilderImpl) {
    /**
     * The description of the configuration.
     */
    val description: String? = builder.description
    /**
     * The versions of Apache Kafka with which you can use this MSK configuration.
     */
    val kafkaVersions: List<String>? = builder.kafkaVersions
    /**
     * The name of the configuration.
     */
    val name: String? = builder.name
    /**
     * Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the contents of the file are base64 encoded.
     * When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties</filename> can be in plaintext.
     */
    val serverProperties: ByteArray? = builder.serverProperties

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateConfigurationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConfigurationRequest(")
        append("description=$description,")
        append("kafkaVersions=$kafkaVersions,")
        append("name=$name,")
        append("serverProperties=$serverProperties)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (kafkaVersions?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (serverProperties?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateConfigurationRequest

        if (description != other.description) return false
        if (kafkaVersions != other.kafkaVersions) return false
        if (name != other.name) return false
        if (serverProperties != null) {
            if (other.serverProperties == null) return false
            if (!serverProperties.contentEquals(other.serverProperties)) return false
        } else if (other.serverProperties != null) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateConfigurationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateConfigurationRequest
        /**
         * The description of the configuration.
         */
        fun description(description: String): FluentBuilder
        /**
         * The versions of Apache Kafka with which you can use this MSK configuration.
         */
        fun kafkaVersions(kafkaVersions: List<String>): FluentBuilder
        /**
         * The name of the configuration.
         */
        fun name(name: String): FluentBuilder
        /**
         * Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the contents of the file are base64 encoded.
         * When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties</filename> can be in plaintext.
         */
        fun serverProperties(serverProperties: ByteArray): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The description of the configuration.
         */
        var description: String?
        /**
         * The versions of Apache Kafka with which you can use this MSK configuration.
         */
        var kafkaVersions: List<String>?
        /**
         * The name of the configuration.
         */
        var name: String?
        /**
         * Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the contents of the file are base64 encoded.
         * When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties</filename> can be in plaintext.
         */
        var serverProperties: ByteArray?

        fun build(): CreateConfigurationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var kafkaVersions: List<String>? = null
        override var name: String? = null
        override var serverProperties: ByteArray? = null

        constructor(x: CreateConfigurationRequest) : this() {
            this.description = x.description
            this.kafkaVersions = x.kafkaVersions
            this.name = x.name
            this.serverProperties = x.serverProperties
        }

        override fun build(): CreateConfigurationRequest = CreateConfigurationRequest(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun kafkaVersions(kafkaVersions: List<String>): FluentBuilder = apply { this.kafkaVersions = kafkaVersions }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun serverProperties(serverProperties: ByteArray): FluentBuilder = apply { this.serverProperties = serverProperties }
    }
}
