// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model



class CreateClusterRequest private constructor(builder: BuilderImpl) {
    /**
     * Information about the broker nodes in the cluster.
     */
    val brokerNodeGroupInfo: BrokerNodeGroupInfo? = builder.brokerNodeGroupInfo
    /**
     * Includes all client authentication related information.
     */
    val clientAuthentication: ClientAuthentication? = builder.clientAuthentication
    /**
     * The name of the cluster.
     */
    val clusterName: String? = builder.clusterName
    /**
     * Represents the configuration that you want MSK to use for the brokers in a cluster.
     */
    val configurationInfo: ConfigurationInfo? = builder.configurationInfo
    /**
     * Includes all encryption-related information.
     */
    val encryptionInfo: EncryptionInfo? = builder.encryptionInfo
    /**
     * Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
     */
    val enhancedMonitoring: EnhancedMonitoring? = builder.enhancedMonitoring
    /**
     * The version of Apache Kafka.
     */
    val kafkaVersion: String? = builder.kafkaVersion
    val loggingInfo: LoggingInfo? = builder.loggingInfo
    /**
     * The number of broker nodes in the cluster.
     */
    val numberOfBrokerNodes: Int? = builder.numberOfBrokerNodes
    /**
     * The settings for open monitoring.
     */
    val openMonitoring: OpenMonitoringInfo? = builder.openMonitoring
    /**
     * Create tags when creating the cluster.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateClusterRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClusterRequest(")
        append("brokerNodeGroupInfo=$brokerNodeGroupInfo,")
        append("clientAuthentication=$clientAuthentication,")
        append("clusterName=$clusterName,")
        append("configurationInfo=$configurationInfo,")
        append("encryptionInfo=$encryptionInfo,")
        append("enhancedMonitoring=$enhancedMonitoring,")
        append("kafkaVersion=$kafkaVersion,")
        append("loggingInfo=$loggingInfo,")
        append("numberOfBrokerNodes=$numberOfBrokerNodes,")
        append("openMonitoring=$openMonitoring,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = brokerNodeGroupInfo?.hashCode() ?: 0
        result = 31 * result + (clientAuthentication?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (configurationInfo?.hashCode() ?: 0)
        result = 31 * result + (encryptionInfo?.hashCode() ?: 0)
        result = 31 * result + (enhancedMonitoring?.hashCode() ?: 0)
        result = 31 * result + (kafkaVersion?.hashCode() ?: 0)
        result = 31 * result + (loggingInfo?.hashCode() ?: 0)
        result = 31 * result + (numberOfBrokerNodes ?: 0)
        result = 31 * result + (openMonitoring?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateClusterRequest

        if (brokerNodeGroupInfo != other.brokerNodeGroupInfo) return false
        if (clientAuthentication != other.clientAuthentication) return false
        if (clusterName != other.clusterName) return false
        if (configurationInfo != other.configurationInfo) return false
        if (encryptionInfo != other.encryptionInfo) return false
        if (enhancedMonitoring != other.enhancedMonitoring) return false
        if (kafkaVersion != other.kafkaVersion) return false
        if (loggingInfo != other.loggingInfo) return false
        if (numberOfBrokerNodes != other.numberOfBrokerNodes) return false
        if (openMonitoring != other.openMonitoring) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateClusterRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateClusterRequest
        /**
         * Information about the broker nodes in the cluster.
         */
        fun brokerNodeGroupInfo(brokerNodeGroupInfo: BrokerNodeGroupInfo): FluentBuilder
        /**
         * Includes all client authentication related information.
         */
        fun clientAuthentication(clientAuthentication: ClientAuthentication): FluentBuilder
        /**
         * The name of the cluster.
         */
        fun clusterName(clusterName: String): FluentBuilder
        /**
         * Represents the configuration that you want MSK to use for the brokers in a cluster.
         */
        fun configurationInfo(configurationInfo: ConfigurationInfo): FluentBuilder
        /**
         * Includes all encryption-related information.
         */
        fun encryptionInfo(encryptionInfo: EncryptionInfo): FluentBuilder
        /**
         * Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
         */
        fun enhancedMonitoring(enhancedMonitoring: EnhancedMonitoring): FluentBuilder
        /**
         * The version of Apache Kafka.
         */
        fun kafkaVersion(kafkaVersion: String): FluentBuilder
        fun loggingInfo(loggingInfo: LoggingInfo): FluentBuilder
        /**
         * The number of broker nodes in the cluster.
         */
        fun numberOfBrokerNodes(numberOfBrokerNodes: Int): FluentBuilder
        /**
         * The settings for open monitoring.
         */
        fun openMonitoring(openMonitoring: OpenMonitoringInfo): FluentBuilder
        /**
         * Create tags when creating the cluster.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information about the broker nodes in the cluster.
         */
        var brokerNodeGroupInfo: BrokerNodeGroupInfo?
        /**
         * Includes all client authentication related information.
         */
        var clientAuthentication: ClientAuthentication?
        /**
         * The name of the cluster.
         */
        var clusterName: String?
        /**
         * Represents the configuration that you want MSK to use for the brokers in a cluster.
         */
        var configurationInfo: ConfigurationInfo?
        /**
         * Includes all encryption-related information.
         */
        var encryptionInfo: EncryptionInfo?
        /**
         * Specifies the level of monitoring for the MSK cluster. The possible values are DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION.
         */
        var enhancedMonitoring: EnhancedMonitoring?
        /**
         * The version of Apache Kafka.
         */
        var kafkaVersion: String?
        var loggingInfo: LoggingInfo?
        /**
         * The number of broker nodes in the cluster.
         */
        var numberOfBrokerNodes: Int?
        /**
         * The settings for open monitoring.
         */
        var openMonitoring: OpenMonitoringInfo?
        /**
         * Create tags when creating the cluster.
         */
        var tags: Map<String, String>?

        fun build(): CreateClusterRequest
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.BrokerNodeGroupInfo] inside the given [block]
         */
        fun brokerNodeGroupInfo(block: BrokerNodeGroupInfo.DslBuilder.() -> kotlin.Unit) {
            this.brokerNodeGroupInfo = BrokerNodeGroupInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ClientAuthentication] inside the given [block]
         */
        fun clientAuthentication(block: ClientAuthentication.DslBuilder.() -> kotlin.Unit) {
            this.clientAuthentication = ClientAuthentication.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ConfigurationInfo] inside the given [block]
         */
        fun configurationInfo(block: ConfigurationInfo.DslBuilder.() -> kotlin.Unit) {
            this.configurationInfo = ConfigurationInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.EncryptionInfo] inside the given [block]
         */
        fun encryptionInfo(block: EncryptionInfo.DslBuilder.() -> kotlin.Unit) {
            this.encryptionInfo = EncryptionInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.LoggingInfo] inside the given [block]
         */
        fun loggingInfo(block: LoggingInfo.DslBuilder.() -> kotlin.Unit) {
            this.loggingInfo = LoggingInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.OpenMonitoringInfo] inside the given [block]
         */
        fun openMonitoring(block: OpenMonitoringInfo.DslBuilder.() -> kotlin.Unit) {
            this.openMonitoring = OpenMonitoringInfo.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var brokerNodeGroupInfo: BrokerNodeGroupInfo? = null
        override var clientAuthentication: ClientAuthentication? = null
        override var clusterName: String? = null
        override var configurationInfo: ConfigurationInfo? = null
        override var encryptionInfo: EncryptionInfo? = null
        override var enhancedMonitoring: EnhancedMonitoring? = null
        override var kafkaVersion: String? = null
        override var loggingInfo: LoggingInfo? = null
        override var numberOfBrokerNodes: Int? = null
        override var openMonitoring: OpenMonitoringInfo? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreateClusterRequest) : this() {
            this.brokerNodeGroupInfo = x.brokerNodeGroupInfo
            this.clientAuthentication = x.clientAuthentication
            this.clusterName = x.clusterName
            this.configurationInfo = x.configurationInfo
            this.encryptionInfo = x.encryptionInfo
            this.enhancedMonitoring = x.enhancedMonitoring
            this.kafkaVersion = x.kafkaVersion
            this.loggingInfo = x.loggingInfo
            this.numberOfBrokerNodes = x.numberOfBrokerNodes
            this.openMonitoring = x.openMonitoring
            this.tags = x.tags
        }

        override fun build(): CreateClusterRequest = CreateClusterRequest(this)
        override fun brokerNodeGroupInfo(brokerNodeGroupInfo: BrokerNodeGroupInfo): FluentBuilder = apply { this.brokerNodeGroupInfo = brokerNodeGroupInfo }
        override fun clientAuthentication(clientAuthentication: ClientAuthentication): FluentBuilder = apply { this.clientAuthentication = clientAuthentication }
        override fun clusterName(clusterName: String): FluentBuilder = apply { this.clusterName = clusterName }
        override fun configurationInfo(configurationInfo: ConfigurationInfo): FluentBuilder = apply { this.configurationInfo = configurationInfo }
        override fun encryptionInfo(encryptionInfo: EncryptionInfo): FluentBuilder = apply { this.encryptionInfo = encryptionInfo }
        override fun enhancedMonitoring(enhancedMonitoring: EnhancedMonitoring): FluentBuilder = apply { this.enhancedMonitoring = enhancedMonitoring }
        override fun kafkaVersion(kafkaVersion: String): FluentBuilder = apply { this.kafkaVersion = kafkaVersion }
        override fun loggingInfo(loggingInfo: LoggingInfo): FluentBuilder = apply { this.loggingInfo = loggingInfo }
        override fun numberOfBrokerNodes(numberOfBrokerNodes: Int): FluentBuilder = apply { this.numberOfBrokerNodes = numberOfBrokerNodes }
        override fun openMonitoring(openMonitoring: OpenMonitoringInfo): FluentBuilder = apply { this.openMonitoring = openMonitoring }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
