// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents an MSK Configuration.
 */
class Configuration private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the configuration.
     */
    val arn: String? = builder.arn
    /**
     * The time when the configuration was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The description of the configuration.
     */
    val description: String? = builder.description
    /**
     * An array of the versions of Apache Kafka with which you can use this MSK configuration. You can use this configuration for an MSK cluster only if the Apache Kafka version specified for the cluster appears in this array.
     */
    val kafkaVersions: List<String>? = builder.kafkaVersions
    /**
     * Latest revision of the configuration.
     */
    val latestRevision: ConfigurationRevision? = builder.latestRevision
    /**
     * The name of the configuration.
     */
    val name: String? = builder.name
    /**
     * The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
     */
    val state: ConfigurationState? = builder.state

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Configuration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Configuration(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("kafkaVersions=$kafkaVersions,")
        append("latestRevision=$latestRevision,")
        append("name=$name,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kafkaVersions?.hashCode() ?: 0)
        result = 31 * result + (latestRevision?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Configuration

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (kafkaVersions != other.kafkaVersions) return false
        if (latestRevision != other.latestRevision) return false
        if (name != other.name) return false
        if (state != other.state) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Configuration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Configuration
        /**
         * The Amazon Resource Name (ARN) of the configuration.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The time when the configuration was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The description of the configuration.
         */
        fun description(description: String): FluentBuilder
        /**
         * An array of the versions of Apache Kafka with which you can use this MSK configuration. You can use this configuration for an MSK cluster only if the Apache Kafka version specified for the cluster appears in this array.
         */
        fun kafkaVersions(kafkaVersions: List<String>): FluentBuilder
        /**
         * Latest revision of the configuration.
         */
        fun latestRevision(latestRevision: ConfigurationRevision): FluentBuilder
        /**
         * The name of the configuration.
         */
        fun name(name: String): FluentBuilder
        /**
         * The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
         */
        fun state(state: ConfigurationState): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the configuration.
         */
        var arn: String?
        /**
         * The time when the configuration was created.
         */
        var creationTime: Instant?
        /**
         * The description of the configuration.
         */
        var description: String?
        /**
         * An array of the versions of Apache Kafka with which you can use this MSK configuration. You can use this configuration for an MSK cluster only if the Apache Kafka version specified for the cluster appears in this array.
         */
        var kafkaVersions: List<String>?
        /**
         * Latest revision of the configuration.
         */
        var latestRevision: ConfigurationRevision?
        /**
         * The name of the configuration.
         */
        var name: String?
        /**
         * The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
         */
        var state: ConfigurationState?

        fun build(): Configuration
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ConfigurationRevision] inside the given [block]
         */
        fun latestRevision(block: ConfigurationRevision.DslBuilder.() -> kotlin.Unit) {
            this.latestRevision = ConfigurationRevision.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var creationTime: Instant? = null
        override var description: String? = null
        override var kafkaVersions: List<String>? = null
        override var latestRevision: ConfigurationRevision? = null
        override var name: String? = null
        override var state: ConfigurationState? = null

        constructor(x: Configuration) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.description = x.description
            this.kafkaVersions = x.kafkaVersions
            this.latestRevision = x.latestRevision
            this.name = x.name
            this.state = x.state
        }

        override fun build(): Configuration = Configuration(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun kafkaVersions(kafkaVersions: List<String>): FluentBuilder = apply { this.kafkaVersions = kafkaVersions }
        override fun latestRevision(latestRevision: ConfigurationRevision): FluentBuilder = apply { this.latestRevision = latestRevision }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun state(state: ConfigurationState): FluentBuilder = apply { this.state = state }
    }
}
