// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Returns information about a cluster operation.
 */
class ClusterOperationInfo private constructor(builder: BuilderImpl) {
    /**
     * The ID of the API request that triggered this operation.
     */
    val clientRequestId: String? = builder.clientRequestId
    /**
     * ARN of the cluster.
     */
    val clusterArn: String? = builder.clusterArn
    /**
     * The time that the operation was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The time at which the operation finished.
     */
    val endTime: Instant? = builder.endTime
    /**
     * Describes the error if the operation fails.
     */
    val errorInfo: ErrorInfo? = builder.errorInfo
    /**
     * ARN of the cluster operation.
     */
    val operationArn: String? = builder.operationArn
    /**
     * State of the cluster operation.
     */
    val operationState: String? = builder.operationState
    /**
     * Steps completed during the operation.
     */
    val operationSteps: List<ClusterOperationStep>? = builder.operationSteps
    /**
     * Type of the cluster operation.
     */
    val operationType: String? = builder.operationType
    /**
     * Information about cluster attributes before a cluster is updated.
     */
    val sourceClusterInfo: MutableClusterInfo? = builder.sourceClusterInfo
    /**
     * Information about cluster attributes after a cluster is updated.
     */
    val targetClusterInfo: MutableClusterInfo? = builder.targetClusterInfo

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ClusterOperationInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterOperationInfo(")
        append("clientRequestId=$clientRequestId,")
        append("clusterArn=$clusterArn,")
        append("creationTime=$creationTime,")
        append("endTime=$endTime,")
        append("errorInfo=$errorInfo,")
        append("operationArn=$operationArn,")
        append("operationState=$operationState,")
        append("operationSteps=$operationSteps,")
        append("operationType=$operationType,")
        append("sourceClusterInfo=$sourceClusterInfo,")
        append("targetClusterInfo=$targetClusterInfo)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestId?.hashCode() ?: 0
        result = 31 * result + (clusterArn?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (errorInfo?.hashCode() ?: 0)
        result = 31 * result + (operationArn?.hashCode() ?: 0)
        result = 31 * result + (operationState?.hashCode() ?: 0)
        result = 31 * result + (operationSteps?.hashCode() ?: 0)
        result = 31 * result + (operationType?.hashCode() ?: 0)
        result = 31 * result + (sourceClusterInfo?.hashCode() ?: 0)
        result = 31 * result + (targetClusterInfo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ClusterOperationInfo

        if (clientRequestId != other.clientRequestId) return false
        if (clusterArn != other.clusterArn) return false
        if (creationTime != other.creationTime) return false
        if (endTime != other.endTime) return false
        if (errorInfo != other.errorInfo) return false
        if (operationArn != other.operationArn) return false
        if (operationState != other.operationState) return false
        if (operationSteps != other.operationSteps) return false
        if (operationType != other.operationType) return false
        if (sourceClusterInfo != other.sourceClusterInfo) return false
        if (targetClusterInfo != other.targetClusterInfo) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ClusterOperationInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ClusterOperationInfo
        /**
         * The ID of the API request that triggered this operation.
         */
        fun clientRequestId(clientRequestId: String): FluentBuilder
        /**
         * ARN of the cluster.
         */
        fun clusterArn(clusterArn: String): FluentBuilder
        /**
         * The time that the operation was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The time at which the operation finished.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * Describes the error if the operation fails.
         */
        fun errorInfo(errorInfo: ErrorInfo): FluentBuilder
        /**
         * ARN of the cluster operation.
         */
        fun operationArn(operationArn: String): FluentBuilder
        /**
         * State of the cluster operation.
         */
        fun operationState(operationState: String): FluentBuilder
        /**
         * Steps completed during the operation.
         */
        fun operationSteps(operationSteps: List<ClusterOperationStep>): FluentBuilder
        /**
         * Type of the cluster operation.
         */
        fun operationType(operationType: String): FluentBuilder
        /**
         * Information about cluster attributes before a cluster is updated.
         */
        fun sourceClusterInfo(sourceClusterInfo: MutableClusterInfo): FluentBuilder
        /**
         * Information about cluster attributes after a cluster is updated.
         */
        fun targetClusterInfo(targetClusterInfo: MutableClusterInfo): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the API request that triggered this operation.
         */
        var clientRequestId: String?
        /**
         * ARN of the cluster.
         */
        var clusterArn: String?
        /**
         * The time that the operation was created.
         */
        var creationTime: Instant?
        /**
         * The time at which the operation finished.
         */
        var endTime: Instant?
        /**
         * Describes the error if the operation fails.
         */
        var errorInfo: ErrorInfo?
        /**
         * ARN of the cluster operation.
         */
        var operationArn: String?
        /**
         * State of the cluster operation.
         */
        var operationState: String?
        /**
         * Steps completed during the operation.
         */
        var operationSteps: List<ClusterOperationStep>?
        /**
         * Type of the cluster operation.
         */
        var operationType: String?
        /**
         * Information about cluster attributes before a cluster is updated.
         */
        var sourceClusterInfo: MutableClusterInfo?
        /**
         * Information about cluster attributes after a cluster is updated.
         */
        var targetClusterInfo: MutableClusterInfo?

        fun build(): ClusterOperationInfo
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ErrorInfo] inside the given [block]
         */
        fun errorInfo(block: ErrorInfo.DslBuilder.() -> kotlin.Unit) {
            this.errorInfo = ErrorInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.MutableClusterInfo] inside the given [block]
         */
        fun sourceClusterInfo(block: MutableClusterInfo.DslBuilder.() -> kotlin.Unit) {
            this.sourceClusterInfo = MutableClusterInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.MutableClusterInfo] inside the given [block]
         */
        fun targetClusterInfo(block: MutableClusterInfo.DslBuilder.() -> kotlin.Unit) {
            this.targetClusterInfo = MutableClusterInfo.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var clientRequestId: String? = null
        override var clusterArn: String? = null
        override var creationTime: Instant? = null
        override var endTime: Instant? = null
        override var errorInfo: ErrorInfo? = null
        override var operationArn: String? = null
        override var operationState: String? = null
        override var operationSteps: List<ClusterOperationStep>? = null
        override var operationType: String? = null
        override var sourceClusterInfo: MutableClusterInfo? = null
        override var targetClusterInfo: MutableClusterInfo? = null

        constructor(x: ClusterOperationInfo) : this() {
            this.clientRequestId = x.clientRequestId
            this.clusterArn = x.clusterArn
            this.creationTime = x.creationTime
            this.endTime = x.endTime
            this.errorInfo = x.errorInfo
            this.operationArn = x.operationArn
            this.operationState = x.operationState
            this.operationSteps = x.operationSteps
            this.operationType = x.operationType
            this.sourceClusterInfo = x.sourceClusterInfo
            this.targetClusterInfo = x.targetClusterInfo
        }

        override fun build(): ClusterOperationInfo = ClusterOperationInfo(this)
        override fun clientRequestId(clientRequestId: String): FluentBuilder = apply { this.clientRequestId = clientRequestId }
        override fun clusterArn(clusterArn: String): FluentBuilder = apply { this.clusterArn = clusterArn }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun errorInfo(errorInfo: ErrorInfo): FluentBuilder = apply { this.errorInfo = errorInfo }
        override fun operationArn(operationArn: String): FluentBuilder = apply { this.operationArn = operationArn }
        override fun operationState(operationState: String): FluentBuilder = apply { this.operationState = operationState }
        override fun operationSteps(operationSteps: List<ClusterOperationStep>): FluentBuilder = apply { this.operationSteps = operationSteps }
        override fun operationType(operationType: String): FluentBuilder = apply { this.operationType = operationType }
        override fun sourceClusterInfo(sourceClusterInfo: MutableClusterInfo): FluentBuilder = apply { this.sourceClusterInfo = sourceClusterInfo }
        override fun targetClusterInfo(targetClusterInfo: MutableClusterInfo): FluentBuilder = apply { this.targetClusterInfo = targetClusterInfo }
    }
}
