// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Returns information about a cluster.
 */
class ClusterInfo private constructor(builder: BuilderImpl) {
    /**
     * Arn of active cluster operation.
     */
    val activeOperationArn: String? = builder.activeOperationArn
    /**
     * Information about the broker nodes.
     */
    val brokerNodeGroupInfo: BrokerNodeGroupInfo? = builder.brokerNodeGroupInfo
    /**
     * Includes all client authentication information.
     */
    val clientAuthentication: ClientAuthentication? = builder.clientAuthentication
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     */
    val clusterArn: String? = builder.clusterArn
    /**
     * The name of the cluster.
     */
    val clusterName: String? = builder.clusterName
    /**
     * The time when the cluster was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * Information about the version of software currently deployed on the Kafka brokers in the cluster.
     */
    val currentBrokerSoftwareInfo: BrokerSoftwareInfo? = builder.currentBrokerSoftwareInfo
    /**
     * The current version of the MSK cluster.
     */
    val currentVersion: String? = builder.currentVersion
    /**
     * Includes all encryption-related information.
     */
    val encryptionInfo: EncryptionInfo? = builder.encryptionInfo
    /**
     * Specifies which metrics are gathered for the MSK cluster. This property has the following possible values: DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the metrics associated with each of these levels of monitoring, see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring.
     */
    val enhancedMonitoring: EnhancedMonitoring? = builder.enhancedMonitoring
    val loggingInfo: LoggingInfo? = builder.loggingInfo
    /**
     * The number of broker nodes in the cluster.
     */
    val numberOfBrokerNodes: Int? = builder.numberOfBrokerNodes
    /**
     * Settings for open monitoring using Prometheus.
     */
    val openMonitoring: OpenMonitoring? = builder.openMonitoring
    /**
     * The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and UPDATING.
     */
    val state: ClusterState? = builder.state
    val stateInfo: StateInfo? = builder.stateInfo
    /**
     * Tags attached to the cluster.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The connection string to use to connect to the Apache ZooKeeper cluster.
     */
    val zookeeperConnectString: String? = builder.zookeeperConnectString
    /**
     * The connection string to use to connect to zookeeper cluster on Tls port.
     */
    val zookeeperConnectStringTls: String? = builder.zookeeperConnectStringTls

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ClusterInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterInfo(")
        append("activeOperationArn=$activeOperationArn,")
        append("brokerNodeGroupInfo=$brokerNodeGroupInfo,")
        append("clientAuthentication=$clientAuthentication,")
        append("clusterArn=$clusterArn,")
        append("clusterName=$clusterName,")
        append("creationTime=$creationTime,")
        append("currentBrokerSoftwareInfo=$currentBrokerSoftwareInfo,")
        append("currentVersion=$currentVersion,")
        append("encryptionInfo=$encryptionInfo,")
        append("enhancedMonitoring=$enhancedMonitoring,")
        append("loggingInfo=$loggingInfo,")
        append("numberOfBrokerNodes=$numberOfBrokerNodes,")
        append("openMonitoring=$openMonitoring,")
        append("state=$state,")
        append("stateInfo=$stateInfo,")
        append("tags=$tags,")
        append("zookeeperConnectString=$zookeeperConnectString,")
        append("zookeeperConnectStringTls=$zookeeperConnectStringTls)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeOperationArn?.hashCode() ?: 0
        result = 31 * result + (brokerNodeGroupInfo?.hashCode() ?: 0)
        result = 31 * result + (clientAuthentication?.hashCode() ?: 0)
        result = 31 * result + (clusterArn?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (currentBrokerSoftwareInfo?.hashCode() ?: 0)
        result = 31 * result + (currentVersion?.hashCode() ?: 0)
        result = 31 * result + (encryptionInfo?.hashCode() ?: 0)
        result = 31 * result + (enhancedMonitoring?.hashCode() ?: 0)
        result = 31 * result + (loggingInfo?.hashCode() ?: 0)
        result = 31 * result + (numberOfBrokerNodes ?: 0)
        result = 31 * result + (openMonitoring?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateInfo?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (zookeeperConnectString?.hashCode() ?: 0)
        result = 31 * result + (zookeeperConnectStringTls?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ClusterInfo

        if (activeOperationArn != other.activeOperationArn) return false
        if (brokerNodeGroupInfo != other.brokerNodeGroupInfo) return false
        if (clientAuthentication != other.clientAuthentication) return false
        if (clusterArn != other.clusterArn) return false
        if (clusterName != other.clusterName) return false
        if (creationTime != other.creationTime) return false
        if (currentBrokerSoftwareInfo != other.currentBrokerSoftwareInfo) return false
        if (currentVersion != other.currentVersion) return false
        if (encryptionInfo != other.encryptionInfo) return false
        if (enhancedMonitoring != other.enhancedMonitoring) return false
        if (loggingInfo != other.loggingInfo) return false
        if (numberOfBrokerNodes != other.numberOfBrokerNodes) return false
        if (openMonitoring != other.openMonitoring) return false
        if (state != other.state) return false
        if (stateInfo != other.stateInfo) return false
        if (tags != other.tags) return false
        if (zookeeperConnectString != other.zookeeperConnectString) return false
        if (zookeeperConnectStringTls != other.zookeeperConnectStringTls) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ClusterInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ClusterInfo
        /**
         * Arn of active cluster operation.
         */
        fun activeOperationArn(activeOperationArn: String): FluentBuilder
        /**
         * Information about the broker nodes.
         */
        fun brokerNodeGroupInfo(brokerNodeGroupInfo: BrokerNodeGroupInfo): FluentBuilder
        /**
         * Includes all client authentication information.
         */
        fun clientAuthentication(clientAuthentication: ClientAuthentication): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         */
        fun clusterArn(clusterArn: String): FluentBuilder
        /**
         * The name of the cluster.
         */
        fun clusterName(clusterName: String): FluentBuilder
        /**
         * The time when the cluster was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * Information about the version of software currently deployed on the Kafka brokers in the cluster.
         */
        fun currentBrokerSoftwareInfo(currentBrokerSoftwareInfo: BrokerSoftwareInfo): FluentBuilder
        /**
         * The current version of the MSK cluster.
         */
        fun currentVersion(currentVersion: String): FluentBuilder
        /**
         * Includes all encryption-related information.
         */
        fun encryptionInfo(encryptionInfo: EncryptionInfo): FluentBuilder
        /**
         * Specifies which metrics are gathered for the MSK cluster. This property has the following possible values: DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the metrics associated with each of these levels of monitoring, see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring.
         */
        fun enhancedMonitoring(enhancedMonitoring: EnhancedMonitoring): FluentBuilder
        fun loggingInfo(loggingInfo: LoggingInfo): FluentBuilder
        /**
         * The number of broker nodes in the cluster.
         */
        fun numberOfBrokerNodes(numberOfBrokerNodes: Int): FluentBuilder
        /**
         * Settings for open monitoring using Prometheus.
         */
        fun openMonitoring(openMonitoring: OpenMonitoring): FluentBuilder
        /**
         * The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and UPDATING.
         */
        fun state(state: ClusterState): FluentBuilder
        fun stateInfo(stateInfo: StateInfo): FluentBuilder
        /**
         * Tags attached to the cluster.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The connection string to use to connect to the Apache ZooKeeper cluster.
         */
        fun zookeeperConnectString(zookeeperConnectString: String): FluentBuilder
        /**
         * The connection string to use to connect to zookeeper cluster on Tls port.
         */
        fun zookeeperConnectStringTls(zookeeperConnectStringTls: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Arn of active cluster operation.
         */
        var activeOperationArn: String?
        /**
         * Information about the broker nodes.
         */
        var brokerNodeGroupInfo: BrokerNodeGroupInfo?
        /**
         * Includes all client authentication information.
         */
        var clientAuthentication: ClientAuthentication?
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         */
        var clusterArn: String?
        /**
         * The name of the cluster.
         */
        var clusterName: String?
        /**
         * The time when the cluster was created.
         */
        var creationTime: Instant?
        /**
         * Information about the version of software currently deployed on the Kafka brokers in the cluster.
         */
        var currentBrokerSoftwareInfo: BrokerSoftwareInfo?
        /**
         * The current version of the MSK cluster.
         */
        var currentVersion: String?
        /**
         * Includes all encryption-related information.
         */
        var encryptionInfo: EncryptionInfo?
        /**
         * Specifies which metrics are gathered for the MSK cluster. This property has the following possible values: DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and PER_TOPIC_PER_PARTITION. For a list of the metrics associated with each of these levels of monitoring, see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/monitoring.html">Monitoring.
         */
        var enhancedMonitoring: EnhancedMonitoring?
        var loggingInfo: LoggingInfo?
        /**
         * The number of broker nodes in the cluster.
         */
        var numberOfBrokerNodes: Int?
        /**
         * Settings for open monitoring using Prometheus.
         */
        var openMonitoring: OpenMonitoring?
        /**
         * The state of the cluster. The possible states are ACTIVE, CREATING, DELETING, FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and UPDATING.
         */
        var state: ClusterState?
        var stateInfo: StateInfo?
        /**
         * Tags attached to the cluster.
         */
        var tags: Map<String, String>?
        /**
         * The connection string to use to connect to the Apache ZooKeeper cluster.
         */
        var zookeeperConnectString: String?
        /**
         * The connection string to use to connect to zookeeper cluster on Tls port.
         */
        var zookeeperConnectStringTls: String?

        fun build(): ClusterInfo
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.BrokerNodeGroupInfo] inside the given [block]
         */
        fun brokerNodeGroupInfo(block: BrokerNodeGroupInfo.DslBuilder.() -> kotlin.Unit) {
            this.brokerNodeGroupInfo = BrokerNodeGroupInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ClientAuthentication] inside the given [block]
         */
        fun clientAuthentication(block: ClientAuthentication.DslBuilder.() -> kotlin.Unit) {
            this.clientAuthentication = ClientAuthentication.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.BrokerSoftwareInfo] inside the given [block]
         */
        fun currentBrokerSoftwareInfo(block: BrokerSoftwareInfo.DslBuilder.() -> kotlin.Unit) {
            this.currentBrokerSoftwareInfo = BrokerSoftwareInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.EncryptionInfo] inside the given [block]
         */
        fun encryptionInfo(block: EncryptionInfo.DslBuilder.() -> kotlin.Unit) {
            this.encryptionInfo = EncryptionInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.LoggingInfo] inside the given [block]
         */
        fun loggingInfo(block: LoggingInfo.DslBuilder.() -> kotlin.Unit) {
            this.loggingInfo = LoggingInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.OpenMonitoring] inside the given [block]
         */
        fun openMonitoring(block: OpenMonitoring.DslBuilder.() -> kotlin.Unit) {
            this.openMonitoring = OpenMonitoring.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.StateInfo] inside the given [block]
         */
        fun stateInfo(block: StateInfo.DslBuilder.() -> kotlin.Unit) {
            this.stateInfo = StateInfo.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var activeOperationArn: String? = null
        override var brokerNodeGroupInfo: BrokerNodeGroupInfo? = null
        override var clientAuthentication: ClientAuthentication? = null
        override var clusterArn: String? = null
        override var clusterName: String? = null
        override var creationTime: Instant? = null
        override var currentBrokerSoftwareInfo: BrokerSoftwareInfo? = null
        override var currentVersion: String? = null
        override var encryptionInfo: EncryptionInfo? = null
        override var enhancedMonitoring: EnhancedMonitoring? = null
        override var loggingInfo: LoggingInfo? = null
        override var numberOfBrokerNodes: Int? = null
        override var openMonitoring: OpenMonitoring? = null
        override var state: ClusterState? = null
        override var stateInfo: StateInfo? = null
        override var tags: Map<String, String>? = null
        override var zookeeperConnectString: String? = null
        override var zookeeperConnectStringTls: String? = null

        constructor(x: ClusterInfo) : this() {
            this.activeOperationArn = x.activeOperationArn
            this.brokerNodeGroupInfo = x.brokerNodeGroupInfo
            this.clientAuthentication = x.clientAuthentication
            this.clusterArn = x.clusterArn
            this.clusterName = x.clusterName
            this.creationTime = x.creationTime
            this.currentBrokerSoftwareInfo = x.currentBrokerSoftwareInfo
            this.currentVersion = x.currentVersion
            this.encryptionInfo = x.encryptionInfo
            this.enhancedMonitoring = x.enhancedMonitoring
            this.loggingInfo = x.loggingInfo
            this.numberOfBrokerNodes = x.numberOfBrokerNodes
            this.openMonitoring = x.openMonitoring
            this.state = x.state
            this.stateInfo = x.stateInfo
            this.tags = x.tags
            this.zookeeperConnectString = x.zookeeperConnectString
            this.zookeeperConnectStringTls = x.zookeeperConnectStringTls
        }

        override fun build(): ClusterInfo = ClusterInfo(this)
        override fun activeOperationArn(activeOperationArn: String): FluentBuilder = apply { this.activeOperationArn = activeOperationArn }
        override fun brokerNodeGroupInfo(brokerNodeGroupInfo: BrokerNodeGroupInfo): FluentBuilder = apply { this.brokerNodeGroupInfo = brokerNodeGroupInfo }
        override fun clientAuthentication(clientAuthentication: ClientAuthentication): FluentBuilder = apply { this.clientAuthentication = clientAuthentication }
        override fun clusterArn(clusterArn: String): FluentBuilder = apply { this.clusterArn = clusterArn }
        override fun clusterName(clusterName: String): FluentBuilder = apply { this.clusterName = clusterName }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun currentBrokerSoftwareInfo(currentBrokerSoftwareInfo: BrokerSoftwareInfo): FluentBuilder = apply { this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo }
        override fun currentVersion(currentVersion: String): FluentBuilder = apply { this.currentVersion = currentVersion }
        override fun encryptionInfo(encryptionInfo: EncryptionInfo): FluentBuilder = apply { this.encryptionInfo = encryptionInfo }
        override fun enhancedMonitoring(enhancedMonitoring: EnhancedMonitoring): FluentBuilder = apply { this.enhancedMonitoring = enhancedMonitoring }
        override fun loggingInfo(loggingInfo: LoggingInfo): FluentBuilder = apply { this.loggingInfo = loggingInfo }
        override fun numberOfBrokerNodes(numberOfBrokerNodes: Int): FluentBuilder = apply { this.numberOfBrokerNodes = numberOfBrokerNodes }
        override fun openMonitoring(openMonitoring: OpenMonitoring): FluentBuilder = apply { this.openMonitoring = openMonitoring }
        override fun state(state: ClusterState): FluentBuilder = apply { this.state = state }
        override fun stateInfo(stateInfo: StateInfo): FluentBuilder = apply { this.stateInfo = stateInfo }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun zookeeperConnectString(zookeeperConnectString: String): FluentBuilder = apply { this.zookeeperConnectString = zookeeperConnectString }
        override fun zookeeperConnectStringTls(zookeeperConnectStringTls: String): FluentBuilder = apply { this.zookeeperConnectStringTls = zookeeperConnectStringTls }
    }
}
