// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model



/**
 * BrokerNodeInfo
 */
class BrokerNodeInfo private constructor(builder: BuilderImpl) {
    /**
     * The attached elastic network interface of the broker.
     */
    val attachedEniId: String? = builder.attachedEniId
    /**
     * The ID of the broker.
     */
    val brokerId: Double? = builder.brokerId
    /**
     * The client subnet to which this broker node belongs.
     */
    val clientSubnet: String? = builder.clientSubnet
    /**
     * The virtual private cloud (VPC) of the client.
     */
    val clientVpcIpAddress: String? = builder.clientVpcIpAddress
    /**
     * Information about the version of software currently deployed on the Kafka brokers in the cluster.
     */
    val currentBrokerSoftwareInfo: BrokerSoftwareInfo? = builder.currentBrokerSoftwareInfo
    /**
     * Endpoints for accessing the broker.
     */
    val endpoints: List<String>? = builder.endpoints

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BrokerNodeInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BrokerNodeInfo(")
        append("attachedEniId=$attachedEniId,")
        append("brokerId=$brokerId,")
        append("clientSubnet=$clientSubnet,")
        append("clientVpcIpAddress=$clientVpcIpAddress,")
        append("currentBrokerSoftwareInfo=$currentBrokerSoftwareInfo,")
        append("endpoints=$endpoints)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachedEniId?.hashCode() ?: 0
        result = 31 * result + (brokerId?.hashCode() ?: 0)
        result = 31 * result + (clientSubnet?.hashCode() ?: 0)
        result = 31 * result + (clientVpcIpAddress?.hashCode() ?: 0)
        result = 31 * result + (currentBrokerSoftwareInfo?.hashCode() ?: 0)
        result = 31 * result + (endpoints?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BrokerNodeInfo

        if (attachedEniId != other.attachedEniId) return false
        if (brokerId != other.brokerId) return false
        if (clientSubnet != other.clientSubnet) return false
        if (clientVpcIpAddress != other.clientVpcIpAddress) return false
        if (currentBrokerSoftwareInfo != other.currentBrokerSoftwareInfo) return false
        if (endpoints != other.endpoints) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BrokerNodeInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BrokerNodeInfo
        /**
         * The attached elastic network interface of the broker.
         */
        fun attachedEniId(attachedEniId: String): FluentBuilder
        /**
         * The ID of the broker.
         */
        fun brokerId(brokerId: Double): FluentBuilder
        /**
         * The client subnet to which this broker node belongs.
         */
        fun clientSubnet(clientSubnet: String): FluentBuilder
        /**
         * The virtual private cloud (VPC) of the client.
         */
        fun clientVpcIpAddress(clientVpcIpAddress: String): FluentBuilder
        /**
         * Information about the version of software currently deployed on the Kafka brokers in the cluster.
         */
        fun currentBrokerSoftwareInfo(currentBrokerSoftwareInfo: BrokerSoftwareInfo): FluentBuilder
        /**
         * Endpoints for accessing the broker.
         */
        fun endpoints(endpoints: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The attached elastic network interface of the broker.
         */
        var attachedEniId: String?
        /**
         * The ID of the broker.
         */
        var brokerId: Double?
        /**
         * The client subnet to which this broker node belongs.
         */
        var clientSubnet: String?
        /**
         * The virtual private cloud (VPC) of the client.
         */
        var clientVpcIpAddress: String?
        /**
         * Information about the version of software currently deployed on the Kafka brokers in the cluster.
         */
        var currentBrokerSoftwareInfo: BrokerSoftwareInfo?
        /**
         * Endpoints for accessing the broker.
         */
        var endpoints: List<String>?

        fun build(): BrokerNodeInfo
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.BrokerSoftwareInfo] inside the given [block]
         */
        fun currentBrokerSoftwareInfo(block: BrokerSoftwareInfo.DslBuilder.() -> kotlin.Unit) {
            this.currentBrokerSoftwareInfo = BrokerSoftwareInfo.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attachedEniId: String? = null
        override var brokerId: Double? = null
        override var clientSubnet: String? = null
        override var clientVpcIpAddress: String? = null
        override var currentBrokerSoftwareInfo: BrokerSoftwareInfo? = null
        override var endpoints: List<String>? = null

        constructor(x: BrokerNodeInfo) : this() {
            this.attachedEniId = x.attachedEniId
            this.brokerId = x.brokerId
            this.clientSubnet = x.clientSubnet
            this.clientVpcIpAddress = x.clientVpcIpAddress
            this.currentBrokerSoftwareInfo = x.currentBrokerSoftwareInfo
            this.endpoints = x.endpoints
        }

        override fun build(): BrokerNodeInfo = BrokerNodeInfo(this)
        override fun attachedEniId(attachedEniId: String): FluentBuilder = apply { this.attachedEniId = attachedEniId }
        override fun brokerId(brokerId: Double): FluentBuilder = apply { this.brokerId = brokerId }
        override fun clientSubnet(clientSubnet: String): FluentBuilder = apply { this.clientSubnet = clientSubnet }
        override fun clientVpcIpAddress(clientVpcIpAddress: String): FluentBuilder = apply { this.clientVpcIpAddress = clientVpcIpAddress }
        override fun currentBrokerSoftwareInfo(currentBrokerSoftwareInfo: BrokerSoftwareInfo): FluentBuilder = apply { this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo }
        override fun endpoints(endpoints: List<String>): FluentBuilder = apply { this.endpoints = endpoints }
    }
}
