// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model



/**
 * Describes the setup to be used for Kafka broker nodes in the cluster.
 */
class BrokerNodeGroupInfo private constructor(builder: BuilderImpl) {
    /**
     * The distribution of broker nodes across Availability Zones. This is an optional parameter. If you don't specify it, Amazon MSK gives it the value DEFAULT. You can also explicitly set this parameter to the value DEFAULT. No other values are currently allowed.
     * Amazon MSK distributes the broker nodes evenly across the Availability Zones that correspond to the subnets you provide when you create the cluster.
     */
    val brokerAzDistribution: BrokerAzDistribution? = builder.brokerAzDistribution
    /**
     * The list of subnets to connect to in the client virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets. Client applications use elastic network interfaces to produce and consume data. Client subnets can't be in Availability Zone us-east-1e.
     */
    val clientSubnets: List<String>? = builder.clientSubnets
    /**
     * The type of Amazon EC2 instances to use for Kafka brokers. The following instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge,
     * kafka.m5.4xlarge, kafka.m5.12xlarge, and kafka.m5.24xlarge.
     */
    val instanceType: String? = builder.instanceType
    /**
     * The AWS security groups to associate with the elastic network interfaces in order to specify who can connect to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon MSK uses the default security group associated with the VPC.
     */
    val securityGroups: List<String>? = builder.securityGroups
    /**
     * Contains information about storage volumes attached to MSK broker nodes.
     */
    val storageInfo: StorageInfo? = builder.storageInfo

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BrokerNodeGroupInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BrokerNodeGroupInfo(")
        append("brokerAzDistribution=$brokerAzDistribution,")
        append("clientSubnets=$clientSubnets,")
        append("instanceType=$instanceType,")
        append("securityGroups=$securityGroups,")
        append("storageInfo=$storageInfo)")
    }

    override fun hashCode(): kotlin.Int {
        var result = brokerAzDistribution?.hashCode() ?: 0
        result = 31 * result + (clientSubnets?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (storageInfo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BrokerNodeGroupInfo

        if (brokerAzDistribution != other.brokerAzDistribution) return false
        if (clientSubnets != other.clientSubnets) return false
        if (instanceType != other.instanceType) return false
        if (securityGroups != other.securityGroups) return false
        if (storageInfo != other.storageInfo) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BrokerNodeGroupInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BrokerNodeGroupInfo
        /**
         * The distribution of broker nodes across Availability Zones. This is an optional parameter. If you don't specify it, Amazon MSK gives it the value DEFAULT. You can also explicitly set this parameter to the value DEFAULT. No other values are currently allowed.
         * Amazon MSK distributes the broker nodes evenly across the Availability Zones that correspond to the subnets you provide when you create the cluster.
         */
        fun brokerAzDistribution(brokerAzDistribution: BrokerAzDistribution): FluentBuilder
        /**
         * The list of subnets to connect to in the client virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets. Client applications use elastic network interfaces to produce and consume data. Client subnets can't be in Availability Zone us-east-1e.
         */
        fun clientSubnets(clientSubnets: List<String>): FluentBuilder
        /**
         * The type of Amazon EC2 instances to use for Kafka brokers. The following instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge,
         * kafka.m5.4xlarge, kafka.m5.12xlarge, and kafka.m5.24xlarge.
         */
        fun instanceType(instanceType: String): FluentBuilder
        /**
         * The AWS security groups to associate with the elastic network interfaces in order to specify who can connect to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon MSK uses the default security group associated with the VPC.
         */
        fun securityGroups(securityGroups: List<String>): FluentBuilder
        /**
         * Contains information about storage volumes attached to MSK broker nodes.
         */
        fun storageInfo(storageInfo: StorageInfo): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The distribution of broker nodes across Availability Zones. This is an optional parameter. If you don't specify it, Amazon MSK gives it the value DEFAULT. You can also explicitly set this parameter to the value DEFAULT. No other values are currently allowed.
         * Amazon MSK distributes the broker nodes evenly across the Availability Zones that correspond to the subnets you provide when you create the cluster.
         */
        var brokerAzDistribution: BrokerAzDistribution?
        /**
         * The list of subnets to connect to in the client virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets. Client applications use elastic network interfaces to produce and consume data. Client subnets can't be in Availability Zone us-east-1e.
         */
        var clientSubnets: List<String>?
        /**
         * The type of Amazon EC2 instances to use for Kafka brokers. The following instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge,
         * kafka.m5.4xlarge, kafka.m5.12xlarge, and kafka.m5.24xlarge.
         */
        var instanceType: String?
        /**
         * The AWS security groups to associate with the elastic network interfaces in order to specify who can connect to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon MSK uses the default security group associated with the VPC.
         */
        var securityGroups: List<String>?
        /**
         * Contains information about storage volumes attached to MSK broker nodes.
         */
        var storageInfo: StorageInfo?

        fun build(): BrokerNodeGroupInfo
        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.StorageInfo] inside the given [block]
         */
        fun storageInfo(block: StorageInfo.DslBuilder.() -> kotlin.Unit) {
            this.storageInfo = StorageInfo.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var brokerAzDistribution: BrokerAzDistribution? = null
        override var clientSubnets: List<String>? = null
        override var instanceType: String? = null
        override var securityGroups: List<String>? = null
        override var storageInfo: StorageInfo? = null

        constructor(x: BrokerNodeGroupInfo) : this() {
            this.brokerAzDistribution = x.brokerAzDistribution
            this.clientSubnets = x.clientSubnets
            this.instanceType = x.instanceType
            this.securityGroups = x.securityGroups
            this.storageInfo = x.storageInfo
        }

        override fun build(): BrokerNodeGroupInfo = BrokerNodeGroupInfo(this)
        override fun brokerAzDistribution(brokerAzDistribution: BrokerAzDistribution): FluentBuilder = apply { this.brokerAzDistribution = brokerAzDistribution }
        override fun clientSubnets(clientSubnets: List<String>): FluentBuilder = apply { this.clientSubnets = clientSubnets }
        override fun instanceType(instanceType: String): FluentBuilder = apply { this.instanceType = instanceType }
        override fun securityGroups(securityGroups: List<String>): FluentBuilder = apply { this.securityGroups = securityGroups }
        override fun storageInfo(storageInfo: StorageInfo): FluentBuilder = apply { this.storageInfo = storageInfo }
    }
}
