// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka

import aws.sdk.kotlin.runtime.auth.AuthConfig
import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.runtime.region.RegionConfig
import aws.sdk.kotlin.services.kafka.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * The operations for managing an Amazon MSK cluster.
 */
interface KafkaClient : SdkClient {

    override val serviceName: String
        get() = "Kafka"
    /**
     * KafkaClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.DslBuilder.() -> Unit = {}): KafkaClient {
            val config = Config.BuilderImpl().apply(block).build()
            return DefaultKafkaClient(config)
        }
    }

    class Config private constructor(builder: BuilderImpl): AuthConfig, HttpClientConfig, RegionConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider? = builder.credentialsProvider
        val endpointResolver: EndpointResolver? = builder.endpointResolver
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String? = builder.region
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val signingRegion: String? = builder.signingRegion

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun signingRegion(signingRegion: String): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client configuration (e.g. configure proxy behavior, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

            /**
             * AWS region to be used for signing the request. This is not necessarily the same as `region`
             * in the case of global services like IAM
             */
            var signingRegion: String?

            fun build(): Config
        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default
            override var signingRegion: String? = null

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
            override fun signingRegion(signingRegion: String): FluentBuilder = apply { this.signingRegion = signingRegion }
        }
    }

    /**
     * Associates one or more Scram Secrets with an Amazon MSK cluster.
     */
    suspend fun batchAssociateScramSecret(input: BatchAssociateScramSecretRequest): BatchAssociateScramSecretResponse

    /**
     * Associates one or more Scram Secrets with an Amazon MSK cluster.
     */
    suspend fun batchAssociateScramSecret(block: BatchAssociateScramSecretRequest.DslBuilder.() -> Unit) = batchAssociateScramSecret(BatchAssociateScramSecretRequest.builder().apply(block).build())

    /**
     * Disassociates one or more Scram Secrets from an Amazon MSK cluster.
     */
    suspend fun batchDisassociateScramSecret(input: BatchDisassociateScramSecretRequest): BatchDisassociateScramSecretResponse

    /**
     * Disassociates one or more Scram Secrets from an Amazon MSK cluster.
     */
    suspend fun batchDisassociateScramSecret(block: BatchDisassociateScramSecretRequest.DslBuilder.() -> Unit) = batchDisassociateScramSecret(BatchDisassociateScramSecretRequest.builder().apply(block).build())

    /**
     * Creates a new MSK cluster.
     */
    suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates a new MSK cluster.
     */
    suspend fun createCluster(block: CreateClusterRequest.DslBuilder.() -> Unit) = createCluster(CreateClusterRequest.builder().apply(block).build())

    /**
     * Creates a new MSK configuration.
     */
    suspend fun createConfiguration(input: CreateConfigurationRequest): CreateConfigurationResponse

    /**
     * Creates a new MSK configuration.
     */
    suspend fun createConfiguration(block: CreateConfigurationRequest.DslBuilder.() -> Unit) = createConfiguration(CreateConfigurationRequest.builder().apply(block).build())

    /**
     * Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.
     */
    suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.
     */
    suspend fun deleteCluster(block: DeleteClusterRequest.DslBuilder.() -> Unit) = deleteCluster(DeleteClusterRequest.builder().apply(block).build())

    /**
     * Deletes an MSK Configuration.
     */
    suspend fun deleteConfiguration(input: DeleteConfigurationRequest): DeleteConfigurationResponse

    /**
     * Deletes an MSK Configuration.
     */
    suspend fun deleteConfiguration(block: DeleteConfigurationRequest.DslBuilder.() -> Unit) = deleteConfiguration(DeleteConfigurationRequest.builder().apply(block).build())

    /**
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     */
    suspend fun describeCluster(input: DescribeClusterRequest): DescribeClusterResponse

    /**
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     */
    suspend fun describeCluster(block: DescribeClusterRequest.DslBuilder.() -> Unit) = describeCluster(DescribeClusterRequest.builder().apply(block).build())

    /**
     * Returns a description of the cluster operation specified by the ARN.
     */
    suspend fun describeClusterOperation(input: DescribeClusterOperationRequest): DescribeClusterOperationResponse

    /**
     * Returns a description of the cluster operation specified by the ARN.
     */
    suspend fun describeClusterOperation(block: DescribeClusterOperationRequest.DslBuilder.() -> Unit) = describeClusterOperation(DescribeClusterOperationRequest.builder().apply(block).build())

    /**
     * Returns a description of this MSK configuration.
     */
    suspend fun describeConfiguration(input: DescribeConfigurationRequest): DescribeConfigurationResponse

    /**
     * Returns a description of this MSK configuration.
     */
    suspend fun describeConfiguration(block: DescribeConfigurationRequest.DslBuilder.() -> Unit) = describeConfiguration(DescribeConfigurationRequest.builder().apply(block).build())

    /**
     * Returns a description of this revision of the configuration.
     */
    suspend fun describeConfigurationRevision(input: DescribeConfigurationRevisionRequest): DescribeConfigurationRevisionResponse

    /**
     * Returns a description of this revision of the configuration.
     */
    suspend fun describeConfigurationRevision(block: DescribeConfigurationRevisionRequest.DslBuilder.() -> Unit) = describeConfigurationRevision(DescribeConfigurationRevisionRequest.builder().apply(block).build())

    /**
     * A list of brokers that a client application can use to bootstrap.
     */
    suspend fun getBootstrapBrokers(input: GetBootstrapBrokersRequest): GetBootstrapBrokersResponse

    /**
     * A list of brokers that a client application can use to bootstrap.
     */
    suspend fun getBootstrapBrokers(block: GetBootstrapBrokersRequest.DslBuilder.() -> Unit) = getBootstrapBrokers(GetBootstrapBrokersRequest.builder().apply(block).build())

    /**
     * Gets the Apache Kafka versions to which you can update the MSK cluster.
     */
    suspend fun getCompatibleKafkaVersions(input: GetCompatibleKafkaVersionsRequest): GetCompatibleKafkaVersionsResponse

    /**
     * Gets the Apache Kafka versions to which you can update the MSK cluster.
     */
    suspend fun getCompatibleKafkaVersions(block: GetCompatibleKafkaVersionsRequest.DslBuilder.() -> Unit) = getCompatibleKafkaVersions(GetCompatibleKafkaVersionsRequest.builder().apply(block).build())

    /**
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     */
    suspend fun listClusterOperations(input: ListClusterOperationsRequest): ListClusterOperationsResponse

    /**
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     */
    suspend fun listClusterOperations(block: ListClusterOperationsRequest.DslBuilder.() -> Unit) = listClusterOperations(ListClusterOperationsRequest.builder().apply(block).build())

    /**
     * Returns a list of all the MSK clusters in the current Region.
     */
    suspend fun listClusters(input: ListClustersRequest): ListClustersResponse

    /**
     * Returns a list of all the MSK clusters in the current Region.
     */
    suspend fun listClusters(block: ListClustersRequest.DslBuilder.() -> Unit) = listClusters(ListClustersRequest.builder().apply(block).build())

    /**
     * Returns a list of all the MSK configurations in this Region.
     */
    suspend fun listConfigurationRevisions(input: ListConfigurationRevisionsRequest): ListConfigurationRevisionsResponse

    /**
     * Returns a list of all the MSK configurations in this Region.
     */
    suspend fun listConfigurationRevisions(block: ListConfigurationRevisionsRequest.DslBuilder.() -> Unit) = listConfigurationRevisions(ListConfigurationRevisionsRequest.builder().apply(block).build())

    /**
     * Returns a list of all the MSK configurations in this Region.
     */
    suspend fun listConfigurations(input: ListConfigurationsRequest): ListConfigurationsResponse

    /**
     * Returns a list of all the MSK configurations in this Region.
     */
    suspend fun listConfigurations(block: ListConfigurationsRequest.DslBuilder.() -> Unit) = listConfigurations(ListConfigurationsRequest.builder().apply(block).build())

    /**
     * Returns a list of Kafka versions.
     */
    suspend fun listKafkaVersions(input: ListKafkaVersionsRequest): ListKafkaVersionsResponse

    /**
     * Returns a list of Kafka versions.
     */
    suspend fun listKafkaVersions(block: ListKafkaVersionsRequest.DslBuilder.() -> Unit) = listKafkaVersions(ListKafkaVersionsRequest.builder().apply(block).build())

    /**
     * Returns a list of the broker nodes in the cluster.
     */
    suspend fun listNodes(input: ListNodesRequest): ListNodesResponse

    /**
     * Returns a list of the broker nodes in the cluster.
     */
    suspend fun listNodes(block: ListNodesRequest.DslBuilder.() -> Unit) = listNodes(ListNodesRequest.builder().apply(block).build())

    /**
     * Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
     */
    suspend fun listScramSecrets(input: ListScramSecretsRequest): ListScramSecretsResponse

    /**
     * Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
     */
    suspend fun listScramSecrets(block: ListScramSecretsRequest.DslBuilder.() -> Unit) = listScramSecrets(ListScramSecretsRequest.builder().apply(block).build())

    /**
     * Returns a list of the tags associated with the specified resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of the tags associated with the specified resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Reboots brokers.
     */
    suspend fun rebootBroker(input: RebootBrokerRequest): RebootBrokerResponse

    /**
     * Reboots brokers.
     */
    suspend fun rebootBroker(block: RebootBrokerRequest.DslBuilder.() -> Unit) = rebootBroker(RebootBrokerRequest.builder().apply(block).build())

    /**
     * Adds tags to the specified MSK resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds tags to the specified MSK resource.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Removes the tags associated with the keys that are provided in the query.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the tags associated with the keys that are provided in the query.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates the number of broker nodes in the cluster.
     */
    suspend fun updateBrokerCount(input: UpdateBrokerCountRequest): UpdateBrokerCountResponse

    /**
     * Updates the number of broker nodes in the cluster.
     */
    suspend fun updateBrokerCount(block: UpdateBrokerCountRequest.DslBuilder.() -> Unit) = updateBrokerCount(UpdateBrokerCountRequest.builder().apply(block).build())

    /**
     * Updates the EBS storage associated with MSK brokers.
     */
    suspend fun updateBrokerStorage(input: UpdateBrokerStorageRequest): UpdateBrokerStorageResponse

    /**
     * Updates the EBS storage associated with MSK brokers.
     */
    suspend fun updateBrokerStorage(block: UpdateBrokerStorageRequest.DslBuilder.() -> Unit) = updateBrokerStorage(UpdateBrokerStorageRequest.builder().apply(block).build())

    /**
     * Updates EC2 instance type.
     */
    suspend fun updateBrokerType(input: UpdateBrokerTypeRequest): UpdateBrokerTypeResponse

    /**
     * Updates EC2 instance type.
     */
    suspend fun updateBrokerType(block: UpdateBrokerTypeRequest.DslBuilder.() -> Unit) = updateBrokerType(UpdateBrokerTypeRequest.builder().apply(block).build())

    /**
     * Updates the cluster with the configuration that is specified in the request body.
     */
    suspend fun updateClusterConfiguration(input: UpdateClusterConfigurationRequest): UpdateClusterConfigurationResponse

    /**
     * Updates the cluster with the configuration that is specified in the request body.
     */
    suspend fun updateClusterConfiguration(block: UpdateClusterConfigurationRequest.DslBuilder.() -> Unit) = updateClusterConfiguration(UpdateClusterConfigurationRequest.builder().apply(block).build())

    /**
     * Updates the Apache Kafka version for the cluster.
     */
    suspend fun updateClusterKafkaVersion(input: UpdateClusterKafkaVersionRequest): UpdateClusterKafkaVersionResponse

    /**
     * Updates the Apache Kafka version for the cluster.
     */
    suspend fun updateClusterKafkaVersion(block: UpdateClusterKafkaVersionRequest.DslBuilder.() -> Unit) = updateClusterKafkaVersion(UpdateClusterKafkaVersionRequest.builder().apply(block).build())

    /**
     * Updates an MSK configuration.
     */
    suspend fun updateConfiguration(input: UpdateConfigurationRequest): UpdateConfigurationResponse

    /**
     * Updates an MSK configuration.
     */
    suspend fun updateConfiguration(block: UpdateConfigurationRequest.DslBuilder.() -> Unit) = updateConfiguration(UpdateConfigurationRequest.builder().apply(block).build())

    /**
     * Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.
     */
    suspend fun updateMonitoring(input: UpdateMonitoringRequest): UpdateMonitoringResponse

    /**
     * Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.
     */
    suspend fun updateMonitoring(block: UpdateMonitoringRequest.DslBuilder.() -> Unit) = updateMonitoring(UpdateMonitoringRequest.builder().apply(block).build())

    /**
     * Updates the security settings for the cluster. You can use this operation to specify encryption and authentication on existing clusters.
     */
    suspend fun updateSecurity(input: UpdateSecurityRequest): UpdateSecurityResponse

    /**
     * Updates the security settings for the cluster. You can use this operation to specify encryption and authentication on existing clusters.
     */
    suspend fun updateSecurity(block: UpdateSecurityRequest.DslBuilder.() -> Unit) = updateSecurity(UpdateSecurityRequest.builder().apply(block).build())
}
