// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeReplicatorResponse private constructor(builder: Builder) {
    /**
     * The time when the replicator was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The current version number of the replicator.
     */
    public val currentVersion: kotlin.String? = builder.currentVersion
    /**
     * Whether this resource is a replicator reference.
     */
    public val isReplicatorReference: kotlin.Boolean? = builder.isReplicatorReference
    /**
     * Kafka Clusters used in setting up sources / targets for replication.
     */
    public val kafkaClusters: List<KafkaClusterDescription>? = builder.kafkaClusters
    /**
     * A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
     */
    public val replicationInfoList: List<ReplicationInfoDescription>? = builder.replicationInfoList
    /**
     * The Amazon Resource Name (ARN) of the replicator.
     */
    public val replicatorArn: kotlin.String? = builder.replicatorArn
    /**
     * The description of the replicator.
     */
    public val replicatorDescription: kotlin.String? = builder.replicatorDescription
    /**
     * The name of the replicator.
     */
    public val replicatorName: kotlin.String? = builder.replicatorName
    /**
     * The Amazon Resource Name (ARN) of the replicator resource in the region where the replicator was created.
     */
    public val replicatorResourceArn: kotlin.String? = builder.replicatorResourceArn
    /**
     * State of the replicator.
     */
    public val replicatorState: aws.sdk.kotlin.services.kafka.model.ReplicatorState? = builder.replicatorState
    /**
     * The Amazon Resource Name (ARN) of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters)
     */
    public val serviceExecutionRoleArn: kotlin.String? = builder.serviceExecutionRoleArn
    /**
     * Details about the state of the replicator.
     */
    public val stateInfo: aws.sdk.kotlin.services.kafka.model.ReplicationStateInfo? = builder.stateInfo
    /**
     * List of tags attached to the Replicator.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.DescribeReplicatorResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeReplicatorResponse(")
        append("creationTime=$creationTime,")
        append("currentVersion=$currentVersion,")
        append("isReplicatorReference=$isReplicatorReference,")
        append("kafkaClusters=$kafkaClusters,")
        append("replicationInfoList=$replicationInfoList,")
        append("replicatorArn=$replicatorArn,")
        append("replicatorDescription=$replicatorDescription,")
        append("replicatorName=$replicatorName,")
        append("replicatorResourceArn=$replicatorResourceArn,")
        append("replicatorState=$replicatorState,")
        append("serviceExecutionRoleArn=$serviceExecutionRoleArn,")
        append("stateInfo=$stateInfo,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (currentVersion?.hashCode() ?: 0)
        result = 31 * result + (isReplicatorReference?.hashCode() ?: 0)
        result = 31 * result + (kafkaClusters?.hashCode() ?: 0)
        result = 31 * result + (replicationInfoList?.hashCode() ?: 0)
        result = 31 * result + (replicatorArn?.hashCode() ?: 0)
        result = 31 * result + (replicatorDescription?.hashCode() ?: 0)
        result = 31 * result + (replicatorName?.hashCode() ?: 0)
        result = 31 * result + (replicatorResourceArn?.hashCode() ?: 0)
        result = 31 * result + (replicatorState?.hashCode() ?: 0)
        result = 31 * result + (serviceExecutionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (stateInfo?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeReplicatorResponse

        if (creationTime != other.creationTime) return false
        if (currentVersion != other.currentVersion) return false
        if (isReplicatorReference != other.isReplicatorReference) return false
        if (kafkaClusters != other.kafkaClusters) return false
        if (replicationInfoList != other.replicationInfoList) return false
        if (replicatorArn != other.replicatorArn) return false
        if (replicatorDescription != other.replicatorDescription) return false
        if (replicatorName != other.replicatorName) return false
        if (replicatorResourceArn != other.replicatorResourceArn) return false
        if (replicatorState != other.replicatorState) return false
        if (serviceExecutionRoleArn != other.serviceExecutionRoleArn) return false
        if (stateInfo != other.stateInfo) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.DescribeReplicatorResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time when the replicator was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current version number of the replicator.
         */
        public var currentVersion: kotlin.String? = null
        /**
         * Whether this resource is a replicator reference.
         */
        public var isReplicatorReference: kotlin.Boolean? = null
        /**
         * Kafka Clusters used in setting up sources / targets for replication.
         */
        public var kafkaClusters: List<KafkaClusterDescription>? = null
        /**
         * A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
         */
        public var replicationInfoList: List<ReplicationInfoDescription>? = null
        /**
         * The Amazon Resource Name (ARN) of the replicator.
         */
        public var replicatorArn: kotlin.String? = null
        /**
         * The description of the replicator.
         */
        public var replicatorDescription: kotlin.String? = null
        /**
         * The name of the replicator.
         */
        public var replicatorName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the replicator resource in the region where the replicator was created.
         */
        public var replicatorResourceArn: kotlin.String? = null
        /**
         * State of the replicator.
         */
        public var replicatorState: aws.sdk.kotlin.services.kafka.model.ReplicatorState? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters)
         */
        public var serviceExecutionRoleArn: kotlin.String? = null
        /**
         * Details about the state of the replicator.
         */
        public var stateInfo: aws.sdk.kotlin.services.kafka.model.ReplicationStateInfo? = null
        /**
         * List of tags attached to the Replicator.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.DescribeReplicatorResponse) : this() {
            this.creationTime = x.creationTime
            this.currentVersion = x.currentVersion
            this.isReplicatorReference = x.isReplicatorReference
            this.kafkaClusters = x.kafkaClusters
            this.replicationInfoList = x.replicationInfoList
            this.replicatorArn = x.replicatorArn
            this.replicatorDescription = x.replicatorDescription
            this.replicatorName = x.replicatorName
            this.replicatorResourceArn = x.replicatorResourceArn
            this.replicatorState = x.replicatorState
            this.serviceExecutionRoleArn = x.serviceExecutionRoleArn
            this.stateInfo = x.stateInfo
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.DescribeReplicatorResponse = DescribeReplicatorResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ReplicationStateInfo] inside the given [block]
         */
        public fun stateInfo(block: aws.sdk.kotlin.services.kafka.model.ReplicationStateInfo.Builder.() -> kotlin.Unit) {
            this.stateInfo = aws.sdk.kotlin.services.kafka.model.ReplicationStateInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
