// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.serde

import aws.sdk.kotlin.services.kafka.model.GetBootstrapBrokersResponse
import aws.sdk.kotlin.services.kafka.model.KafkaException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetBootstrapBrokersOperationDeserializer: HttpDeserializer.NonStreaming<GetBootstrapBrokersResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetBootstrapBrokersResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetBootstrapBrokersError(context, call, payload)
        }
        val builder = GetBootstrapBrokersResponse.Builder()

        if (payload != null) {
            deserializeGetBootstrapBrokersOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetBootstrapBrokersError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KafkaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KafkaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBootstrapBrokersOperationBody(builder: GetBootstrapBrokersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOOTSTRAPBROKERSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerString"))
    val BOOTSTRAPBROKERSTRINGPUBLICSASLIAM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringPublicSaslIam"))
    val BOOTSTRAPBROKERSTRINGPUBLICSASLSCRAM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringPublicSaslScram"))
    val BOOTSTRAPBROKERSTRINGPUBLICTLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringPublicTls"))
    val BOOTSTRAPBROKERSTRINGSASLIAM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringSaslIam"))
    val BOOTSTRAPBROKERSTRINGSASLSCRAM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringSaslScram"))
    val BOOTSTRAPBROKERSTRINGTLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringTls"))
    val BOOTSTRAPBROKERSTRINGVPCCONNECTIVITYSASLIAM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringVpcConnectivitySaslIam"))
    val BOOTSTRAPBROKERSTRINGVPCCONNECTIVITYSASLSCRAM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringVpcConnectivitySaslScram"))
    val BOOTSTRAPBROKERSTRINGVPCCONNECTIVITYTLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringVpcConnectivityTls"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOOTSTRAPBROKERSTRING_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGPUBLICSASLIAM_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGPUBLICSASLSCRAM_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGPUBLICTLS_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGSASLIAM_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGSASLSCRAM_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGTLS_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGVPCCONNECTIVITYSASLIAM_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGVPCCONNECTIVITYSASLSCRAM_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGVPCCONNECTIVITYTLS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOOTSTRAPBROKERSTRING_DESCRIPTOR.index -> builder.bootstrapBrokerString = deserializeString()
                BOOTSTRAPBROKERSTRINGPUBLICSASLIAM_DESCRIPTOR.index -> builder.bootstrapBrokerStringPublicSaslIam = deserializeString()
                BOOTSTRAPBROKERSTRINGPUBLICSASLSCRAM_DESCRIPTOR.index -> builder.bootstrapBrokerStringPublicSaslScram = deserializeString()
                BOOTSTRAPBROKERSTRINGPUBLICTLS_DESCRIPTOR.index -> builder.bootstrapBrokerStringPublicTls = deserializeString()
                BOOTSTRAPBROKERSTRINGSASLIAM_DESCRIPTOR.index -> builder.bootstrapBrokerStringSaslIam = deserializeString()
                BOOTSTRAPBROKERSTRINGSASLSCRAM_DESCRIPTOR.index -> builder.bootstrapBrokerStringSaslScram = deserializeString()
                BOOTSTRAPBROKERSTRINGTLS_DESCRIPTOR.index -> builder.bootstrapBrokerStringTls = deserializeString()
                BOOTSTRAPBROKERSTRINGVPCCONNECTIVITYSASLIAM_DESCRIPTOR.index -> builder.bootstrapBrokerStringVpcConnectivitySaslIam = deserializeString()
                BOOTSTRAPBROKERSTRINGVPCCONNECTIVITYSASLSCRAM_DESCRIPTOR.index -> builder.bootstrapBrokerStringVpcConnectivitySaslScram = deserializeString()
                BOOTSTRAPBROKERSTRINGVPCCONNECTIVITYTLS_DESCRIPTOR.index -> builder.bootstrapBrokerStringVpcConnectivityTls = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
