// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Creates a replicator using the specified configuration.
 */
public class CreateReplicatorRequest private constructor(builder: Builder) {
    /**
     * A summary description of the replicator.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Kafka Clusters to use in setting up sources / targets for replication.
     */
    public val kafkaClusters: List<KafkaCluster>? = builder.kafkaClusters
    /**
     * A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
     */
    public val replicationInfoList: List<ReplicationInfo>? = builder.replicationInfoList
    /**
     * The name of the replicator. Alpha-numeric characters with '-' are allowed.
     */
    public val replicatorName: kotlin.String? = builder.replicatorName
    /**
     * The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters)
     */
    public val serviceExecutionRoleArn: kotlin.String? = builder.serviceExecutionRoleArn
    /**
     * List of tags to attach to created Replicator.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.CreateReplicatorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateReplicatorRequest(")
        append("description=$description,")
        append("kafkaClusters=$kafkaClusters,")
        append("replicationInfoList=$replicationInfoList,")
        append("replicatorName=$replicatorName,")
        append("serviceExecutionRoleArn=$serviceExecutionRoleArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (kafkaClusters?.hashCode() ?: 0)
        result = 31 * result + (replicationInfoList?.hashCode() ?: 0)
        result = 31 * result + (replicatorName?.hashCode() ?: 0)
        result = 31 * result + (serviceExecutionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateReplicatorRequest

        if (description != other.description) return false
        if (kafkaClusters != other.kafkaClusters) return false
        if (replicationInfoList != other.replicationInfoList) return false
        if (replicatorName != other.replicatorName) return false
        if (serviceExecutionRoleArn != other.serviceExecutionRoleArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.CreateReplicatorRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A summary description of the replicator.
         */
        public var description: kotlin.String? = null
        /**
         * Kafka Clusters to use in setting up sources / targets for replication.
         */
        public var kafkaClusters: List<KafkaCluster>? = null
        /**
         * A list of replication configurations, where each configuration targets a given source cluster to target cluster replication flow.
         */
        public var replicationInfoList: List<ReplicationInfo>? = null
        /**
         * The name of the replicator. Alpha-numeric characters with '-' are allowed.
         */
        public var replicatorName: kotlin.String? = null
        /**
         * The ARN of the IAM role used by the replicator to access resources in the customer's account (e.g source and target clusters)
         */
        public var serviceExecutionRoleArn: kotlin.String? = null
        /**
         * List of tags to attach to created Replicator.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.CreateReplicatorRequest) : this() {
            this.description = x.description
            this.kafkaClusters = x.kafkaClusters
            this.replicationInfoList = x.replicationInfoList
            this.replicatorName = x.replicatorName
            this.serviceExecutionRoleArn = x.serviceExecutionRoleArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.CreateReplicatorRequest = CreateReplicatorRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
