// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Returns information about a cluster operation.
 */
public class ClusterOperationV2 private constructor(builder: Builder) {
    /**
     * ARN of the cluster.
     */
    public val clusterArn: kotlin.String? = builder.clusterArn
    /**
     * Type of the backend cluster.
     */
    public val clusterType: aws.sdk.kotlin.services.kafka.model.ClusterType? = builder.clusterType
    /**
     * The time at which the operation finished.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * If cluster operation failed from an error, it describes the error.
     */
    public val errorInfo: aws.sdk.kotlin.services.kafka.model.ErrorInfo? = builder.errorInfo
    /**
     * ARN of the cluster operation.
     */
    public val operationArn: kotlin.String? = builder.operationArn
    /**
     * State of the cluster operation.
     */
    public val operationState: kotlin.String? = builder.operationState
    /**
     * Type of the cluster operation.
     */
    public val operationType: kotlin.String? = builder.operationType
    /**
     * Properties of a provisioned cluster.
     */
    public val provisioned: aws.sdk.kotlin.services.kafka.model.ClusterOperationV2Provisioned? = builder.provisioned
    /**
     * Properties of a serverless cluster.
     */
    public val serverless: aws.sdk.kotlin.services.kafka.model.ClusterOperationV2Serverless? = builder.serverless
    /**
     * The time at which operation was started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.ClusterOperationV2 = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterOperationV2(")
        append("clusterArn=$clusterArn,")
        append("clusterType=$clusterType,")
        append("endTime=$endTime,")
        append("errorInfo=$errorInfo,")
        append("operationArn=$operationArn,")
        append("operationState=$operationState,")
        append("operationType=$operationType,")
        append("provisioned=$provisioned,")
        append("serverless=$serverless,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterArn?.hashCode() ?: 0
        result = 31 * result + (clusterType?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (errorInfo?.hashCode() ?: 0)
        result = 31 * result + (operationArn?.hashCode() ?: 0)
        result = 31 * result + (operationState?.hashCode() ?: 0)
        result = 31 * result + (operationType?.hashCode() ?: 0)
        result = 31 * result + (provisioned?.hashCode() ?: 0)
        result = 31 * result + (serverless?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterOperationV2

        if (clusterArn != other.clusterArn) return false
        if (clusterType != other.clusterType) return false
        if (endTime != other.endTime) return false
        if (errorInfo != other.errorInfo) return false
        if (operationArn != other.operationArn) return false
        if (operationState != other.operationState) return false
        if (operationType != other.operationType) return false
        if (provisioned != other.provisioned) return false
        if (serverless != other.serverless) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.ClusterOperationV2 = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * ARN of the cluster.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * Type of the backend cluster.
         */
        public var clusterType: aws.sdk.kotlin.services.kafka.model.ClusterType? = null
        /**
         * The time at which the operation finished.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If cluster operation failed from an error, it describes the error.
         */
        public var errorInfo: aws.sdk.kotlin.services.kafka.model.ErrorInfo? = null
        /**
         * ARN of the cluster operation.
         */
        public var operationArn: kotlin.String? = null
        /**
         * State of the cluster operation.
         */
        public var operationState: kotlin.String? = null
        /**
         * Type of the cluster operation.
         */
        public var operationType: kotlin.String? = null
        /**
         * Properties of a provisioned cluster.
         */
        public var provisioned: aws.sdk.kotlin.services.kafka.model.ClusterOperationV2Provisioned? = null
        /**
         * Properties of a serverless cluster.
         */
        public var serverless: aws.sdk.kotlin.services.kafka.model.ClusterOperationV2Serverless? = null
        /**
         * The time at which operation was started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.ClusterOperationV2) : this() {
            this.clusterArn = x.clusterArn
            this.clusterType = x.clusterType
            this.endTime = x.endTime
            this.errorInfo = x.errorInfo
            this.operationArn = x.operationArn
            this.operationState = x.operationState
            this.operationType = x.operationType
            this.provisioned = x.provisioned
            this.serverless = x.serverless
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.ClusterOperationV2 = ClusterOperationV2(this)

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ErrorInfo] inside the given [block]
         */
        public fun errorInfo(block: aws.sdk.kotlin.services.kafka.model.ErrorInfo.Builder.() -> kotlin.Unit) {
            this.errorInfo = aws.sdk.kotlin.services.kafka.model.ErrorInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ClusterOperationV2Provisioned] inside the given [block]
         */
        public fun provisioned(block: aws.sdk.kotlin.services.kafka.model.ClusterOperationV2Provisioned.Builder.() -> kotlin.Unit) {
            this.provisioned = aws.sdk.kotlin.services.kafka.model.ClusterOperationV2Provisioned.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ClusterOperationV2Serverless] inside the given [block]
         */
        public fun serverless(block: aws.sdk.kotlin.services.kafka.model.ClusterOperationV2Serverless.Builder.() -> kotlin.Unit) {
            this.serverless = aws.sdk.kotlin.services.kafka.model.ClusterOperationV2Serverless.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
