// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the setup to be used for Apache Kafka broker nodes in the cluster.
 */
public class BrokerNodeGroupInfo private constructor(builder: Builder) {
    /**
     * The distribution of broker nodes across Availability Zones. This is an optional parameter. If you don't specify it, Amazon MSK gives it the value DEFAULT. You can also explicitly set this parameter to the value DEFAULT. No other values are currently allowed.
     *
     * Amazon MSK distributes the broker nodes evenly across the Availability Zones that correspond to the subnets you provide when you create the cluster.
     */
    public val brokerAzDistribution: aws.sdk.kotlin.services.kafka.model.BrokerAzDistribution? = builder.brokerAzDistribution
    /**
     * The list of subnets to connect to in the client virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets. Client applications use elastic network interfaces to produce and consume data. Client subnets can't occupy the Availability Zone with ID use use1-az3.
     */
    public val clientSubnets: List<String>? = builder.clientSubnets
    /**
     * Information about the broker access configuration.
     */
    public val connectivityInfo: aws.sdk.kotlin.services.kafka.model.ConnectivityInfo? = builder.connectivityInfo
    /**
     * The type of Amazon EC2 instances to use for Apache Kafka brokers. The following instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge, kafka.m5.4xlarge, kafka.m5.12xlarge, and kafka.m5.24xlarge.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The AWS security groups to associate with the elastic network interfaces in order to specify who can connect to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon MSK uses the default security group associated with the VPC.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * Contains information about storage volumes attached to MSK broker nodes.
     */
    public val storageInfo: aws.sdk.kotlin.services.kafka.model.StorageInfo? = builder.storageInfo
    /**
     * The list of zoneIds for the cluster in the virtual private cloud (VPC).
     */
    public val zoneIds: List<String>? = builder.zoneIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.BrokerNodeGroupInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BrokerNodeGroupInfo(")
        append("brokerAzDistribution=$brokerAzDistribution,")
        append("clientSubnets=$clientSubnets,")
        append("connectivityInfo=$connectivityInfo,")
        append("instanceType=$instanceType,")
        append("securityGroups=$securityGroups,")
        append("storageInfo=$storageInfo,")
        append("zoneIds=$zoneIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = brokerAzDistribution?.hashCode() ?: 0
        result = 31 * result + (clientSubnets?.hashCode() ?: 0)
        result = 31 * result + (connectivityInfo?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (storageInfo?.hashCode() ?: 0)
        result = 31 * result + (zoneIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BrokerNodeGroupInfo

        if (brokerAzDistribution != other.brokerAzDistribution) return false
        if (clientSubnets != other.clientSubnets) return false
        if (connectivityInfo != other.connectivityInfo) return false
        if (instanceType != other.instanceType) return false
        if (securityGroups != other.securityGroups) return false
        if (storageInfo != other.storageInfo) return false
        if (zoneIds != other.zoneIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.BrokerNodeGroupInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The distribution of broker nodes across Availability Zones. This is an optional parameter. If you don't specify it, Amazon MSK gives it the value DEFAULT. You can also explicitly set this parameter to the value DEFAULT. No other values are currently allowed.
         *
         * Amazon MSK distributes the broker nodes evenly across the Availability Zones that correspond to the subnets you provide when you create the cluster.
         */
        public var brokerAzDistribution: aws.sdk.kotlin.services.kafka.model.BrokerAzDistribution? = null
        /**
         * The list of subnets to connect to in the client virtual private cloud (VPC). AWS creates elastic network interfaces inside these subnets. Client applications use elastic network interfaces to produce and consume data. Client subnets can't occupy the Availability Zone with ID use use1-az3.
         */
        public var clientSubnets: List<String>? = null
        /**
         * Information about the broker access configuration.
         */
        public var connectivityInfo: aws.sdk.kotlin.services.kafka.model.ConnectivityInfo? = null
        /**
         * The type of Amazon EC2 instances to use for Apache Kafka brokers. The following instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge, kafka.m5.4xlarge, kafka.m5.12xlarge, and kafka.m5.24xlarge.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The AWS security groups to associate with the elastic network interfaces in order to specify who can connect to and communicate with the Amazon MSK cluster. If you don't specify a security group, Amazon MSK uses the default security group associated with the VPC.
         */
        public var securityGroups: List<String>? = null
        /**
         * Contains information about storage volumes attached to MSK broker nodes.
         */
        public var storageInfo: aws.sdk.kotlin.services.kafka.model.StorageInfo? = null
        /**
         * The list of zoneIds for the cluster in the virtual private cloud (VPC).
         */
        public var zoneIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.BrokerNodeGroupInfo) : this() {
            this.brokerAzDistribution = x.brokerAzDistribution
            this.clientSubnets = x.clientSubnets
            this.connectivityInfo = x.connectivityInfo
            this.instanceType = x.instanceType
            this.securityGroups = x.securityGroups
            this.storageInfo = x.storageInfo
            this.zoneIds = x.zoneIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.BrokerNodeGroupInfo = BrokerNodeGroupInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ConnectivityInfo] inside the given [block]
         */
        public fun connectivityInfo(block: aws.sdk.kotlin.services.kafka.model.ConnectivityInfo.Builder.() -> kotlin.Unit) {
            this.connectivityInfo = aws.sdk.kotlin.services.kafka.model.ConnectivityInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.StorageInfo] inside the given [block]
         */
        public fun storageInfo(block: aws.sdk.kotlin.services.kafka.model.StorageInfo.Builder.() -> kotlin.Unit) {
            this.storageInfo = aws.sdk.kotlin.services.kafka.model.StorageInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
