// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.paginators

import aws.sdk.kotlin.services.kafka.KafkaClient
import aws.sdk.kotlin.services.kafka.model.ClientVpcConnection
import aws.sdk.kotlin.services.kafka.model.Cluster
import aws.sdk.kotlin.services.kafka.model.ClusterInfo
import aws.sdk.kotlin.services.kafka.model.ClusterOperationInfo
import aws.sdk.kotlin.services.kafka.model.ClusterOperationV2Summary
import aws.sdk.kotlin.services.kafka.model.Configuration
import aws.sdk.kotlin.services.kafka.model.ConfigurationRevision
import aws.sdk.kotlin.services.kafka.model.KafkaVersion
import aws.sdk.kotlin.services.kafka.model.ListClientVpcConnectionsRequest
import aws.sdk.kotlin.services.kafka.model.ListClientVpcConnectionsResponse
import aws.sdk.kotlin.services.kafka.model.ListClusterOperationsRequest
import aws.sdk.kotlin.services.kafka.model.ListClusterOperationsResponse
import aws.sdk.kotlin.services.kafka.model.ListClusterOperationsV2Request
import aws.sdk.kotlin.services.kafka.model.ListClusterOperationsV2Response
import aws.sdk.kotlin.services.kafka.model.ListClustersRequest
import aws.sdk.kotlin.services.kafka.model.ListClustersResponse
import aws.sdk.kotlin.services.kafka.model.ListClustersV2Request
import aws.sdk.kotlin.services.kafka.model.ListClustersV2Response
import aws.sdk.kotlin.services.kafka.model.ListConfigurationRevisionsRequest
import aws.sdk.kotlin.services.kafka.model.ListConfigurationRevisionsResponse
import aws.sdk.kotlin.services.kafka.model.ListConfigurationsRequest
import aws.sdk.kotlin.services.kafka.model.ListConfigurationsResponse
import aws.sdk.kotlin.services.kafka.model.ListKafkaVersionsRequest
import aws.sdk.kotlin.services.kafka.model.ListKafkaVersionsResponse
import aws.sdk.kotlin.services.kafka.model.ListNodesRequest
import aws.sdk.kotlin.services.kafka.model.ListNodesResponse
import aws.sdk.kotlin.services.kafka.model.ListReplicatorsRequest
import aws.sdk.kotlin.services.kafka.model.ListReplicatorsResponse
import aws.sdk.kotlin.services.kafka.model.ListScramSecretsRequest
import aws.sdk.kotlin.services.kafka.model.ListScramSecretsResponse
import aws.sdk.kotlin.services.kafka.model.ListVpcConnectionsRequest
import aws.sdk.kotlin.services.kafka.model.ListVpcConnectionsResponse
import aws.sdk.kotlin.services.kafka.model.NodeInfo
import aws.sdk.kotlin.services.kafka.model.ReplicatorSummary
import aws.sdk.kotlin.services.kafka.model.VpcConnection
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListClientVpcConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClientVpcConnectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClientVpcConnectionsResponse]
 */
public fun KafkaClient.listClientVpcConnectionsPaginated(initialRequest: ListClientVpcConnectionsRequest): Flow<ListClientVpcConnectionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClientVpcConnectionsPaginated.listClientVpcConnections(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListClientVpcConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClientVpcConnectionsResponse]
 */
public fun KafkaClient.listClientVpcConnectionsPaginated(block: ListClientVpcConnectionsRequest.Builder.() -> Unit): Flow<ListClientVpcConnectionsResponse> =
    listClientVpcConnectionsPaginated(ListClientVpcConnectionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClientVpcConnectionsPaginated]
 * to access the nested member [ClientVpcConnection]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClientVpcConnection]
 */
@JvmName("listClientVpcConnectionsResponseClientVpcConnection")
public fun Flow<ListClientVpcConnectionsResponse>.clientVpcConnections(): Flow<ClientVpcConnection> =
    transform() { response ->
        response.clientVpcConnections?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListClusterOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClusterOperationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClusterOperationsResponse]
 */
public fun KafkaClient.listClusterOperationsPaginated(initialRequest: ListClusterOperationsRequest): Flow<ListClusterOperationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClusterOperationsPaginated.listClusterOperations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListClusterOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClusterOperationsResponse]
 */
public fun KafkaClient.listClusterOperationsPaginated(block: ListClusterOperationsRequest.Builder.() -> Unit): Flow<ListClusterOperationsResponse> =
    listClusterOperationsPaginated(ListClusterOperationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClusterOperationsPaginated]
 * to access the nested member [ClusterOperationInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClusterOperationInfo]
 */
@JvmName("listClusterOperationsResponseClusterOperationInfo")
public fun Flow<ListClusterOperationsResponse>.clusterOperationInfoList(): Flow<ClusterOperationInfo> =
    transform() { response ->
        response.clusterOperationInfoList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListClusterOperationsV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClusterOperationsV2Request] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClusterOperationsV2Response]
 */
public fun KafkaClient.listClusterOperationsV2Paginated(initialRequest: ListClusterOperationsV2Request): Flow<ListClusterOperationsV2Response> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClusterOperationsV2Paginated.listClusterOperationsV2(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListClusterOperationsV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClusterOperationsV2Response]
 */
public fun KafkaClient.listClusterOperationsV2Paginated(block: ListClusterOperationsV2Request.Builder.() -> Unit): Flow<ListClusterOperationsV2Response> =
    listClusterOperationsV2Paginated(ListClusterOperationsV2Request.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClusterOperationsV2Paginated]
 * to access the nested member [ClusterOperationV2Summary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClusterOperationV2Summary]
 */
@JvmName("listClusterOperationsV2ResponseClusterOperationV2Summary")
public fun Flow<ListClusterOperationsV2Response>.clusterOperationInfoList(): Flow<ClusterOperationV2Summary> =
    transform() { response ->
        response.clusterOperationInfoList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
public fun KafkaClient.listClustersPaginated(initialRequest: ListClustersRequest = ListClustersRequest { }): Flow<ListClustersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClustersPaginated.listClusters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersResponse]
 */
public fun KafkaClient.listClustersPaginated(block: ListClustersRequest.Builder.() -> Unit): Flow<ListClustersResponse> =
    listClustersPaginated(ListClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClustersPaginated]
 * to access the nested member [ClusterInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ClusterInfo]
 */
@JvmName("listClustersResponseClusterInfo")
public fun Flow<ListClustersResponse>.clusterInfoList(): Flow<ClusterInfo> =
    transform() { response ->
        response.clusterInfoList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListClustersV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListClustersV2Request] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersV2Response]
 */
public fun KafkaClient.listClustersV2Paginated(initialRequest: ListClustersV2Request = ListClustersV2Request { }): Flow<ListClustersV2Response> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listClustersV2Paginated.listClustersV2(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListClustersV2Response] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListClustersV2Response]
 */
public fun KafkaClient.listClustersV2Paginated(block: ListClustersV2Request.Builder.() -> Unit): Flow<ListClustersV2Response> =
    listClustersV2Paginated(ListClustersV2Request.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listClustersV2Paginated]
 * to access the nested member [Cluster]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Cluster]
 */
@JvmName("listClustersV2ResponseCluster")
public fun Flow<ListClustersV2Response>.clusterInfoList(): Flow<Cluster> =
    transform() { response ->
        response.clusterInfoList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListConfigurationRevisionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConfigurationRevisionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationRevisionsResponse]
 */
public fun KafkaClient.listConfigurationRevisionsPaginated(initialRequest: ListConfigurationRevisionsRequest): Flow<ListConfigurationRevisionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConfigurationRevisionsPaginated.listConfigurationRevisions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListConfigurationRevisionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationRevisionsResponse]
 */
public fun KafkaClient.listConfigurationRevisionsPaginated(block: ListConfigurationRevisionsRequest.Builder.() -> Unit): Flow<ListConfigurationRevisionsResponse> =
    listConfigurationRevisionsPaginated(ListConfigurationRevisionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listConfigurationRevisionsPaginated]
 * to access the nested member [ConfigurationRevision]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ConfigurationRevision]
 */
@JvmName("listConfigurationRevisionsResponseConfigurationRevision")
public fun Flow<ListConfigurationRevisionsResponse>.revisions(): Flow<ConfigurationRevision> =
    transform() { response ->
        response.revisions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationsResponse]
 */
public fun KafkaClient.listConfigurationsPaginated(initialRequest: ListConfigurationsRequest = ListConfigurationsRequest { }): Flow<ListConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConfigurationsPaginated.listConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConfigurationsResponse]
 */
public fun KafkaClient.listConfigurationsPaginated(block: ListConfigurationsRequest.Builder.() -> Unit): Flow<ListConfigurationsResponse> =
    listConfigurationsPaginated(ListConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listConfigurationsPaginated]
 * to access the nested member [Configuration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Configuration]
 */
@JvmName("listConfigurationsResponseConfiguration")
public fun Flow<ListConfigurationsResponse>.configurations(): Flow<Configuration> =
    transform() { response ->
        response.configurations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListKafkaVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListKafkaVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKafkaVersionsResponse]
 */
public fun KafkaClient.listKafkaVersionsPaginated(initialRequest: ListKafkaVersionsRequest = ListKafkaVersionsRequest { }): Flow<ListKafkaVersionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listKafkaVersionsPaginated.listKafkaVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListKafkaVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListKafkaVersionsResponse]
 */
public fun KafkaClient.listKafkaVersionsPaginated(block: ListKafkaVersionsRequest.Builder.() -> Unit): Flow<ListKafkaVersionsResponse> =
    listKafkaVersionsPaginated(ListKafkaVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listKafkaVersionsPaginated]
 * to access the nested member [KafkaVersion]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [KafkaVersion]
 */
@JvmName("listKafkaVersionsResponseKafkaVersion")
public fun Flow<ListKafkaVersionsResponse>.kafkaVersions(): Flow<KafkaVersion> =
    transform() { response ->
        response.kafkaVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListNodesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNodesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNodesResponse]
 */
public fun KafkaClient.listNodesPaginated(initialRequest: ListNodesRequest): Flow<ListNodesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNodesPaginated.listNodes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListNodesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNodesResponse]
 */
public fun KafkaClient.listNodesPaginated(block: ListNodesRequest.Builder.() -> Unit): Flow<ListNodesResponse> =
    listNodesPaginated(ListNodesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listNodesPaginated]
 * to access the nested member [NodeInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NodeInfo]
 */
@JvmName("listNodesResponseNodeInfo")
public fun Flow<ListNodesResponse>.nodeInfoList(): Flow<NodeInfo> =
    transform() { response ->
        response.nodeInfoList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListReplicatorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListReplicatorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReplicatorsResponse]
 */
public fun KafkaClient.listReplicatorsPaginated(initialRequest: ListReplicatorsRequest = ListReplicatorsRequest { }): Flow<ListReplicatorsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listReplicatorsPaginated.listReplicators(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListReplicatorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReplicatorsResponse]
 */
public fun KafkaClient.listReplicatorsPaginated(block: ListReplicatorsRequest.Builder.() -> Unit): Flow<ListReplicatorsResponse> =
    listReplicatorsPaginated(ListReplicatorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listReplicatorsPaginated]
 * to access the nested member [ReplicatorSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReplicatorSummary]
 */
@JvmName("listReplicatorsResponseReplicatorSummary")
public fun Flow<ListReplicatorsResponse>.replicators(): Flow<ReplicatorSummary> =
    transform() { response ->
        response.replicators?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListScramSecretsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListScramSecretsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScramSecretsResponse]
 */
public fun KafkaClient.listScramSecretsPaginated(initialRequest: ListScramSecretsRequest): Flow<ListScramSecretsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listScramSecretsPaginated.listScramSecrets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListScramSecretsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListScramSecretsResponse]
 */
public fun KafkaClient.listScramSecretsPaginated(block: ListScramSecretsRequest.Builder.() -> Unit): Flow<ListScramSecretsResponse> =
    listScramSecretsPaginated(ListScramSecretsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listScramSecretsPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listScramSecretsResponseString")
public fun Flow<ListScramSecretsResponse>.secretArnList(): Flow<String> =
    transform() { response ->
        response.secretArnList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListVpcConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVpcConnectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVpcConnectionsResponse]
 */
public fun KafkaClient.listVpcConnectionsPaginated(initialRequest: ListVpcConnectionsRequest = ListVpcConnectionsRequest { }): Flow<ListVpcConnectionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVpcConnectionsPaginated.listVpcConnections(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListVpcConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVpcConnectionsResponse]
 */
public fun KafkaClient.listVpcConnectionsPaginated(block: ListVpcConnectionsRequest.Builder.() -> Unit): Flow<ListVpcConnectionsResponse> =
    listVpcConnectionsPaginated(ListVpcConnectionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listVpcConnectionsPaginated]
 * to access the nested member [VpcConnection]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [VpcConnection]
 */
@JvmName("listVpcConnectionsResponseVpcConnection")
public fun Flow<ListVpcConnectionsResponse>.vpcConnections(): Flow<VpcConnection> =
    transform() { response ->
        response.vpcConnections?.forEach {
            emit(it)
        }
    }
