// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.serde

import aws.sdk.kotlin.services.kafka.model.KafkaException
import aws.sdk.kotlin.services.kafka.model.PutClusterPolicyResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutClusterPolicyOperationDeserializer: HttpDeserializer.NonStreaming<PutClusterPolicyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutClusterPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutClusterPolicyError(context, call, payload)
        }
        val builder = PutClusterPolicyResponse.Builder()

        if (payload != null) {
            deserializePutClusterPolicyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutClusterPolicyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KafkaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KafkaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutClusterPolicyOperationBody(builder: PutClusterPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CURRENTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("currentVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CURRENTVERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CURRENTVERSION_DESCRIPTOR.index -> builder.currentVersion = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
