// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.serde

import aws.sdk.kotlin.services.kafka.model.ClusterState
import aws.sdk.kotlin.services.kafka.model.DeleteClusterResponse
import aws.sdk.kotlin.services.kafka.model.KafkaException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteClusterOperationDeserializer: HttpDeserialize<DeleteClusterResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteClusterError(context, call)
        }
        val builder = DeleteClusterResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteClusterError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KafkaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KafkaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteClusterOperationBody(builder: DeleteClusterResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLUSTERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clusterArn"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("state"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLUSTERARN_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTERARN_DESCRIPTOR.index -> builder.clusterArn = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { ClusterState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
