// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model



public class UpdateConfigurationRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the configuration.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The description of the configuration revision.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Contents of the <filename>server.properties file. When using the API, you must ensure that the contents of the file are base64 encoded. When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties can be in plaintext.
     */
    public val serverProperties: kotlin.ByteArray? = builder.serverProperties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.UpdateConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateConfigurationRequest(")
        append("arn=$arn,")
        append("description=$description,")
        append("serverProperties=$serverProperties")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (serverProperties?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateConfigurationRequest

        if (arn != other.arn) return false
        if (description != other.description) return false
        if (serverProperties != null) {
            if (other.serverProperties == null) return false
            if (!serverProperties.contentEquals(other.serverProperties)) return false
        } else if (other.serverProperties != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.UpdateConfigurationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the configuration.
         */
        public var arn: kotlin.String? = null
        /**
         * The description of the configuration revision.
         */
        public var description: kotlin.String? = null
        /**
         * Contents of the <filename>server.properties file. When using the API, you must ensure that the contents of the file are base64 encoded. When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties can be in plaintext.
         */
        public var serverProperties: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.UpdateConfigurationRequest) : this() {
            this.arn = x.arn
            this.description = x.description
            this.serverProperties = x.serverProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.UpdateConfigurationRequest = UpdateConfigurationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
