// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.serde

import aws.sdk.kotlin.services.kafka.model.DescribeReplicatorResponse
import aws.sdk.kotlin.services.kafka.model.KafkaClusterDescription
import aws.sdk.kotlin.services.kafka.model.KafkaException
import aws.sdk.kotlin.services.kafka.model.ReplicationInfoDescription
import aws.sdk.kotlin.services.kafka.model.ReplicationStateInfo
import aws.sdk.kotlin.services.kafka.model.ReplicatorState
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeReplicatorOperationDeserializer: HttpDeserialize<DescribeReplicatorResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeReplicatorResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeReplicatorError(context, call)
        }
        val builder = DescribeReplicatorResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeReplicatorOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeReplicatorError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KafkaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KafkaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeReplicatorOperationBody(builder: DescribeReplicatorResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val CURRENTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("currentVersion"))
    val ISREPLICATORREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isReplicatorReference"))
    val KAFKACLUSTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("kafkaClusters"))
    val REPLICATIONINFOLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("replicationInfoList"))
    val REPLICATORARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("replicatorArn"))
    val REPLICATORDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("replicatorDescription"))
    val REPLICATORNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("replicatorName"))
    val REPLICATORRESOURCEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("replicatorResourceArn"))
    val REPLICATORSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("replicatorState"))
    val SERVICEEXECUTIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceExecutionRoleArn"))
    val STATEINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("stateInfo"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(CURRENTVERSION_DESCRIPTOR)
        field(ISREPLICATORREFERENCE_DESCRIPTOR)
        field(KAFKACLUSTERS_DESCRIPTOR)
        field(REPLICATIONINFOLIST_DESCRIPTOR)
        field(REPLICATORARN_DESCRIPTOR)
        field(REPLICATORDESCRIPTION_DESCRIPTOR)
        field(REPLICATORNAME_DESCRIPTOR)
        field(REPLICATORRESOURCEARN_DESCRIPTOR)
        field(REPLICATORSTATE_DESCRIPTOR)
        field(SERVICEEXECUTIONROLEARN_DESCRIPTOR)
        field(STATEINFO_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromIso8601(it) }
                CURRENTVERSION_DESCRIPTOR.index -> builder.currentVersion = deserializeString()
                ISREPLICATORREFERENCE_DESCRIPTOR.index -> builder.isReplicatorReference = deserializeBoolean()
                KAFKACLUSTERS_DESCRIPTOR.index -> builder.kafkaClusters =
                    deserializer.deserializeList(KAFKACLUSTERS_DESCRIPTOR) {
                        val col0 = mutableListOf<KafkaClusterDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeKafkaClusterDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REPLICATIONINFOLIST_DESCRIPTOR.index -> builder.replicationInfoList =
                    deserializer.deserializeList(REPLICATIONINFOLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<ReplicationInfoDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeReplicationInfoDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REPLICATORARN_DESCRIPTOR.index -> builder.replicatorArn = deserializeString()
                REPLICATORDESCRIPTION_DESCRIPTOR.index -> builder.replicatorDescription = deserializeString()
                REPLICATORNAME_DESCRIPTOR.index -> builder.replicatorName = deserializeString()
                REPLICATORRESOURCEARN_DESCRIPTOR.index -> builder.replicatorResourceArn = deserializeString()
                REPLICATORSTATE_DESCRIPTOR.index -> builder.replicatorState = deserializeString().let { ReplicatorState.fromValue(it) }
                SERVICEEXECUTIONROLEARN_DESCRIPTOR.index -> builder.serviceExecutionRoleArn = deserializeString()
                STATEINFO_DESCRIPTOR.index -> builder.stateInfo = deserializeReplicationStateInfoDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
