// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents an MSK Configuration.
 */
public class Configuration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the configuration.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time when the configuration was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The description of the configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * An array of the versions of Apache Kafka with which you can use this MSK configuration. You can use this configuration for an MSK cluster only if the Apache Kafka version specified for the cluster appears in this array.
     */
    public val kafkaVersions: List<String>? = builder.kafkaVersions
    /**
     * Latest revision of the configuration.
     */
    public val latestRevision: aws.sdk.kotlin.services.kafka.model.ConfigurationRevision? = builder.latestRevision
    /**
     * The name of the configuration.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
     */
    public val state: aws.sdk.kotlin.services.kafka.model.ConfigurationState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.Configuration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Configuration(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("kafkaVersions=$kafkaVersions,")
        append("latestRevision=$latestRevision,")
        append("name=$name,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kafkaVersions?.hashCode() ?: 0)
        result = 31 * result + (latestRevision?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Configuration

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (kafkaVersions != other.kafkaVersions) return false
        if (latestRevision != other.latestRevision) return false
        if (name != other.name) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.Configuration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the configuration.
         */
        public var arn: kotlin.String? = null
        /**
         * The time when the configuration was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the configuration.
         */
        public var description: kotlin.String? = null
        /**
         * An array of the versions of Apache Kafka with which you can use this MSK configuration. You can use this configuration for an MSK cluster only if the Apache Kafka version specified for the cluster appears in this array.
         */
        public var kafkaVersions: List<String>? = null
        /**
         * Latest revision of the configuration.
         */
        public var latestRevision: aws.sdk.kotlin.services.kafka.model.ConfigurationRevision? = null
        /**
         * The name of the configuration.
         */
        public var name: kotlin.String? = null
        /**
         * The state of the configuration. The possible states are ACTIVE, DELETING, and DELETE_FAILED.
         */
        public var state: aws.sdk.kotlin.services.kafka.model.ConfigurationState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.Configuration) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.description = x.description
            this.kafkaVersions = x.kafkaVersions
            this.latestRevision = x.latestRevision
            this.name = x.name
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.Configuration = Configuration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.ConfigurationRevision] inside the given [block]
         */
        public fun latestRevision(block: aws.sdk.kotlin.services.kafka.model.ConfigurationRevision.Builder.() -> kotlin.Unit) {
            this.latestRevision = aws.sdk.kotlin.services.kafka.model.ConfigurationRevision.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
