// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.kafka.auth.DefaultKafkaAuthSchemeProvider
import aws.sdk.kotlin.services.kafka.auth.KafkaAuthSchemeProvider
import aws.sdk.kotlin.services.kafka.endpoints.DefaultKafkaEndpointProvider
import aws.sdk.kotlin.services.kafka.endpoints.KafkaEndpointParameters
import aws.sdk.kotlin.services.kafka.endpoints.KafkaEndpointProvider
import aws.sdk.kotlin.services.kafka.model.BatchAssociateScramSecretRequest
import aws.sdk.kotlin.services.kafka.model.BatchAssociateScramSecretResponse
import aws.sdk.kotlin.services.kafka.model.BatchDisassociateScramSecretRequest
import aws.sdk.kotlin.services.kafka.model.BatchDisassociateScramSecretResponse
import aws.sdk.kotlin.services.kafka.model.CreateClusterRequest
import aws.sdk.kotlin.services.kafka.model.CreateClusterResponse
import aws.sdk.kotlin.services.kafka.model.CreateClusterV2Request
import aws.sdk.kotlin.services.kafka.model.CreateClusterV2Response
import aws.sdk.kotlin.services.kafka.model.CreateConfigurationRequest
import aws.sdk.kotlin.services.kafka.model.CreateConfigurationResponse
import aws.sdk.kotlin.services.kafka.model.CreateReplicatorRequest
import aws.sdk.kotlin.services.kafka.model.CreateReplicatorResponse
import aws.sdk.kotlin.services.kafka.model.CreateVpcConnectionRequest
import aws.sdk.kotlin.services.kafka.model.CreateVpcConnectionResponse
import aws.sdk.kotlin.services.kafka.model.DeleteClusterPolicyRequest
import aws.sdk.kotlin.services.kafka.model.DeleteClusterPolicyResponse
import aws.sdk.kotlin.services.kafka.model.DeleteClusterRequest
import aws.sdk.kotlin.services.kafka.model.DeleteClusterResponse
import aws.sdk.kotlin.services.kafka.model.DeleteConfigurationRequest
import aws.sdk.kotlin.services.kafka.model.DeleteConfigurationResponse
import aws.sdk.kotlin.services.kafka.model.DeleteReplicatorRequest
import aws.sdk.kotlin.services.kafka.model.DeleteReplicatorResponse
import aws.sdk.kotlin.services.kafka.model.DeleteVpcConnectionRequest
import aws.sdk.kotlin.services.kafka.model.DeleteVpcConnectionResponse
import aws.sdk.kotlin.services.kafka.model.DescribeClusterOperationRequest
import aws.sdk.kotlin.services.kafka.model.DescribeClusterOperationResponse
import aws.sdk.kotlin.services.kafka.model.DescribeClusterOperationV2Request
import aws.sdk.kotlin.services.kafka.model.DescribeClusterOperationV2Response
import aws.sdk.kotlin.services.kafka.model.DescribeClusterRequest
import aws.sdk.kotlin.services.kafka.model.DescribeClusterResponse
import aws.sdk.kotlin.services.kafka.model.DescribeClusterV2Request
import aws.sdk.kotlin.services.kafka.model.DescribeClusterV2Response
import aws.sdk.kotlin.services.kafka.model.DescribeConfigurationRequest
import aws.sdk.kotlin.services.kafka.model.DescribeConfigurationResponse
import aws.sdk.kotlin.services.kafka.model.DescribeConfigurationRevisionRequest
import aws.sdk.kotlin.services.kafka.model.DescribeConfigurationRevisionResponse
import aws.sdk.kotlin.services.kafka.model.DescribeReplicatorRequest
import aws.sdk.kotlin.services.kafka.model.DescribeReplicatorResponse
import aws.sdk.kotlin.services.kafka.model.DescribeVpcConnectionRequest
import aws.sdk.kotlin.services.kafka.model.DescribeVpcConnectionResponse
import aws.sdk.kotlin.services.kafka.model.GetBootstrapBrokersRequest
import aws.sdk.kotlin.services.kafka.model.GetBootstrapBrokersResponse
import aws.sdk.kotlin.services.kafka.model.GetClusterPolicyRequest
import aws.sdk.kotlin.services.kafka.model.GetClusterPolicyResponse
import aws.sdk.kotlin.services.kafka.model.GetCompatibleKafkaVersionsRequest
import aws.sdk.kotlin.services.kafka.model.GetCompatibleKafkaVersionsResponse
import aws.sdk.kotlin.services.kafka.model.ListClientVpcConnectionsRequest
import aws.sdk.kotlin.services.kafka.model.ListClientVpcConnectionsResponse
import aws.sdk.kotlin.services.kafka.model.ListClusterOperationsRequest
import aws.sdk.kotlin.services.kafka.model.ListClusterOperationsResponse
import aws.sdk.kotlin.services.kafka.model.ListClusterOperationsV2Request
import aws.sdk.kotlin.services.kafka.model.ListClusterOperationsV2Response
import aws.sdk.kotlin.services.kafka.model.ListClustersRequest
import aws.sdk.kotlin.services.kafka.model.ListClustersResponse
import aws.sdk.kotlin.services.kafka.model.ListClustersV2Request
import aws.sdk.kotlin.services.kafka.model.ListClustersV2Response
import aws.sdk.kotlin.services.kafka.model.ListConfigurationRevisionsRequest
import aws.sdk.kotlin.services.kafka.model.ListConfigurationRevisionsResponse
import aws.sdk.kotlin.services.kafka.model.ListConfigurationsRequest
import aws.sdk.kotlin.services.kafka.model.ListConfigurationsResponse
import aws.sdk.kotlin.services.kafka.model.ListKafkaVersionsRequest
import aws.sdk.kotlin.services.kafka.model.ListKafkaVersionsResponse
import aws.sdk.kotlin.services.kafka.model.ListNodesRequest
import aws.sdk.kotlin.services.kafka.model.ListNodesResponse
import aws.sdk.kotlin.services.kafka.model.ListReplicatorsRequest
import aws.sdk.kotlin.services.kafka.model.ListReplicatorsResponse
import aws.sdk.kotlin.services.kafka.model.ListScramSecretsRequest
import aws.sdk.kotlin.services.kafka.model.ListScramSecretsResponse
import aws.sdk.kotlin.services.kafka.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.kafka.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.kafka.model.ListVpcConnectionsRequest
import aws.sdk.kotlin.services.kafka.model.ListVpcConnectionsResponse
import aws.sdk.kotlin.services.kafka.model.PutClusterPolicyRequest
import aws.sdk.kotlin.services.kafka.model.PutClusterPolicyResponse
import aws.sdk.kotlin.services.kafka.model.RebootBrokerRequest
import aws.sdk.kotlin.services.kafka.model.RebootBrokerResponse
import aws.sdk.kotlin.services.kafka.model.RejectClientVpcConnectionRequest
import aws.sdk.kotlin.services.kafka.model.RejectClientVpcConnectionResponse
import aws.sdk.kotlin.services.kafka.model.TagResourceRequest
import aws.sdk.kotlin.services.kafka.model.TagResourceResponse
import aws.sdk.kotlin.services.kafka.model.UntagResourceRequest
import aws.sdk.kotlin.services.kafka.model.UntagResourceResponse
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerCountRequest
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerCountResponse
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerStorageRequest
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerStorageResponse
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerTypeRequest
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerTypeResponse
import aws.sdk.kotlin.services.kafka.model.UpdateClusterConfigurationRequest
import aws.sdk.kotlin.services.kafka.model.UpdateClusterConfigurationResponse
import aws.sdk.kotlin.services.kafka.model.UpdateClusterKafkaVersionRequest
import aws.sdk.kotlin.services.kafka.model.UpdateClusterKafkaVersionResponse
import aws.sdk.kotlin.services.kafka.model.UpdateConfigurationRequest
import aws.sdk.kotlin.services.kafka.model.UpdateConfigurationResponse
import aws.sdk.kotlin.services.kafka.model.UpdateConnectivityRequest
import aws.sdk.kotlin.services.kafka.model.UpdateConnectivityResponse
import aws.sdk.kotlin.services.kafka.model.UpdateMonitoringRequest
import aws.sdk.kotlin.services.kafka.model.UpdateMonitoringResponse
import aws.sdk.kotlin.services.kafka.model.UpdateReplicationInfoRequest
import aws.sdk.kotlin.services.kafka.model.UpdateReplicationInfoResponse
import aws.sdk.kotlin.services.kafka.model.UpdateSecurityRequest
import aws.sdk.kotlin.services.kafka.model.UpdateSecurityResponse
import aws.sdk.kotlin.services.kafka.model.UpdateStorageRequest
import aws.sdk.kotlin.services.kafka.model.UpdateStorageResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Kafka"
public const val SdkVersion: String = "1.0.39"
public const val ServiceApiVersion: String = "2018-11-14"

/**
 * The operations for managing an Amazon MSK cluster.
 */
public interface KafkaClient : SdkClient {
    /**
     * KafkaClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, KafkaClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Kafka",
                "KAFKA",
                "kafka",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, KafkaClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): KafkaClient = DefaultKafkaClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: KafkaEndpointProvider = builder.endpointProvider ?: DefaultKafkaEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: KafkaAuthSchemeProvider = builder.authSchemeProvider ?: DefaultKafkaAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Kafka"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: KafkaEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: KafkaAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates one or more Scram Secrets with an Amazon MSK cluster.
     */
    public suspend fun batchAssociateScramSecret(input: BatchAssociateScramSecretRequest): BatchAssociateScramSecretResponse

    /**
     * Disassociates one or more Scram Secrets from an Amazon MSK cluster.
     */
    public suspend fun batchDisassociateScramSecret(input: BatchDisassociateScramSecretRequest): BatchDisassociateScramSecretResponse

    /**
     * Creates a new MSK cluster.
     */
    public suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates a new MSK cluster.
     */
    public suspend fun createClusterV2(input: CreateClusterV2Request): CreateClusterV2Response

    /**
     * Creates a new MSK configuration.
     */
    public suspend fun createConfiguration(input: CreateConfigurationRequest): CreateConfigurationResponse

    /**
     * Creates the replicator.
     */
    public suspend fun createReplicator(input: CreateReplicatorRequest): CreateReplicatorResponse

    /**
     * Creates a new MSK VPC connection.
     */
    public suspend fun createVpcConnection(input: CreateVpcConnectionRequest): CreateVpcConnectionResponse

    /**
     * Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.
     */
    public suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Deletes the MSK cluster policy specified by the Amazon Resource Name (ARN) in the request.
     */
    public suspend fun deleteClusterPolicy(input: DeleteClusterPolicyRequest): DeleteClusterPolicyResponse

    /**
     * Deletes an MSK Configuration.
     */
    public suspend fun deleteConfiguration(input: DeleteConfigurationRequest): DeleteConfigurationResponse

    /**
     * Deletes a replicator.
     */
    public suspend fun deleteReplicator(input: DeleteReplicatorRequest): DeleteReplicatorResponse

    /**
     * Deletes a MSK VPC connection.
     */
    public suspend fun deleteVpcConnection(input: DeleteVpcConnectionRequest): DeleteVpcConnectionResponse

    /**
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     */
    public suspend fun describeCluster(input: DescribeClusterRequest): DescribeClusterResponse

    /**
     * Returns a description of the cluster operation specified by the ARN.
     */
    public suspend fun describeClusterOperation(input: DescribeClusterOperationRequest): DescribeClusterOperationResponse

    /**
     * Returns a description of the cluster operation specified by the ARN.
     */
    public suspend fun describeClusterOperationV2(input: DescribeClusterOperationV2Request): DescribeClusterOperationV2Response

    /**
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     */
    public suspend fun describeClusterV2(input: DescribeClusterV2Request): DescribeClusterV2Response

    /**
     * Returns a description of this MSK configuration.
     */
    public suspend fun describeConfiguration(input: DescribeConfigurationRequest): DescribeConfigurationResponse

    /**
     * Returns a description of this revision of the configuration.
     */
    public suspend fun describeConfigurationRevision(input: DescribeConfigurationRevisionRequest): DescribeConfigurationRevisionResponse

    /**
     * Describes a replicator.
     */
    public suspend fun describeReplicator(input: DescribeReplicatorRequest): DescribeReplicatorResponse

    /**
     * Returns a description of this MSK VPC connection.
     */
    public suspend fun describeVpcConnection(input: DescribeVpcConnectionRequest): DescribeVpcConnectionResponse

    /**
     * A list of brokers that a client application can use to bootstrap.
     */
    public suspend fun getBootstrapBrokers(input: GetBootstrapBrokersRequest): GetBootstrapBrokersResponse

    /**
     * Get the MSK cluster policy specified by the Amazon Resource Name (ARN) in the request.
     */
    public suspend fun getClusterPolicy(input: GetClusterPolicyRequest): GetClusterPolicyResponse

    /**
     * Gets the Apache Kafka versions to which you can update the MSK cluster.
     */
    public suspend fun getCompatibleKafkaVersions(input: GetCompatibleKafkaVersionsRequest = GetCompatibleKafkaVersionsRequest { }): GetCompatibleKafkaVersionsResponse

    /**
     * Returns a list of all the VPC connections in this Region.
     */
    public suspend fun listClientVpcConnections(input: ListClientVpcConnectionsRequest): ListClientVpcConnectionsResponse

    /**
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     */
    public suspend fun listClusterOperations(input: ListClusterOperationsRequest): ListClusterOperationsResponse

    /**
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     */
    public suspend fun listClusterOperationsV2(input: ListClusterOperationsV2Request): ListClusterOperationsV2Response

    /**
     * Returns a list of all the MSK clusters in the current Region.
     */
    public suspend fun listClusters(input: ListClustersRequest = ListClustersRequest { }): ListClustersResponse

    /**
     * Returns a list of all the MSK clusters in the current Region.
     */
    public suspend fun listClustersV2(input: ListClustersV2Request = ListClustersV2Request { }): ListClustersV2Response

    /**
     * Returns a list of all the MSK configurations in this Region.
     */
    public suspend fun listConfigurationRevisions(input: ListConfigurationRevisionsRequest): ListConfigurationRevisionsResponse

    /**
     * Returns a list of all the MSK configurations in this Region.
     */
    public suspend fun listConfigurations(input: ListConfigurationsRequest = ListConfigurationsRequest { }): ListConfigurationsResponse

    /**
     * Returns a list of Apache Kafka versions.
     */
    public suspend fun listKafkaVersions(input: ListKafkaVersionsRequest = ListKafkaVersionsRequest { }): ListKafkaVersionsResponse

    /**
     * Returns a list of the broker nodes in the cluster.
     */
    public suspend fun listNodes(input: ListNodesRequest): ListNodesResponse

    /**
     * Lists the replicators.
     */
    public suspend fun listReplicators(input: ListReplicatorsRequest = ListReplicatorsRequest { }): ListReplicatorsResponse

    /**
     * Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
     */
    public suspend fun listScramSecrets(input: ListScramSecretsRequest): ListScramSecretsResponse

    /**
     * Returns a list of the tags associated with the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of all the VPC connections in this Region.
     */
    public suspend fun listVpcConnections(input: ListVpcConnectionsRequest = ListVpcConnectionsRequest { }): ListVpcConnectionsResponse

    /**
     * Creates or updates the MSK cluster policy specified by the cluster Amazon Resource Name (ARN) in the request.
     */
    public suspend fun putClusterPolicy(input: PutClusterPolicyRequest): PutClusterPolicyResponse

    /**
     * Reboots brokers.
     */
    public suspend fun rebootBroker(input: RebootBrokerRequest): RebootBrokerResponse

    /**
     * Returns empty response.
     */
    public suspend fun rejectClientVpcConnection(input: RejectClientVpcConnectionRequest): RejectClientVpcConnectionResponse

    /**
     * Adds tags to the specified MSK resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the tags associated with the keys that are provided in the query.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the number of broker nodes in the cluster.
     */
    public suspend fun updateBrokerCount(input: UpdateBrokerCountRequest): UpdateBrokerCountResponse

    /**
     * Updates the EBS storage associated with MSK brokers.
     */
    public suspend fun updateBrokerStorage(input: UpdateBrokerStorageRequest): UpdateBrokerStorageResponse

    /**
     * Updates EC2 instance type.
     */
    public suspend fun updateBrokerType(input: UpdateBrokerTypeRequest): UpdateBrokerTypeResponse

    /**
     * Updates the cluster with the configuration that is specified in the request body.
     */
    public suspend fun updateClusterConfiguration(input: UpdateClusterConfigurationRequest): UpdateClusterConfigurationResponse

    /**
     * Updates the Apache Kafka version for the cluster.
     */
    public suspend fun updateClusterKafkaVersion(input: UpdateClusterKafkaVersionRequest): UpdateClusterKafkaVersionResponse

    /**
     * Updates an MSK configuration.
     */
    public suspend fun updateConfiguration(input: UpdateConfigurationRequest): UpdateConfigurationResponse

    /**
     * Updates the cluster's connectivity configuration.
     */
    public suspend fun updateConnectivity(input: UpdateConnectivityRequest): UpdateConnectivityResponse

    /**
     * Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.
     */
    public suspend fun updateMonitoring(input: UpdateMonitoringRequest): UpdateMonitoringResponse

    /**
     * Updates replication info of a replicator.
     */
    public suspend fun updateReplicationInfo(input: UpdateReplicationInfoRequest): UpdateReplicationInfoResponse

    /**
     * Updates the security settings for the cluster. You can use this operation to specify encryption and authentication on existing clusters.
     */
    public suspend fun updateSecurity(input: UpdateSecurityRequest): UpdateSecurityResponse

    /**
     * Updates cluster broker volume size (or) sets cluster storage mode to TIERED.
     */
    public suspend fun updateStorage(input: UpdateStorageRequest): UpdateStorageResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun KafkaClient.withConfig(block: KafkaClient.Config.Builder.() -> Unit): KafkaClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultKafkaClient(newConfig)
}

/**
 * Associates one or more Scram Secrets with an Amazon MSK cluster.
 */
public suspend inline fun KafkaClient.batchAssociateScramSecret(crossinline block: BatchAssociateScramSecretRequest.Builder.() -> Unit): BatchAssociateScramSecretResponse = batchAssociateScramSecret(BatchAssociateScramSecretRequest.Builder().apply(block).build())

/**
 * Disassociates one or more Scram Secrets from an Amazon MSK cluster.
 */
public suspend inline fun KafkaClient.batchDisassociateScramSecret(crossinline block: BatchDisassociateScramSecretRequest.Builder.() -> Unit): BatchDisassociateScramSecretResponse = batchDisassociateScramSecret(BatchDisassociateScramSecretRequest.Builder().apply(block).build())

/**
 * Creates a new MSK cluster.
 */
public suspend inline fun KafkaClient.createCluster(crossinline block: CreateClusterRequest.Builder.() -> Unit): CreateClusterResponse = createCluster(CreateClusterRequest.Builder().apply(block).build())

/**
 * Creates a new MSK cluster.
 */
public suspend inline fun KafkaClient.createClusterV2(crossinline block: CreateClusterV2Request.Builder.() -> Unit): CreateClusterV2Response = createClusterV2(CreateClusterV2Request.Builder().apply(block).build())

/**
 * Creates a new MSK configuration.
 */
public suspend inline fun KafkaClient.createConfiguration(crossinline block: CreateConfigurationRequest.Builder.() -> Unit): CreateConfigurationResponse = createConfiguration(CreateConfigurationRequest.Builder().apply(block).build())

/**
 * Creates the replicator.
 */
public suspend inline fun KafkaClient.createReplicator(crossinline block: CreateReplicatorRequest.Builder.() -> Unit): CreateReplicatorResponse = createReplicator(CreateReplicatorRequest.Builder().apply(block).build())

/**
 * Creates a new MSK VPC connection.
 */
public suspend inline fun KafkaClient.createVpcConnection(crossinline block: CreateVpcConnectionRequest.Builder.() -> Unit): CreateVpcConnectionResponse = createVpcConnection(CreateVpcConnectionRequest.Builder().apply(block).build())

/**
 * Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.
 */
public suspend inline fun KafkaClient.deleteCluster(crossinline block: DeleteClusterRequest.Builder.() -> Unit): DeleteClusterResponse = deleteCluster(DeleteClusterRequest.Builder().apply(block).build())

/**
 * Deletes the MSK cluster policy specified by the Amazon Resource Name (ARN) in the request.
 */
public suspend inline fun KafkaClient.deleteClusterPolicy(crossinline block: DeleteClusterPolicyRequest.Builder.() -> Unit): DeleteClusterPolicyResponse = deleteClusterPolicy(DeleteClusterPolicyRequest.Builder().apply(block).build())

/**
 * Deletes an MSK Configuration.
 */
public suspend inline fun KafkaClient.deleteConfiguration(crossinline block: DeleteConfigurationRequest.Builder.() -> Unit): DeleteConfigurationResponse = deleteConfiguration(DeleteConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a replicator.
 */
public suspend inline fun KafkaClient.deleteReplicator(crossinline block: DeleteReplicatorRequest.Builder.() -> Unit): DeleteReplicatorResponse = deleteReplicator(DeleteReplicatorRequest.Builder().apply(block).build())

/**
 * Deletes a MSK VPC connection.
 */
public suspend inline fun KafkaClient.deleteVpcConnection(crossinline block: DeleteVpcConnectionRequest.Builder.() -> Unit): DeleteVpcConnectionResponse = deleteVpcConnection(DeleteVpcConnectionRequest.Builder().apply(block).build())

/**
 * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
 */
public suspend inline fun KafkaClient.describeCluster(crossinline block: DescribeClusterRequest.Builder.() -> Unit): DescribeClusterResponse = describeCluster(DescribeClusterRequest.Builder().apply(block).build())

/**
 * Returns a description of the cluster operation specified by the ARN.
 */
public suspend inline fun KafkaClient.describeClusterOperation(crossinline block: DescribeClusterOperationRequest.Builder.() -> Unit): DescribeClusterOperationResponse = describeClusterOperation(DescribeClusterOperationRequest.Builder().apply(block).build())

/**
 * Returns a description of the cluster operation specified by the ARN.
 */
public suspend inline fun KafkaClient.describeClusterOperationV2(crossinline block: DescribeClusterOperationV2Request.Builder.() -> Unit): DescribeClusterOperationV2Response = describeClusterOperationV2(DescribeClusterOperationV2Request.Builder().apply(block).build())

/**
 * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
 */
public suspend inline fun KafkaClient.describeClusterV2(crossinline block: DescribeClusterV2Request.Builder.() -> Unit): DescribeClusterV2Response = describeClusterV2(DescribeClusterV2Request.Builder().apply(block).build())

/**
 * Returns a description of this MSK configuration.
 */
public suspend inline fun KafkaClient.describeConfiguration(crossinline block: DescribeConfigurationRequest.Builder.() -> Unit): DescribeConfigurationResponse = describeConfiguration(DescribeConfigurationRequest.Builder().apply(block).build())

/**
 * Returns a description of this revision of the configuration.
 */
public suspend inline fun KafkaClient.describeConfigurationRevision(crossinline block: DescribeConfigurationRevisionRequest.Builder.() -> Unit): DescribeConfigurationRevisionResponse = describeConfigurationRevision(DescribeConfigurationRevisionRequest.Builder().apply(block).build())

/**
 * Describes a replicator.
 */
public suspend inline fun KafkaClient.describeReplicator(crossinline block: DescribeReplicatorRequest.Builder.() -> Unit): DescribeReplicatorResponse = describeReplicator(DescribeReplicatorRequest.Builder().apply(block).build())

/**
 * Returns a description of this MSK VPC connection.
 */
public suspend inline fun KafkaClient.describeVpcConnection(crossinline block: DescribeVpcConnectionRequest.Builder.() -> Unit): DescribeVpcConnectionResponse = describeVpcConnection(DescribeVpcConnectionRequest.Builder().apply(block).build())

/**
 * A list of brokers that a client application can use to bootstrap.
 */
public suspend inline fun KafkaClient.getBootstrapBrokers(crossinline block: GetBootstrapBrokersRequest.Builder.() -> Unit): GetBootstrapBrokersResponse = getBootstrapBrokers(GetBootstrapBrokersRequest.Builder().apply(block).build())

/**
 * Get the MSK cluster policy specified by the Amazon Resource Name (ARN) in the request.
 */
public suspend inline fun KafkaClient.getClusterPolicy(crossinline block: GetClusterPolicyRequest.Builder.() -> Unit): GetClusterPolicyResponse = getClusterPolicy(GetClusterPolicyRequest.Builder().apply(block).build())

/**
 * Gets the Apache Kafka versions to which you can update the MSK cluster.
 */
public suspend inline fun KafkaClient.getCompatibleKafkaVersions(crossinline block: GetCompatibleKafkaVersionsRequest.Builder.() -> Unit): GetCompatibleKafkaVersionsResponse = getCompatibleKafkaVersions(GetCompatibleKafkaVersionsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the VPC connections in this Region.
 */
public suspend inline fun KafkaClient.listClientVpcConnections(crossinline block: ListClientVpcConnectionsRequest.Builder.() -> Unit): ListClientVpcConnectionsResponse = listClientVpcConnections(ListClientVpcConnectionsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the operations that have been performed on the specified MSK cluster.
 */
public suspend inline fun KafkaClient.listClusterOperations(crossinline block: ListClusterOperationsRequest.Builder.() -> Unit): ListClusterOperationsResponse = listClusterOperations(ListClusterOperationsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the operations that have been performed on the specified MSK cluster.
 */
public suspend inline fun KafkaClient.listClusterOperationsV2(crossinline block: ListClusterOperationsV2Request.Builder.() -> Unit): ListClusterOperationsV2Response = listClusterOperationsV2(ListClusterOperationsV2Request.Builder().apply(block).build())

/**
 * Returns a list of all the MSK clusters in the current Region.
 */
public suspend inline fun KafkaClient.listClusters(crossinline block: ListClustersRequest.Builder.() -> Unit): ListClustersResponse = listClusters(ListClustersRequest.Builder().apply(block).build())

/**
 * Returns a list of all the MSK clusters in the current Region.
 */
public suspend inline fun KafkaClient.listClustersV2(crossinline block: ListClustersV2Request.Builder.() -> Unit): ListClustersV2Response = listClustersV2(ListClustersV2Request.Builder().apply(block).build())

/**
 * Returns a list of all the MSK configurations in this Region.
 */
public suspend inline fun KafkaClient.listConfigurationRevisions(crossinline block: ListConfigurationRevisionsRequest.Builder.() -> Unit): ListConfigurationRevisionsResponse = listConfigurationRevisions(ListConfigurationRevisionsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the MSK configurations in this Region.
 */
public suspend inline fun KafkaClient.listConfigurations(crossinline block: ListConfigurationsRequest.Builder.() -> Unit): ListConfigurationsResponse = listConfigurations(ListConfigurationsRequest.Builder().apply(block).build())

/**
 * Returns a list of Apache Kafka versions.
 */
public suspend inline fun KafkaClient.listKafkaVersions(crossinline block: ListKafkaVersionsRequest.Builder.() -> Unit): ListKafkaVersionsResponse = listKafkaVersions(ListKafkaVersionsRequest.Builder().apply(block).build())

/**
 * Returns a list of the broker nodes in the cluster.
 */
public suspend inline fun KafkaClient.listNodes(crossinline block: ListNodesRequest.Builder.() -> Unit): ListNodesResponse = listNodes(ListNodesRequest.Builder().apply(block).build())

/**
 * Lists the replicators.
 */
public suspend inline fun KafkaClient.listReplicators(crossinline block: ListReplicatorsRequest.Builder.() -> Unit): ListReplicatorsResponse = listReplicators(ListReplicatorsRequest.Builder().apply(block).build())

/**
 * Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
 */
public suspend inline fun KafkaClient.listScramSecrets(crossinline block: ListScramSecretsRequest.Builder.() -> Unit): ListScramSecretsResponse = listScramSecrets(ListScramSecretsRequest.Builder().apply(block).build())

/**
 * Returns a list of the tags associated with the specified resource.
 */
public suspend inline fun KafkaClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of all the VPC connections in this Region.
 */
public suspend inline fun KafkaClient.listVpcConnections(crossinline block: ListVpcConnectionsRequest.Builder.() -> Unit): ListVpcConnectionsResponse = listVpcConnections(ListVpcConnectionsRequest.Builder().apply(block).build())

/**
 * Creates or updates the MSK cluster policy specified by the cluster Amazon Resource Name (ARN) in the request.
 */
public suspend inline fun KafkaClient.putClusterPolicy(crossinline block: PutClusterPolicyRequest.Builder.() -> Unit): PutClusterPolicyResponse = putClusterPolicy(PutClusterPolicyRequest.Builder().apply(block).build())

/**
 * Reboots brokers.
 */
public suspend inline fun KafkaClient.rebootBroker(crossinline block: RebootBrokerRequest.Builder.() -> Unit): RebootBrokerResponse = rebootBroker(RebootBrokerRequest.Builder().apply(block).build())

/**
 * Returns empty response.
 */
public suspend inline fun KafkaClient.rejectClientVpcConnection(crossinline block: RejectClientVpcConnectionRequest.Builder.() -> Unit): RejectClientVpcConnectionResponse = rejectClientVpcConnection(RejectClientVpcConnectionRequest.Builder().apply(block).build())

/**
 * Adds tags to the specified MSK resource.
 */
public suspend inline fun KafkaClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the tags associated with the keys that are provided in the query.
 */
public suspend inline fun KafkaClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the number of broker nodes in the cluster.
 */
public suspend inline fun KafkaClient.updateBrokerCount(crossinline block: UpdateBrokerCountRequest.Builder.() -> Unit): UpdateBrokerCountResponse = updateBrokerCount(UpdateBrokerCountRequest.Builder().apply(block).build())

/**
 * Updates the EBS storage associated with MSK brokers.
 */
public suspend inline fun KafkaClient.updateBrokerStorage(crossinline block: UpdateBrokerStorageRequest.Builder.() -> Unit): UpdateBrokerStorageResponse = updateBrokerStorage(UpdateBrokerStorageRequest.Builder().apply(block).build())

/**
 * Updates EC2 instance type.
 */
public suspend inline fun KafkaClient.updateBrokerType(crossinline block: UpdateBrokerTypeRequest.Builder.() -> Unit): UpdateBrokerTypeResponse = updateBrokerType(UpdateBrokerTypeRequest.Builder().apply(block).build())

/**
 * Updates the cluster with the configuration that is specified in the request body.
 */
public suspend inline fun KafkaClient.updateClusterConfiguration(crossinline block: UpdateClusterConfigurationRequest.Builder.() -> Unit): UpdateClusterConfigurationResponse = updateClusterConfiguration(UpdateClusterConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the Apache Kafka version for the cluster.
 */
public suspend inline fun KafkaClient.updateClusterKafkaVersion(crossinline block: UpdateClusterKafkaVersionRequest.Builder.() -> Unit): UpdateClusterKafkaVersionResponse = updateClusterKafkaVersion(UpdateClusterKafkaVersionRequest.Builder().apply(block).build())

/**
 * Updates an MSK configuration.
 */
public suspend inline fun KafkaClient.updateConfiguration(crossinline block: UpdateConfigurationRequest.Builder.() -> Unit): UpdateConfigurationResponse = updateConfiguration(UpdateConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the cluster's connectivity configuration.
 */
public suspend inline fun KafkaClient.updateConnectivity(crossinline block: UpdateConnectivityRequest.Builder.() -> Unit): UpdateConnectivityResponse = updateConnectivity(UpdateConnectivityRequest.Builder().apply(block).build())

/**
 * Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.
 */
public suspend inline fun KafkaClient.updateMonitoring(crossinline block: UpdateMonitoringRequest.Builder.() -> Unit): UpdateMonitoringResponse = updateMonitoring(UpdateMonitoringRequest.Builder().apply(block).build())

/**
 * Updates replication info of a replicator.
 */
public suspend inline fun KafkaClient.updateReplicationInfo(crossinline block: UpdateReplicationInfoRequest.Builder.() -> Unit): UpdateReplicationInfoResponse = updateReplicationInfo(UpdateReplicationInfoRequest.Builder().apply(block).build())

/**
 * Updates the security settings for the cluster. You can use this operation to specify encryption and authentication on existing clusters.
 */
public suspend inline fun KafkaClient.updateSecurity(crossinline block: UpdateSecurityRequest.Builder.() -> Unit): UpdateSecurityResponse = updateSecurity(UpdateSecurityRequest.Builder().apply(block).build())

/**
 * Updates cluster broker volume size (or) sets cluster storage mode to TIERED.
 */
public suspend inline fun KafkaClient.updateStorage(crossinline block: UpdateStorageRequest.Builder.() -> Unit): UpdateStorageResponse = updateStorage(UpdateStorageRequest.Builder().apply(block).build())
