// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.serde

import aws.sdk.kotlin.services.kafka.model.ConsumerGroupReplicationUpdate
import aws.sdk.kotlin.services.kafka.model.TopicReplicationUpdate
import aws.sdk.kotlin.services.kafka.model.UpdateReplicationInfoRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateReplicationInfoOperationSerializer: HttpSerialize<UpdateReplicationInfoRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateReplicationInfoRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.replicatorArn) { "replicatorArn is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("replication"))
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("replicators"))
                add(PercentEncoding.SmithyLabel.encode("${input.replicatorArn}"))
                add(PercentEncoding.Path.encode("replication-info"))
            }
        }

        val payload = serializeUpdateReplicationInfoOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateReplicationInfoOperationBody(context: ExecutionContext, input: UpdateReplicationInfoRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONSUMERGROUPREPLICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("consumerGroupReplication"))
    val CURRENTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("currentVersion"))
    val SOURCEKAFKACLUSTERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceKafkaClusterArn"))
    val TARGETKAFKACLUSTERARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("targetKafkaClusterArn"))
    val TOPICREPLICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("topicReplication"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONSUMERGROUPREPLICATION_DESCRIPTOR)
        field(CURRENTVERSION_DESCRIPTOR)
        field(SOURCEKAFKACLUSTERARN_DESCRIPTOR)
        field(TARGETKAFKACLUSTERARN_DESCRIPTOR)
        field(TOPICREPLICATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.consumerGroupReplication?.let { field(CONSUMERGROUPREPLICATION_DESCRIPTOR, it, ::serializeConsumerGroupReplicationUpdateDocument) }
        input.currentVersion?.let { field(CURRENTVERSION_DESCRIPTOR, it) }
        input.sourceKafkaClusterArn?.let { field(SOURCEKAFKACLUSTERARN_DESCRIPTOR, it) }
        input.targetKafkaClusterArn?.let { field(TARGETKAFKACLUSTERARN_DESCRIPTOR, it) }
        input.topicReplication?.let { field(TOPICREPLICATION_DESCRIPTOR, it, ::serializeTopicReplicationUpdateDocument) }
    }
    return serializer.toByteArray()
}
