// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a replicator.
 */
public class ReplicatorSummary private constructor(builder: Builder) {
    /**
     * The time the replicator was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The current version of the replicator.
     */
    public val currentVersion: kotlin.String? = builder.currentVersion
    /**
     * Whether this resource is a replicator reference.
     */
    public val isReplicatorReference: kotlin.Boolean? = builder.isReplicatorReference
    /**
     * Kafka Clusters used in setting up sources / targets for replication.
     */
    public val kafkaClustersSummary: List<KafkaClusterSummary>? = builder.kafkaClustersSummary
    /**
     * A list of summarized information of replications between clusters.
     */
    public val replicationInfoSummaryList: List<ReplicationInfoSummary>? = builder.replicationInfoSummaryList
    /**
     * The Amazon Resource Name (ARN) of the replicator.
     */
    public val replicatorArn: kotlin.String? = builder.replicatorArn
    /**
     * The name of the replicator.
     */
    public val replicatorName: kotlin.String? = builder.replicatorName
    /**
     * The Amazon Resource Name (ARN) of the replicator resource in the region where the replicator was created.
     */
    public val replicatorResourceArn: kotlin.String? = builder.replicatorResourceArn
    /**
     * State of the replicator.
     */
    public val replicatorState: aws.sdk.kotlin.services.kafka.model.ReplicatorState? = builder.replicatorState

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.ReplicatorSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicatorSummary(")
        append("creationTime=$creationTime,")
        append("currentVersion=$currentVersion,")
        append("isReplicatorReference=$isReplicatorReference,")
        append("kafkaClustersSummary=$kafkaClustersSummary,")
        append("replicationInfoSummaryList=$replicationInfoSummaryList,")
        append("replicatorArn=$replicatorArn,")
        append("replicatorName=$replicatorName,")
        append("replicatorResourceArn=$replicatorResourceArn,")
        append("replicatorState=$replicatorState")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (currentVersion?.hashCode() ?: 0)
        result = 31 * result + (isReplicatorReference?.hashCode() ?: 0)
        result = 31 * result + (kafkaClustersSummary?.hashCode() ?: 0)
        result = 31 * result + (replicationInfoSummaryList?.hashCode() ?: 0)
        result = 31 * result + (replicatorArn?.hashCode() ?: 0)
        result = 31 * result + (replicatorName?.hashCode() ?: 0)
        result = 31 * result + (replicatorResourceArn?.hashCode() ?: 0)
        result = 31 * result + (replicatorState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicatorSummary

        if (creationTime != other.creationTime) return false
        if (currentVersion != other.currentVersion) return false
        if (isReplicatorReference != other.isReplicatorReference) return false
        if (kafkaClustersSummary != other.kafkaClustersSummary) return false
        if (replicationInfoSummaryList != other.replicationInfoSummaryList) return false
        if (replicatorArn != other.replicatorArn) return false
        if (replicatorName != other.replicatorName) return false
        if (replicatorResourceArn != other.replicatorResourceArn) return false
        if (replicatorState != other.replicatorState) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.ReplicatorSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time the replicator was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current version of the replicator.
         */
        public var currentVersion: kotlin.String? = null
        /**
         * Whether this resource is a replicator reference.
         */
        public var isReplicatorReference: kotlin.Boolean? = null
        /**
         * Kafka Clusters used in setting up sources / targets for replication.
         */
        public var kafkaClustersSummary: List<KafkaClusterSummary>? = null
        /**
         * A list of summarized information of replications between clusters.
         */
        public var replicationInfoSummaryList: List<ReplicationInfoSummary>? = null
        /**
         * The Amazon Resource Name (ARN) of the replicator.
         */
        public var replicatorArn: kotlin.String? = null
        /**
         * The name of the replicator.
         */
        public var replicatorName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the replicator resource in the region where the replicator was created.
         */
        public var replicatorResourceArn: kotlin.String? = null
        /**
         * State of the replicator.
         */
        public var replicatorState: aws.sdk.kotlin.services.kafka.model.ReplicatorState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.ReplicatorSummary) : this() {
            this.creationTime = x.creationTime
            this.currentVersion = x.currentVersion
            this.isReplicatorReference = x.isReplicatorReference
            this.kafkaClustersSummary = x.kafkaClustersSummary
            this.replicationInfoSummaryList = x.replicationInfoSummaryList
            this.replicatorArn = x.replicatorArn
            this.replicatorName = x.replicatorName
            this.replicatorResourceArn = x.replicatorResourceArn
            this.replicatorState = x.replicatorState
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.ReplicatorSummary = ReplicatorSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
