// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.serde

import aws.sdk.kotlin.services.kafka.model.KafkaException
import aws.sdk.kotlin.services.kafka.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UntagResourceOperationDeserializer: HttpDeserialize<UntagResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UntagResourceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUntagResourceError(context, call)
        }
        val builder = UntagResourceResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUntagResourceError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KafkaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KafkaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
