// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model



/**
 * Request body for UpdateMonitoring.
 */
public class UpdateMonitoringRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
     */
    public val clusterArn: kotlin.String? = requireNotNull(builder.clusterArn) { "A non-null value must be provided for clusterArn" }
    /**
     * The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an MSK cluster to find its version. When this update operation is successful, it generates a new cluster version.
     */
    public val currentVersion: kotlin.String? = builder.currentVersion
    /**
     * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
     */
    public val enhancedMonitoring: aws.sdk.kotlin.services.kafka.model.EnhancedMonitoring? = builder.enhancedMonitoring
    public val loggingInfo: aws.sdk.kotlin.services.kafka.model.LoggingInfo? = builder.loggingInfo
    /**
     * The settings for open monitoring.
     */
    public val openMonitoring: aws.sdk.kotlin.services.kafka.model.OpenMonitoringInfo? = builder.openMonitoring

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.UpdateMonitoringRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateMonitoringRequest(")
        append("clusterArn=$clusterArn,")
        append("currentVersion=$currentVersion,")
        append("enhancedMonitoring=$enhancedMonitoring,")
        append("loggingInfo=$loggingInfo,")
        append("openMonitoring=$openMonitoring")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterArn?.hashCode() ?: 0
        result = 31 * result + (currentVersion?.hashCode() ?: 0)
        result = 31 * result + (enhancedMonitoring?.hashCode() ?: 0)
        result = 31 * result + (loggingInfo?.hashCode() ?: 0)
        result = 31 * result + (openMonitoring?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateMonitoringRequest

        if (clusterArn != other.clusterArn) return false
        if (currentVersion != other.currentVersion) return false
        if (enhancedMonitoring != other.enhancedMonitoring) return false
        if (loggingInfo != other.loggingInfo) return false
        if (openMonitoring != other.openMonitoring) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.UpdateMonitoringRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies the cluster.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an MSK cluster to find its version. When this update operation is successful, it generates a new cluster version.
         */
        public var currentVersion: kotlin.String? = null
        /**
         * Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.
         */
        public var enhancedMonitoring: aws.sdk.kotlin.services.kafka.model.EnhancedMonitoring? = null
        public var loggingInfo: aws.sdk.kotlin.services.kafka.model.LoggingInfo? = null
        /**
         * The settings for open monitoring.
         */
        public var openMonitoring: aws.sdk.kotlin.services.kafka.model.OpenMonitoringInfo? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.UpdateMonitoringRequest) : this() {
            this.clusterArn = x.clusterArn
            this.currentVersion = x.currentVersion
            this.enhancedMonitoring = x.enhancedMonitoring
            this.loggingInfo = x.loggingInfo
            this.openMonitoring = x.openMonitoring
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.UpdateMonitoringRequest = UpdateMonitoringRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.LoggingInfo] inside the given [block]
         */
        public fun loggingInfo(block: aws.sdk.kotlin.services.kafka.model.LoggingInfo.Builder.() -> kotlin.Unit) {
            this.loggingInfo = aws.sdk.kotlin.services.kafka.model.LoggingInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafka.model.OpenMonitoringInfo] inside the given [block]
         */
        public fun openMonitoring(block: aws.sdk.kotlin.services.kafka.model.OpenMonitoringInfo.Builder.() -> kotlin.Unit) {
            this.openMonitoring = aws.sdk.kotlin.services.kafka.model.OpenMonitoringInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (clusterArn == null) clusterArn = ""
            if (currentVersion == null) currentVersion = ""
            return this
        }
    }
}
