// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model



public class CreateConfigurationRequest private constructor(builder: Builder) {
    /**
     * The description of the configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The versions of Apache Kafka with which you can use this MSK configuration.
     */
    public val kafkaVersions: List<String>? = builder.kafkaVersions
    /**
     * The name of the configuration.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Contents of the <filename>server.properties file. When using the API, you must ensure that the contents of the file are base64 encoded. When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties can be in plaintext.
     */
    public val serverProperties: kotlin.ByteArray? = builder.serverProperties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafka.model.CreateConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConfigurationRequest(")
        append("description=$description,")
        append("kafkaVersions=$kafkaVersions,")
        append("name=$name,")
        append("serverProperties=$serverProperties")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (kafkaVersions?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (serverProperties?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateConfigurationRequest

        if (description != other.description) return false
        if (kafkaVersions != other.kafkaVersions) return false
        if (name != other.name) return false
        if (serverProperties != null) {
            if (other.serverProperties == null) return false
            if (!serverProperties.contentEquals(other.serverProperties)) return false
        } else if (other.serverProperties != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafka.model.CreateConfigurationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The description of the configuration.
         */
        public var description: kotlin.String? = null
        /**
         * The versions of Apache Kafka with which you can use this MSK configuration.
         */
        public var kafkaVersions: List<String>? = null
        /**
         * The name of the configuration.
         */
        public var name: kotlin.String? = null
        /**
         * Contents of the <filename>server.properties file. When using the API, you must ensure that the contents of the file are base64 encoded. When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties can be in plaintext.
         */
        public var serverProperties: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafka.model.CreateConfigurationRequest) : this() {
            this.description = x.description
            this.kafkaVersions = x.kafkaVersions
            this.name = x.name
            this.serverProperties = x.serverProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafka.model.CreateConfigurationRequest = CreateConfigurationRequest(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (serverProperties == null) serverProperties = ByteArray(0)
            return this
        }
    }
}
