// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.endpoints.internal

import aws.sdk.kotlin.services.kafka.KafkaClient
import aws.sdk.kotlin.services.kafka.endpoints.KafkaEndpointParameters
import aws.smithy.kotlin.runtime.auth.awssigning.mergeInto
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.signingContext
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest
import aws.smithy.kotlin.runtime.util.get

internal class EndpointResolverAdapter(
    private val config: KafkaClient.Config
): EndpointResolver {

    override suspend fun resolve(request: ResolveEndpointRequest): Endpoint {
        val params = KafkaEndpointParameters {
            bindAwsBuiltins(config)
            val opName = request.context[SdkClientOption.OperationName]
            opContextBindings[opName]?.invoke(this, request)
        }
        val endpoint = config.endpointProvider.resolveEndpoint(params)
        endpoint.signingContext?.mergeInto(request.context)
        return endpoint
    }
}

private typealias BindOperationContextParamsFn = (KafkaEndpointParameters.Builder, ResolveEndpointRequest) -> Unit

private val opContextBindings = mapOf<String, BindOperationContextParamsFn> (
)

private fun KafkaEndpointParameters.Builder.bindAwsBuiltins(config: KafkaClient.Config) {
    region = config.region
    useDualStack = config.useDualStack
    useFips = config.useFips
    endpoint = config.endpointUrl?.toString()
}
