// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.transform

import aws.sdk.kotlin.services.kafka.model.BrokerEbsVolumeInfo
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerStorageRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateBrokerStorageOperationSerializer: HttpSerialize<UpdateBrokerStorageRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateBrokerStorageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "v1",
                "clusters",
                "${input.clusterArn}".encodeLabel(),
                "nodes",
                "storage",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateBrokerStorageOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateBrokerStorageOperationBody(context: ExecutionContext, input: UpdateBrokerStorageRequest): ByteArray {
    val serializer = JsonSerializer()
    val CURRENTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("currentVersion"))
    val TARGETBROKEREBSVOLUMEINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("targetBrokerEBSVolumeInfo"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CURRENTVERSION_DESCRIPTOR)
        field(TARGETBROKEREBSVOLUMEINFO_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.currentVersion?.let { field(CURRENTVERSION_DESCRIPTOR, it) }
        if (input.targetBrokerEbsVolumeInfo != null) {
            listField(TARGETBROKEREBSVOLUMEINFO_DESCRIPTOR) {
                for (el0 in input.targetBrokerEbsVolumeInfo) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeBrokerEbsVolumeInfoDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
