// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.transform

import aws.sdk.kotlin.services.kafka.model.GetBootstrapBrokersResponse
import aws.sdk.kotlin.services.kafka.model.KafkaException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetBootstrapBrokersOperationDeserializer: HttpDeserialize<GetBootstrapBrokersResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetBootstrapBrokersResponse {
        if (!response.status.isSuccess()) {
            throwGetBootstrapBrokersError(context, response)
        }
        val builder = GetBootstrapBrokersResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetBootstrapBrokersOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetBootstrapBrokersError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KafkaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KafkaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBootstrapBrokersOperationBody(builder: GetBootstrapBrokersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOOTSTRAPBROKERSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerString"))
    val BOOTSTRAPBROKERSTRINGPUBLICSASLIAM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringPublicSaslIam"))
    val BOOTSTRAPBROKERSTRINGPUBLICSASLSCRAM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringPublicSaslScram"))
    val BOOTSTRAPBROKERSTRINGPUBLICTLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringPublicTls"))
    val BOOTSTRAPBROKERSTRINGSASLIAM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringSaslIam"))
    val BOOTSTRAPBROKERSTRINGSASLSCRAM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringSaslScram"))
    val BOOTSTRAPBROKERSTRINGTLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringTls"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOOTSTRAPBROKERSTRING_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGPUBLICSASLIAM_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGPUBLICSASLSCRAM_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGPUBLICTLS_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGSASLIAM_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGSASLSCRAM_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGTLS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOOTSTRAPBROKERSTRING_DESCRIPTOR.index -> builder.bootstrapBrokerString = deserializeString()
                BOOTSTRAPBROKERSTRINGPUBLICSASLIAM_DESCRIPTOR.index -> builder.bootstrapBrokerStringPublicSaslIam = deserializeString()
                BOOTSTRAPBROKERSTRINGPUBLICSASLSCRAM_DESCRIPTOR.index -> builder.bootstrapBrokerStringPublicSaslScram = deserializeString()
                BOOTSTRAPBROKERSTRINGPUBLICTLS_DESCRIPTOR.index -> builder.bootstrapBrokerStringPublicTls = deserializeString()
                BOOTSTRAPBROKERSTRINGSASLIAM_DESCRIPTOR.index -> builder.bootstrapBrokerStringSaslIam = deserializeString()
                BOOTSTRAPBROKERSTRINGSASLSCRAM_DESCRIPTOR.index -> builder.bootstrapBrokerStringSaslScram = deserializeString()
                BOOTSTRAPBROKERSTRINGTLS_DESCRIPTOR.index -> builder.bootstrapBrokerStringTls = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
