// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.kafka.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.kafka.endpoints.EndpointParameters
import aws.sdk.kotlin.services.kafka.endpoints.EndpointProvider
import aws.sdk.kotlin.services.kafka.model.BatchAssociateScramSecretRequest
import aws.sdk.kotlin.services.kafka.model.BatchAssociateScramSecretResponse
import aws.sdk.kotlin.services.kafka.model.BatchDisassociateScramSecretRequest
import aws.sdk.kotlin.services.kafka.model.BatchDisassociateScramSecretResponse
import aws.sdk.kotlin.services.kafka.model.CreateClusterRequest
import aws.sdk.kotlin.services.kafka.model.CreateClusterResponse
import aws.sdk.kotlin.services.kafka.model.CreateClusterV2Request
import aws.sdk.kotlin.services.kafka.model.CreateClusterV2Response
import aws.sdk.kotlin.services.kafka.model.CreateConfigurationRequest
import aws.sdk.kotlin.services.kafka.model.CreateConfigurationResponse
import aws.sdk.kotlin.services.kafka.model.DeleteClusterRequest
import aws.sdk.kotlin.services.kafka.model.DeleteClusterResponse
import aws.sdk.kotlin.services.kafka.model.DeleteConfigurationRequest
import aws.sdk.kotlin.services.kafka.model.DeleteConfigurationResponse
import aws.sdk.kotlin.services.kafka.model.DescribeClusterOperationRequest
import aws.sdk.kotlin.services.kafka.model.DescribeClusterOperationResponse
import aws.sdk.kotlin.services.kafka.model.DescribeClusterRequest
import aws.sdk.kotlin.services.kafka.model.DescribeClusterResponse
import aws.sdk.kotlin.services.kafka.model.DescribeClusterV2Request
import aws.sdk.kotlin.services.kafka.model.DescribeClusterV2Response
import aws.sdk.kotlin.services.kafka.model.DescribeConfigurationRequest
import aws.sdk.kotlin.services.kafka.model.DescribeConfigurationResponse
import aws.sdk.kotlin.services.kafka.model.DescribeConfigurationRevisionRequest
import aws.sdk.kotlin.services.kafka.model.DescribeConfigurationRevisionResponse
import aws.sdk.kotlin.services.kafka.model.GetBootstrapBrokersRequest
import aws.sdk.kotlin.services.kafka.model.GetBootstrapBrokersResponse
import aws.sdk.kotlin.services.kafka.model.GetCompatibleKafkaVersionsRequest
import aws.sdk.kotlin.services.kafka.model.GetCompatibleKafkaVersionsResponse
import aws.sdk.kotlin.services.kafka.model.ListClusterOperationsRequest
import aws.sdk.kotlin.services.kafka.model.ListClusterOperationsResponse
import aws.sdk.kotlin.services.kafka.model.ListClustersRequest
import aws.sdk.kotlin.services.kafka.model.ListClustersResponse
import aws.sdk.kotlin.services.kafka.model.ListClustersV2Request
import aws.sdk.kotlin.services.kafka.model.ListClustersV2Response
import aws.sdk.kotlin.services.kafka.model.ListConfigurationRevisionsRequest
import aws.sdk.kotlin.services.kafka.model.ListConfigurationRevisionsResponse
import aws.sdk.kotlin.services.kafka.model.ListConfigurationsRequest
import aws.sdk.kotlin.services.kafka.model.ListConfigurationsResponse
import aws.sdk.kotlin.services.kafka.model.ListKafkaVersionsRequest
import aws.sdk.kotlin.services.kafka.model.ListKafkaVersionsResponse
import aws.sdk.kotlin.services.kafka.model.ListNodesRequest
import aws.sdk.kotlin.services.kafka.model.ListNodesResponse
import aws.sdk.kotlin.services.kafka.model.ListScramSecretsRequest
import aws.sdk.kotlin.services.kafka.model.ListScramSecretsResponse
import aws.sdk.kotlin.services.kafka.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.kafka.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.kafka.model.RebootBrokerRequest
import aws.sdk.kotlin.services.kafka.model.RebootBrokerResponse
import aws.sdk.kotlin.services.kafka.model.TagResourceRequest
import aws.sdk.kotlin.services.kafka.model.TagResourceResponse
import aws.sdk.kotlin.services.kafka.model.UntagResourceRequest
import aws.sdk.kotlin.services.kafka.model.UntagResourceResponse
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerCountRequest
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerCountResponse
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerStorageRequest
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerStorageResponse
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerTypeRequest
import aws.sdk.kotlin.services.kafka.model.UpdateBrokerTypeResponse
import aws.sdk.kotlin.services.kafka.model.UpdateClusterConfigurationRequest
import aws.sdk.kotlin.services.kafka.model.UpdateClusterConfigurationResponse
import aws.sdk.kotlin.services.kafka.model.UpdateClusterKafkaVersionRequest
import aws.sdk.kotlin.services.kafka.model.UpdateClusterKafkaVersionResponse
import aws.sdk.kotlin.services.kafka.model.UpdateConfigurationRequest
import aws.sdk.kotlin.services.kafka.model.UpdateConfigurationResponse
import aws.sdk.kotlin.services.kafka.model.UpdateConnectivityRequest
import aws.sdk.kotlin.services.kafka.model.UpdateConnectivityResponse
import aws.sdk.kotlin.services.kafka.model.UpdateMonitoringRequest
import aws.sdk.kotlin.services.kafka.model.UpdateMonitoringResponse
import aws.sdk.kotlin.services.kafka.model.UpdateSecurityRequest
import aws.sdk.kotlin.services.kafka.model.UpdateSecurityResponse
import aws.sdk.kotlin.services.kafka.model.UpdateStorageRequest
import aws.sdk.kotlin.services.kafka.model.UpdateStorageResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * The operations for managing an Amazon MSK cluster.
 */
public interface KafkaClient : SdkClient {
    /**
     * KafkaClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, KafkaClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, KafkaClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): KafkaClient = DefaultKafkaClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val clientName: String = builder.clientName
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, clientName)
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            interceptors = this@Config.interceptors.toMutableList()
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            sdkLogMode = this@Config.sdkLogMode
            signer = this@Config.signer
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, HttpClientConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Kafka"

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates one or more Scram Secrets with an Amazon MSK cluster.
     */
    public suspend fun batchAssociateScramSecret(input: BatchAssociateScramSecretRequest): BatchAssociateScramSecretResponse

    /**
     * Disassociates one or more Scram Secrets from an Amazon MSK cluster.
     */
    public suspend fun batchDisassociateScramSecret(input: BatchDisassociateScramSecretRequest): BatchDisassociateScramSecretResponse

    /**
     * Creates a new MSK cluster.
     */
    public suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates a new MSK cluster.
     */
    public suspend fun createClusterV2(input: CreateClusterV2Request): CreateClusterV2Response

    /**
     * Creates a new MSK configuration.
     */
    public suspend fun createConfiguration(input: CreateConfigurationRequest): CreateConfigurationResponse

    /**
     * Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.
     */
    public suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Deletes an MSK Configuration.
     */
    public suspend fun deleteConfiguration(input: DeleteConfigurationRequest): DeleteConfigurationResponse

    /**
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     */
    public suspend fun describeCluster(input: DescribeClusterRequest): DescribeClusterResponse

    /**
     * Returns a description of the cluster operation specified by the ARN.
     */
    public suspend fun describeClusterOperation(input: DescribeClusterOperationRequest): DescribeClusterOperationResponse

    /**
     * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
     */
    public suspend fun describeClusterV2(input: DescribeClusterV2Request): DescribeClusterV2Response

    /**
     * Returns a description of this MSK configuration.
     */
    public suspend fun describeConfiguration(input: DescribeConfigurationRequest): DescribeConfigurationResponse

    /**
     * Returns a description of this revision of the configuration.
     */
    public suspend fun describeConfigurationRevision(input: DescribeConfigurationRevisionRequest): DescribeConfigurationRevisionResponse

    /**
     * A list of brokers that a client application can use to bootstrap.
     */
    public suspend fun getBootstrapBrokers(input: GetBootstrapBrokersRequest): GetBootstrapBrokersResponse

    /**
     * Gets the Apache Kafka versions to which you can update the MSK cluster.
     */
    public suspend fun getCompatibleKafkaVersions(input: GetCompatibleKafkaVersionsRequest = GetCompatibleKafkaVersionsRequest {}): GetCompatibleKafkaVersionsResponse

    /**
     * Returns a list of all the operations that have been performed on the specified MSK cluster.
     */
    public suspend fun listClusterOperations(input: ListClusterOperationsRequest): ListClusterOperationsResponse

    /**
     * Returns a list of all the MSK clusters in the current Region.
     */
    public suspend fun listClusters(input: ListClustersRequest = ListClustersRequest {}): ListClustersResponse

    /**
     * Returns a list of all the MSK clusters in the current Region.
     */
    public suspend fun listClustersV2(input: ListClustersV2Request = ListClustersV2Request {}): ListClustersV2Response

    /**
     * Returns a list of all the MSK configurations in this Region.
     */
    public suspend fun listConfigurationRevisions(input: ListConfigurationRevisionsRequest): ListConfigurationRevisionsResponse

    /**
     * Returns a list of all the MSK configurations in this Region.
     */
    public suspend fun listConfigurations(input: ListConfigurationsRequest = ListConfigurationsRequest {}): ListConfigurationsResponse

    /**
     * Returns a list of Apache Kafka versions.
     */
    public suspend fun listKafkaVersions(input: ListKafkaVersionsRequest = ListKafkaVersionsRequest {}): ListKafkaVersionsResponse

    /**
     * Returns a list of the broker nodes in the cluster.
     */
    public suspend fun listNodes(input: ListNodesRequest): ListNodesResponse

    /**
     * Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
     */
    public suspend fun listScramSecrets(input: ListScramSecretsRequest): ListScramSecretsResponse

    /**
     * Returns a list of the tags associated with the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Reboots brokers.
     */
    public suspend fun rebootBroker(input: RebootBrokerRequest): RebootBrokerResponse

    /**
     * Adds tags to the specified MSK resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the tags associated with the keys that are provided in the query.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the number of broker nodes in the cluster.
     */
    public suspend fun updateBrokerCount(input: UpdateBrokerCountRequest): UpdateBrokerCountResponse

    /**
     * Updates the EBS storage associated with MSK brokers.
     */
    public suspend fun updateBrokerStorage(input: UpdateBrokerStorageRequest): UpdateBrokerStorageResponse

    /**
     * Updates EC2 instance type.
     */
    public suspend fun updateBrokerType(input: UpdateBrokerTypeRequest): UpdateBrokerTypeResponse

    /**
     * Updates the cluster with the configuration that is specified in the request body.
     */
    public suspend fun updateClusterConfiguration(input: UpdateClusterConfigurationRequest): UpdateClusterConfigurationResponse

    /**
     * Updates the Apache Kafka version for the cluster.
     */
    public suspend fun updateClusterKafkaVersion(input: UpdateClusterKafkaVersionRequest): UpdateClusterKafkaVersionResponse

    /**
     * Updates an MSK configuration.
     */
    public suspend fun updateConfiguration(input: UpdateConfigurationRequest): UpdateConfigurationResponse

    /**
     * Updates the cluster's connectivity configuration.
     */
    public suspend fun updateConnectivity(input: UpdateConnectivityRequest): UpdateConnectivityResponse

    /**
     * Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.
     */
    public suspend fun updateMonitoring(input: UpdateMonitoringRequest): UpdateMonitoringResponse

    /**
     * Updates the security settings for the cluster. You can use this operation to specify encryption and authentication on existing clusters.
     */
    public suspend fun updateSecurity(input: UpdateSecurityRequest): UpdateSecurityResponse

    /**
     * Updates cluster broker volume size (or) sets cluster storage mode to TIERED.
     */
    public suspend fun updateStorage(input: UpdateStorageRequest): UpdateStorageResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun KafkaClient.withConfig(block: KafkaClient.Config.Builder.() -> Unit): KafkaClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultKafkaClient(newConfig)
}

/**
 * Associates one or more Scram Secrets with an Amazon MSK cluster.
 */
public suspend inline fun KafkaClient.batchAssociateScramSecret(crossinline block: BatchAssociateScramSecretRequest.Builder.() -> Unit): BatchAssociateScramSecretResponse = batchAssociateScramSecret(BatchAssociateScramSecretRequest.Builder().apply(block).build())

/**
 * Disassociates one or more Scram Secrets from an Amazon MSK cluster.
 */
public suspend inline fun KafkaClient.batchDisassociateScramSecret(crossinline block: BatchDisassociateScramSecretRequest.Builder.() -> Unit): BatchDisassociateScramSecretResponse = batchDisassociateScramSecret(BatchDisassociateScramSecretRequest.Builder().apply(block).build())

/**
 * Creates a new MSK cluster.
 */
public suspend inline fun KafkaClient.createCluster(crossinline block: CreateClusterRequest.Builder.() -> Unit): CreateClusterResponse = createCluster(CreateClusterRequest.Builder().apply(block).build())

/**
 * Creates a new MSK cluster.
 */
public suspend inline fun KafkaClient.createClusterV2(crossinline block: CreateClusterV2Request.Builder.() -> Unit): CreateClusterV2Response = createClusterV2(CreateClusterV2Request.Builder().apply(block).build())

/**
 * Creates a new MSK configuration.
 */
public suspend inline fun KafkaClient.createConfiguration(crossinline block: CreateConfigurationRequest.Builder.() -> Unit): CreateConfigurationResponse = createConfiguration(CreateConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.
 */
public suspend inline fun KafkaClient.deleteCluster(crossinline block: DeleteClusterRequest.Builder.() -> Unit): DeleteClusterResponse = deleteCluster(DeleteClusterRequest.Builder().apply(block).build())

/**
 * Deletes an MSK Configuration.
 */
public suspend inline fun KafkaClient.deleteConfiguration(crossinline block: DeleteConfigurationRequest.Builder.() -> Unit): DeleteConfigurationResponse = deleteConfiguration(DeleteConfigurationRequest.Builder().apply(block).build())

/**
 * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
 */
public suspend inline fun KafkaClient.describeCluster(crossinline block: DescribeClusterRequest.Builder.() -> Unit): DescribeClusterResponse = describeCluster(DescribeClusterRequest.Builder().apply(block).build())

/**
 * Returns a description of the cluster operation specified by the ARN.
 */
public suspend inline fun KafkaClient.describeClusterOperation(crossinline block: DescribeClusterOperationRequest.Builder.() -> Unit): DescribeClusterOperationResponse = describeClusterOperation(DescribeClusterOperationRequest.Builder().apply(block).build())

/**
 * Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
 */
public suspend inline fun KafkaClient.describeClusterV2(crossinline block: DescribeClusterV2Request.Builder.() -> Unit): DescribeClusterV2Response = describeClusterV2(DescribeClusterV2Request.Builder().apply(block).build())

/**
 * Returns a description of this MSK configuration.
 */
public suspend inline fun KafkaClient.describeConfiguration(crossinline block: DescribeConfigurationRequest.Builder.() -> Unit): DescribeConfigurationResponse = describeConfiguration(DescribeConfigurationRequest.Builder().apply(block).build())

/**
 * Returns a description of this revision of the configuration.
 */
public suspend inline fun KafkaClient.describeConfigurationRevision(crossinline block: DescribeConfigurationRevisionRequest.Builder.() -> Unit): DescribeConfigurationRevisionResponse = describeConfigurationRevision(DescribeConfigurationRevisionRequest.Builder().apply(block).build())

/**
 * A list of brokers that a client application can use to bootstrap.
 */
public suspend inline fun KafkaClient.getBootstrapBrokers(crossinline block: GetBootstrapBrokersRequest.Builder.() -> Unit): GetBootstrapBrokersResponse = getBootstrapBrokers(GetBootstrapBrokersRequest.Builder().apply(block).build())

/**
 * Gets the Apache Kafka versions to which you can update the MSK cluster.
 */
public suspend inline fun KafkaClient.getCompatibleKafkaVersions(crossinline block: GetCompatibleKafkaVersionsRequest.Builder.() -> Unit): GetCompatibleKafkaVersionsResponse = getCompatibleKafkaVersions(GetCompatibleKafkaVersionsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the operations that have been performed on the specified MSK cluster.
 */
public suspend inline fun KafkaClient.listClusterOperations(crossinline block: ListClusterOperationsRequest.Builder.() -> Unit): ListClusterOperationsResponse = listClusterOperations(ListClusterOperationsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the MSK clusters in the current Region.
 */
public suspend inline fun KafkaClient.listClusters(crossinline block: ListClustersRequest.Builder.() -> Unit): ListClustersResponse = listClusters(ListClustersRequest.Builder().apply(block).build())

/**
 * Returns a list of all the MSK clusters in the current Region.
 */
public suspend inline fun KafkaClient.listClustersV2(crossinline block: ListClustersV2Request.Builder.() -> Unit): ListClustersV2Response = listClustersV2(ListClustersV2Request.Builder().apply(block).build())

/**
 * Returns a list of all the MSK configurations in this Region.
 */
public suspend inline fun KafkaClient.listConfigurationRevisions(crossinline block: ListConfigurationRevisionsRequest.Builder.() -> Unit): ListConfigurationRevisionsResponse = listConfigurationRevisions(ListConfigurationRevisionsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the MSK configurations in this Region.
 */
public suspend inline fun KafkaClient.listConfigurations(crossinline block: ListConfigurationsRequest.Builder.() -> Unit): ListConfigurationsResponse = listConfigurations(ListConfigurationsRequest.Builder().apply(block).build())

/**
 * Returns a list of Apache Kafka versions.
 */
public suspend inline fun KafkaClient.listKafkaVersions(crossinline block: ListKafkaVersionsRequest.Builder.() -> Unit): ListKafkaVersionsResponse = listKafkaVersions(ListKafkaVersionsRequest.Builder().apply(block).build())

/**
 * Returns a list of the broker nodes in the cluster.
 */
public suspend inline fun KafkaClient.listNodes(crossinline block: ListNodesRequest.Builder.() -> Unit): ListNodesResponse = listNodes(ListNodesRequest.Builder().apply(block).build())

/**
 * Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
 */
public suspend inline fun KafkaClient.listScramSecrets(crossinline block: ListScramSecretsRequest.Builder.() -> Unit): ListScramSecretsResponse = listScramSecrets(ListScramSecretsRequest.Builder().apply(block).build())

/**
 * Returns a list of the tags associated with the specified resource.
 */
public suspend inline fun KafkaClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Reboots brokers.
 */
public suspend inline fun KafkaClient.rebootBroker(crossinline block: RebootBrokerRequest.Builder.() -> Unit): RebootBrokerResponse = rebootBroker(RebootBrokerRequest.Builder().apply(block).build())

/**
 * Adds tags to the specified MSK resource.
 */
public suspend inline fun KafkaClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the tags associated with the keys that are provided in the query.
 */
public suspend inline fun KafkaClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the number of broker nodes in the cluster.
 */
public suspend inline fun KafkaClient.updateBrokerCount(crossinline block: UpdateBrokerCountRequest.Builder.() -> Unit): UpdateBrokerCountResponse = updateBrokerCount(UpdateBrokerCountRequest.Builder().apply(block).build())

/**
 * Updates the EBS storage associated with MSK brokers.
 */
public suspend inline fun KafkaClient.updateBrokerStorage(crossinline block: UpdateBrokerStorageRequest.Builder.() -> Unit): UpdateBrokerStorageResponse = updateBrokerStorage(UpdateBrokerStorageRequest.Builder().apply(block).build())

/**
 * Updates EC2 instance type.
 */
public suspend inline fun KafkaClient.updateBrokerType(crossinline block: UpdateBrokerTypeRequest.Builder.() -> Unit): UpdateBrokerTypeResponse = updateBrokerType(UpdateBrokerTypeRequest.Builder().apply(block).build())

/**
 * Updates the cluster with the configuration that is specified in the request body.
 */
public suspend inline fun KafkaClient.updateClusterConfiguration(crossinline block: UpdateClusterConfigurationRequest.Builder.() -> Unit): UpdateClusterConfigurationResponse = updateClusterConfiguration(UpdateClusterConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the Apache Kafka version for the cluster.
 */
public suspend inline fun KafkaClient.updateClusterKafkaVersion(crossinline block: UpdateClusterKafkaVersionRequest.Builder.() -> Unit): UpdateClusterKafkaVersionResponse = updateClusterKafkaVersion(UpdateClusterKafkaVersionRequest.Builder().apply(block).build())

/**
 * Updates an MSK configuration.
 */
public suspend inline fun KafkaClient.updateConfiguration(crossinline block: UpdateConfigurationRequest.Builder.() -> Unit): UpdateConfigurationResponse = updateConfiguration(UpdateConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the cluster's connectivity configuration.
 */
public suspend inline fun KafkaClient.updateConnectivity(crossinline block: UpdateConnectivityRequest.Builder.() -> Unit): UpdateConnectivityResponse = updateConnectivity(UpdateConnectivityRequest.Builder().apply(block).build())

/**
 * Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.
 */
public suspend inline fun KafkaClient.updateMonitoring(crossinline block: UpdateMonitoringRequest.Builder.() -> Unit): UpdateMonitoringResponse = updateMonitoring(UpdateMonitoringRequest.Builder().apply(block).build())

/**
 * Updates the security settings for the cluster. You can use this operation to specify encryption and authentication on existing clusters.
 */
public suspend inline fun KafkaClient.updateSecurity(crossinline block: UpdateSecurityRequest.Builder.() -> Unit): UpdateSecurityResponse = updateSecurity(UpdateSecurityRequest.Builder().apply(block).build())

/**
 * Updates cluster broker volume size (or) sets cluster storage mode to TIERED.
 */
public suspend inline fun KafkaClient.updateStorage(crossinline block: UpdateStorageRequest.Builder.() -> Unit): UpdateStorageResponse = updateStorage(UpdateStorageRequest.Builder().apply(block).build())
