// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.transform

import aws.sdk.kotlin.services.ivsrealtime.model.GetStageSessionResponse
import aws.sdk.kotlin.services.ivsrealtime.model.IvsRealTimeException
import aws.sdk.kotlin.services.ivsrealtime.model.StageSession
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetStageSessionOperationDeserializer: HttpDeserialize<GetStageSessionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetStageSessionResponse {
        if (!response.status.isSuccess()) {
            throwGetStageSessionError(context, response)
        }
        val builder = GetStageSessionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetStageSessionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetStageSessionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IvsRealTimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IvsRealTimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetStageSessionOperationBody(builder: GetStageSessionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val STAGESESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("stageSession"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(STAGESESSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                STAGESESSION_DESCRIPTOR.index -> builder.stageSession = deserializeStageSessionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
