// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.transform

import aws.sdk.kotlin.services.ivsrealtime.model.CreateParticipantTokenResponse
import aws.sdk.kotlin.services.ivsrealtime.model.IvsRealTimeException
import aws.sdk.kotlin.services.ivsrealtime.model.ParticipantToken
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateParticipantTokenOperationDeserializer: HttpDeserialize<CreateParticipantTokenResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateParticipantTokenResponse {
        if (!response.status.isSuccess()) {
            throwCreateParticipantTokenError(context, response)
        }
        val builder = CreateParticipantTokenResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateParticipantTokenOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateParticipantTokenError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IvsRealTimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "PendingVerification" -> PendingVerificationDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IvsRealTimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateParticipantTokenOperationBody(builder: CreateParticipantTokenResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PARTICIPANTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("participantToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PARTICIPANTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PARTICIPANTTOKEN_DESCRIPTOR.index -> builder.participantToken = deserializeParticipantTokenDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
