// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.paginators

import aws.sdk.kotlin.services.ivsrealtime.IvsRealTimeClient
import aws.sdk.kotlin.services.ivsrealtime.model.ListParticipantEventsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListParticipantEventsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListParticipantsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListParticipantsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListStageSessionsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListStageSessionsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListStagesRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListStagesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListParticipantEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListParticipantEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListParticipantEventsResponse]
 */
public fun IvsRealTimeClient.listParticipantEventsPaginated(initialRequest: ListParticipantEventsRequest): Flow<ListParticipantEventsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listParticipantEventsPaginated.listParticipantEvents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListParticipantEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListParticipantEventsResponse]
 */
public fun IvsRealTimeClient.listParticipantEventsPaginated(block: ListParticipantEventsRequest.Builder.() -> Unit): Flow<ListParticipantEventsResponse> =
    listParticipantEventsPaginated(ListParticipantEventsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListParticipantsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListParticipantsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListParticipantsResponse]
 */
public fun IvsRealTimeClient.listParticipantsPaginated(initialRequest: ListParticipantsRequest): Flow<ListParticipantsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listParticipantsPaginated.listParticipants(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListParticipantsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListParticipantsResponse]
 */
public fun IvsRealTimeClient.listParticipantsPaginated(block: ListParticipantsRequest.Builder.() -> Unit): Flow<ListParticipantsResponse> =
    listParticipantsPaginated(ListParticipantsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListStagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStagesResponse]
 */
public fun IvsRealTimeClient.listStagesPaginated(initialRequest: ListStagesRequest): Flow<ListStagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStagesPaginated.listStages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStagesResponse]
 */
public fun IvsRealTimeClient.listStagesPaginated(block: ListStagesRequest.Builder.() -> Unit): Flow<ListStagesResponse> =
    listStagesPaginated(ListStagesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListStageSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStageSessionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStageSessionsResponse]
 */
public fun IvsRealTimeClient.listStageSessionsPaginated(initialRequest: ListStageSessionsRequest): Flow<ListStageSessionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStageSessionsPaginated.listStageSessions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStageSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStageSessionsResponse]
 */
public fun IvsRealTimeClient.listStageSessionsPaginated(block: ListStageSessionsRequest.Builder.() -> Unit): Flow<ListStageSessionsResponse> =
    listStageSessionsPaginated(ListStageSessionsRequest.Builder().apply(block).build())
