// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.ivsrealtime.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.ivsrealtime.endpoints.EndpointParameters
import aws.sdk.kotlin.services.ivsrealtime.endpoints.EndpointProvider
import aws.sdk.kotlin.services.ivsrealtime.model.CreateParticipantTokenRequest
import aws.sdk.kotlin.services.ivsrealtime.model.CreateParticipantTokenResponse
import aws.sdk.kotlin.services.ivsrealtime.model.CreateStageRequest
import aws.sdk.kotlin.services.ivsrealtime.model.CreateStageResponse
import aws.sdk.kotlin.services.ivsrealtime.model.DeleteStageRequest
import aws.sdk.kotlin.services.ivsrealtime.model.DeleteStageResponse
import aws.sdk.kotlin.services.ivsrealtime.model.DisconnectParticipantRequest
import aws.sdk.kotlin.services.ivsrealtime.model.DisconnectParticipantResponse
import aws.sdk.kotlin.services.ivsrealtime.model.GetParticipantRequest
import aws.sdk.kotlin.services.ivsrealtime.model.GetParticipantResponse
import aws.sdk.kotlin.services.ivsrealtime.model.GetStageRequest
import aws.sdk.kotlin.services.ivsrealtime.model.GetStageResponse
import aws.sdk.kotlin.services.ivsrealtime.model.GetStageSessionRequest
import aws.sdk.kotlin.services.ivsrealtime.model.GetStageSessionResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListParticipantEventsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListParticipantEventsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListParticipantsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListParticipantsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListStageSessionsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListStageSessionsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListStagesRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListStagesResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.ivsrealtime.model.TagResourceRequest
import aws.sdk.kotlin.services.ivsrealtime.model.TagResourceResponse
import aws.sdk.kotlin.services.ivsrealtime.model.UntagResourceRequest
import aws.sdk.kotlin.services.ivsrealtime.model.UntagResourceResponse
import aws.sdk.kotlin.services.ivsrealtime.model.UpdateStageRequest
import aws.sdk.kotlin.services.ivsrealtime.model.UpdateStageResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "IVS RealTime"
public const val SdkVersion: String = "0.29.1-beta"

/**
 * **Introduction**
 *
 * The Amazon Interactive Video Service (IVS) stage API is REST compatible, using a standard HTTP API and an AWS EventBridge event stream for responses. JSON is used for both requests and responses, including errors.
 *
 * Terminology:
 * + The IVS stage API sometimes is referred to as the IVS *RealTime* API.
 * + A *participant token* is an authorization token used to publish/subscribe to a stage.
 * + A *participant object* represents participants (people) in the stage and contains information about them. When a token is created, it includes a participant ID; when a participant uses that token to join a stage, the participant is associated with that participant ID There is a 1:1 mapping between participant tokens and participants.
 *
 * **Resources**
 *
 * The following resources contain information about your IVS live stream (see [Getting Started with Amazon IVS](https://docs.aws.amazon.com/ivs/latest/userguide/getting-started.html)):
 * + **Stage** — A stage is a virtual space where multiple participants can exchange audio and video in real time.
 *
 * **Tagging**
 *
 * A *tag* is a metadata label that you assign to an AWS resource. A tag comprises a *key* and a *value*, both set by you. For example, you might set a tag as `topic:nature` to label a particular video category. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS stages has no service-specific constraints beyond what is documented there.
 *
 * Tags can help you identify and organize your AWS resources. For example, you can use the same tag for different resources to indicate that they are related. You can also use tags to manage access (see [Access Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html)).
 *
 * The Amazon IVS stage API has these tag-related endpoints: TagResource, UntagResource, and ListTagsForResource. The following resource supports tagging: Stage.
 *
 * At most 50 tags can be applied to a resource.
 *
 * **Stages Endpoints**
 * + CreateParticipantToken — Creates an additional token for a specified stage. This can be done after stage creation or when tokens expire.
 * + CreateStage — Creates a new stage (and optionally participant tokens).
 * + DeleteStage — Shuts down and deletes the specified stage (disconnecting all participants).
 * + DisconnectParticipant — Disconnects a specified participant and revokes the participant permanently from a specified stage.
 * + GetParticipant — Gets information about the specified participant token.
 * + GetStage — Gets information for the specified stage.
 * + GetStageSession — Gets information for the specified stage session.
 * + ListParticipantEvents — Lists events for a specified participant that occurred during a specified stage session.
 * + ListParticipants — Lists all participants in a specified stage session.
 * + ListStages — Gets summary information about all stages in your account, in the AWS region where the API request is processed.
 * + ListStageSessions — Gets all sessions for a specified stage.
 * + UpdateStage — Updates a stage’s configuration.
 *
 * **Tags Endpoints**
 * + ListTagsForResource — Gets information about AWS tags for the specified ARN.
 * + TagResource — Adds or updates tags for the AWS resource with the specified ARN.
 * + UntagResource — Removes tags from the resource with the specified ARN.
 */
public interface IvsRealTimeClient : SdkClient {
    /**
     * IvsRealTimeClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, IvsRealTimeClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, IvsRealTimeClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): IvsRealTimeClient = DefaultIvsRealTimeClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "IVS RealTime"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [HttpAuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an additional token for a specified stage. This can be done after stage creation or when tokens expire. Tokens always are scoped to the stage for which they are created.
     *
     * Encryption keys are owned by Amazon IVS and never used directly by your application.
     */
    public suspend fun createParticipantToken(input: CreateParticipantTokenRequest): CreateParticipantTokenResponse

    /**
     * Creates a new stage (and optionally participant tokens).
     */
    public suspend fun createStage(input: CreateStageRequest = CreateStageRequest {}): CreateStageResponse

    /**
     * Shuts down and deletes the specified stage (disconnecting all participants).
     */
    public suspend fun deleteStage(input: DeleteStageRequest): DeleteStageResponse

    /**
     * Disconnects a specified participant and revokes the participant permanently from a specified stage.
     */
    public suspend fun disconnectParticipant(input: DisconnectParticipantRequest): DisconnectParticipantResponse

    /**
     * Gets information about the specified participant token.
     */
    public suspend fun getParticipant(input: GetParticipantRequest): GetParticipantResponse

    /**
     * Gets information for the specified stage.
     */
    public suspend fun getStage(input: GetStageRequest): GetStageResponse

    /**
     * Gets information for the specified stage session.
     */
    public suspend fun getStageSession(input: GetStageSessionRequest): GetStageSessionResponse

    /**
     * Lists events for a specified participant that occurred during a specified stage session.
     */
    public suspend fun listParticipantEvents(input: ListParticipantEventsRequest): ListParticipantEventsResponse

    /**
     * Lists all participants in a specified stage session.
     */
    public suspend fun listParticipants(input: ListParticipantsRequest): ListParticipantsResponse

    /**
     * Gets all sessions for a specified stage.
     */
    public suspend fun listStageSessions(input: ListStageSessionsRequest): ListStageSessionsResponse

    /**
     * Gets summary information about all stages in your account, in the AWS region where the API request is processed.
     */
    public suspend fun listStages(input: ListStagesRequest = ListStagesRequest {}): ListStagesResponse

    /**
     * Gets information about AWS tags for the specified ARN.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds or updates tags for the AWS resource with the specified ARN.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from the resource with the specified ARN.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a stage’s configuration.
     */
    public suspend fun updateStage(input: UpdateStageRequest): UpdateStageResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun IvsRealTimeClient.withConfig(block: IvsRealTimeClient.Config.Builder.() -> Unit): IvsRealTimeClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIvsRealTimeClient(newConfig)
}

/**
 * Creates an additional token for a specified stage. This can be done after stage creation or when tokens expire. Tokens always are scoped to the stage for which they are created.
 *
 * Encryption keys are owned by Amazon IVS and never used directly by your application.
 */
public suspend inline fun IvsRealTimeClient.createParticipantToken(crossinline block: CreateParticipantTokenRequest.Builder.() -> Unit): CreateParticipantTokenResponse = createParticipantToken(CreateParticipantTokenRequest.Builder().apply(block).build())

/**
 * Creates a new stage (and optionally participant tokens).
 */
public suspend inline fun IvsRealTimeClient.createStage(crossinline block: CreateStageRequest.Builder.() -> Unit): CreateStageResponse = createStage(CreateStageRequest.Builder().apply(block).build())

/**
 * Shuts down and deletes the specified stage (disconnecting all participants).
 */
public suspend inline fun IvsRealTimeClient.deleteStage(crossinline block: DeleteStageRequest.Builder.() -> Unit): DeleteStageResponse = deleteStage(DeleteStageRequest.Builder().apply(block).build())

/**
 * Disconnects a specified participant and revokes the participant permanently from a specified stage.
 */
public suspend inline fun IvsRealTimeClient.disconnectParticipant(crossinline block: DisconnectParticipantRequest.Builder.() -> Unit): DisconnectParticipantResponse = disconnectParticipant(DisconnectParticipantRequest.Builder().apply(block).build())

/**
 * Gets information about the specified participant token.
 */
public suspend inline fun IvsRealTimeClient.getParticipant(crossinline block: GetParticipantRequest.Builder.() -> Unit): GetParticipantResponse = getParticipant(GetParticipantRequest.Builder().apply(block).build())

/**
 * Gets information for the specified stage.
 */
public suspend inline fun IvsRealTimeClient.getStage(crossinline block: GetStageRequest.Builder.() -> Unit): GetStageResponse = getStage(GetStageRequest.Builder().apply(block).build())

/**
 * Gets information for the specified stage session.
 */
public suspend inline fun IvsRealTimeClient.getStageSession(crossinline block: GetStageSessionRequest.Builder.() -> Unit): GetStageSessionResponse = getStageSession(GetStageSessionRequest.Builder().apply(block).build())

/**
 * Lists events for a specified participant that occurred during a specified stage session.
 */
public suspend inline fun IvsRealTimeClient.listParticipantEvents(crossinline block: ListParticipantEventsRequest.Builder.() -> Unit): ListParticipantEventsResponse = listParticipantEvents(ListParticipantEventsRequest.Builder().apply(block).build())

/**
 * Lists all participants in a specified stage session.
 */
public suspend inline fun IvsRealTimeClient.listParticipants(crossinline block: ListParticipantsRequest.Builder.() -> Unit): ListParticipantsResponse = listParticipants(ListParticipantsRequest.Builder().apply(block).build())

/**
 * Gets all sessions for a specified stage.
 */
public suspend inline fun IvsRealTimeClient.listStageSessions(crossinline block: ListStageSessionsRequest.Builder.() -> Unit): ListStageSessionsResponse = listStageSessions(ListStageSessionsRequest.Builder().apply(block).build())

/**
 * Gets summary information about all stages in your account, in the AWS region where the API request is processed.
 */
public suspend inline fun IvsRealTimeClient.listStages(crossinline block: ListStagesRequest.Builder.() -> Unit): ListStagesResponse = listStages(ListStagesRequest.Builder().apply(block).build())

/**
 * Gets information about AWS tags for the specified ARN.
 */
public suspend inline fun IvsRealTimeClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds or updates tags for the AWS resource with the specified ARN.
 */
public suspend inline fun IvsRealTimeClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from the resource with the specified ARN.
 */
public suspend inline fun IvsRealTimeClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a stage’s configuration.
 */
public suspend inline fun IvsRealTimeClient.updateStage(crossinline block: UpdateStageRequest.Builder.() -> Unit): UpdateStageResponse = updateStage(UpdateStageRequest.Builder().apply(block).build())
