// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration information specific to Picture-in-Picture (PiP) layout, for [server-side composition](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/server-side-composition.html).
 */
public class PipConfiguration private constructor(builder: Builder) {
    /**
     * This attribute name identifies the featured slot. A participant with this attribute set to `"true"` (as a string value) in ParticipantTokenConfiguration is placed in the featured slot. Default: `""` (no featured participant).
     */
    public val featuredParticipantAttribute: kotlin.String? = builder.featuredParticipantAttribute
    /**
     * Specifies the spacing between participant tiles in pixels. Default: `0`.
     */
    public val gridGap: kotlin.Int = builder.gridGap
    /**
     * Determines whether to omit participants with stopped video in the composition. Default: `false`.
     */
    public val omitStoppedVideo: kotlin.Boolean = builder.omitStoppedVideo
    /**
     * Defines PiP behavior when all participants have left: `STATIC` (maintains original position/size) or `DYNAMIC` (expands to full composition). Default: `STATIC`.
     */
    public val pipBehavior: aws.sdk.kotlin.services.ivsrealtime.model.PipBehavior? = builder.pipBehavior
    /**
     * Specifies the height of the PiP window in pixels. When this is not set explicitly, `pipHeight`’s value will be based on the size of the composition and the aspect ratio of the participant’s video.
     */
    public val pipHeight: kotlin.Int? = builder.pipHeight
    /**
     * Sets the PiP window’s offset position in pixels from the closest edges determined by `PipPosition`. Default: `0`.
     */
    public val pipOffset: kotlin.Int = builder.pipOffset
    /**
     * Specifies the participant for the PiP window. A participant with this attribute set to `"true"` (as a string value) in ParticipantTokenConfiguration is placed in the PiP slot. Default: `""` (no PiP participant).
     */
    public val pipParticipantAttribute: kotlin.String? = builder.pipParticipantAttribute
    /**
     * Determines the corner position of the PiP window. Default: `BOTTOM_RIGHT`.
     */
    public val pipPosition: aws.sdk.kotlin.services.ivsrealtime.model.PipPosition? = builder.pipPosition
    /**
     * Specifies the width of the PiP window in pixels. When this is not set explicitly, `pipWidth`’s value will be based on the size of the composition and the aspect ratio of the participant’s video.
     */
    public val pipWidth: kotlin.Int? = builder.pipWidth
    /**
     * Defines how video content fits within the participant tile: `FILL` (stretched), `COVER` (cropped), or `CONTAIN` (letterboxed). Default: `COVER`.
     */
    public val videoFillMode: aws.sdk.kotlin.services.ivsrealtime.model.VideoFillMode? = builder.videoFillMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivsrealtime.model.PipConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PipConfiguration(")
        append("featuredParticipantAttribute=$featuredParticipantAttribute,")
        append("gridGap=$gridGap,")
        append("omitStoppedVideo=$omitStoppedVideo,")
        append("pipBehavior=$pipBehavior,")
        append("pipHeight=$pipHeight,")
        append("pipOffset=$pipOffset,")
        append("pipParticipantAttribute=$pipParticipantAttribute,")
        append("pipPosition=$pipPosition,")
        append("pipWidth=$pipWidth,")
        append("videoFillMode=$videoFillMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = featuredParticipantAttribute?.hashCode() ?: 0
        result = 31 * result + (gridGap)
        result = 31 * result + (omitStoppedVideo.hashCode())
        result = 31 * result + (pipBehavior?.hashCode() ?: 0)
        result = 31 * result + (pipHeight ?: 0)
        result = 31 * result + (pipOffset)
        result = 31 * result + (pipParticipantAttribute?.hashCode() ?: 0)
        result = 31 * result + (pipPosition?.hashCode() ?: 0)
        result = 31 * result + (pipWidth ?: 0)
        result = 31 * result + (videoFillMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PipConfiguration

        if (featuredParticipantAttribute != other.featuredParticipantAttribute) return false
        if (gridGap != other.gridGap) return false
        if (omitStoppedVideo != other.omitStoppedVideo) return false
        if (pipBehavior != other.pipBehavior) return false
        if (pipHeight != other.pipHeight) return false
        if (pipOffset != other.pipOffset) return false
        if (pipParticipantAttribute != other.pipParticipantAttribute) return false
        if (pipPosition != other.pipPosition) return false
        if (pipWidth != other.pipWidth) return false
        if (videoFillMode != other.videoFillMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivsrealtime.model.PipConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This attribute name identifies the featured slot. A participant with this attribute set to `"true"` (as a string value) in ParticipantTokenConfiguration is placed in the featured slot. Default: `""` (no featured participant).
         */
        public var featuredParticipantAttribute: kotlin.String? = null
        /**
         * Specifies the spacing between participant tiles in pixels. Default: `0`.
         */
        public var gridGap: kotlin.Int = 0
        /**
         * Determines whether to omit participants with stopped video in the composition. Default: `false`.
         */
        public var omitStoppedVideo: kotlin.Boolean = false
        /**
         * Defines PiP behavior when all participants have left: `STATIC` (maintains original position/size) or `DYNAMIC` (expands to full composition). Default: `STATIC`.
         */
        public var pipBehavior: aws.sdk.kotlin.services.ivsrealtime.model.PipBehavior? = null
        /**
         * Specifies the height of the PiP window in pixels. When this is not set explicitly, `pipHeight`’s value will be based on the size of the composition and the aspect ratio of the participant’s video.
         */
        public var pipHeight: kotlin.Int? = null
        /**
         * Sets the PiP window’s offset position in pixels from the closest edges determined by `PipPosition`. Default: `0`.
         */
        public var pipOffset: kotlin.Int = 0
        /**
         * Specifies the participant for the PiP window. A participant with this attribute set to `"true"` (as a string value) in ParticipantTokenConfiguration is placed in the PiP slot. Default: `""` (no PiP participant).
         */
        public var pipParticipantAttribute: kotlin.String? = null
        /**
         * Determines the corner position of the PiP window. Default: `BOTTOM_RIGHT`.
         */
        public var pipPosition: aws.sdk.kotlin.services.ivsrealtime.model.PipPosition? = null
        /**
         * Specifies the width of the PiP window in pixels. When this is not set explicitly, `pipWidth`’s value will be based on the size of the composition and the aspect ratio of the participant’s video.
         */
        public var pipWidth: kotlin.Int? = null
        /**
         * Defines how video content fits within the participant tile: `FILL` (stretched), `COVER` (cropped), or `CONTAIN` (letterboxed). Default: `COVER`.
         */
        public var videoFillMode: aws.sdk.kotlin.services.ivsrealtime.model.VideoFillMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivsrealtime.model.PipConfiguration) : this() {
            this.featuredParticipantAttribute = x.featuredParticipantAttribute
            this.gridGap = x.gridGap
            this.omitStoppedVideo = x.omitStoppedVideo
            this.pipBehavior = x.pipBehavior
            this.pipHeight = x.pipHeight
            this.pipOffset = x.pipOffset
            this.pipParticipantAttribute = x.pipParticipantAttribute
            this.pipPosition = x.pipPosition
            this.pipWidth = x.pipWidth
            this.videoFillMode = x.videoFillMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivsrealtime.model.PipConfiguration = PipConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
