// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.paginators

import aws.sdk.kotlin.services.ivsrealtime.IvsRealTimeClient
import aws.sdk.kotlin.services.ivsrealtime.model.ListCompositionsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListCompositionsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListEncoderConfigurationsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListEncoderConfigurationsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListParticipantEventsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListParticipantEventsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListParticipantsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListParticipantsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListPublicKeysRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListPublicKeysResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListStageSessionsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListStageSessionsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListStagesRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListStagesResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListStorageConfigurationsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListStorageConfigurationsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.PublicKeySummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListCompositionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCompositionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCompositionsResponse]
 */
public fun IvsRealTimeClient.listCompositionsPaginated(initialRequest: ListCompositionsRequest = ListCompositionsRequest { }): Flow<ListCompositionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCompositionsPaginated.listCompositions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCompositionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCompositionsResponse]
 */
public fun IvsRealTimeClient.listCompositionsPaginated(block: ListCompositionsRequest.Builder.() -> Unit): Flow<ListCompositionsResponse> =
    listCompositionsPaginated(ListCompositionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListEncoderConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEncoderConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEncoderConfigurationsResponse]
 */
public fun IvsRealTimeClient.listEncoderConfigurationsPaginated(initialRequest: ListEncoderConfigurationsRequest = ListEncoderConfigurationsRequest { }): Flow<ListEncoderConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEncoderConfigurationsPaginated.listEncoderConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEncoderConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEncoderConfigurationsResponse]
 */
public fun IvsRealTimeClient.listEncoderConfigurationsPaginated(block: ListEncoderConfigurationsRequest.Builder.() -> Unit): Flow<ListEncoderConfigurationsResponse> =
    listEncoderConfigurationsPaginated(ListEncoderConfigurationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListParticipantEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListParticipantEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListParticipantEventsResponse]
 */
public fun IvsRealTimeClient.listParticipantEventsPaginated(initialRequest: ListParticipantEventsRequest): Flow<ListParticipantEventsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listParticipantEventsPaginated.listParticipantEvents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListParticipantEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListParticipantEventsResponse]
 */
public fun IvsRealTimeClient.listParticipantEventsPaginated(block: ListParticipantEventsRequest.Builder.() -> Unit): Flow<ListParticipantEventsResponse> =
    listParticipantEventsPaginated(ListParticipantEventsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListParticipantsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListParticipantsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListParticipantsResponse]
 */
public fun IvsRealTimeClient.listParticipantsPaginated(initialRequest: ListParticipantsRequest): Flow<ListParticipantsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listParticipantsPaginated.listParticipants(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListParticipantsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListParticipantsResponse]
 */
public fun IvsRealTimeClient.listParticipantsPaginated(block: ListParticipantsRequest.Builder.() -> Unit): Flow<ListParticipantsResponse> =
    listParticipantsPaginated(ListParticipantsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPublicKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPublicKeysRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPublicKeysResponse]
 */
public fun IvsRealTimeClient.listPublicKeysPaginated(initialRequest: ListPublicKeysRequest = ListPublicKeysRequest { }): Flow<ListPublicKeysResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPublicKeysPaginated.listPublicKeys(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPublicKeysResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPublicKeysResponse]
 */
public fun IvsRealTimeClient.listPublicKeysPaginated(block: ListPublicKeysRequest.Builder.() -> Unit): Flow<ListPublicKeysResponse> =
    listPublicKeysPaginated(ListPublicKeysRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPublicKeysPaginated]
 * to access the nested member [PublicKeySummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PublicKeySummary]
 */
@JvmName("listPublicKeysResponsePublicKeySummary")
public fun Flow<ListPublicKeysResponse>.publicKeys(): Flow<PublicKeySummary> =
    transform() { response ->
        response.publicKeys?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStagesResponse]
 */
public fun IvsRealTimeClient.listStagesPaginated(initialRequest: ListStagesRequest = ListStagesRequest { }): Flow<ListStagesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStagesPaginated.listStages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStagesResponse]
 */
public fun IvsRealTimeClient.listStagesPaginated(block: ListStagesRequest.Builder.() -> Unit): Flow<ListStagesResponse> =
    listStagesPaginated(ListStagesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListStageSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStageSessionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStageSessionsResponse]
 */
public fun IvsRealTimeClient.listStageSessionsPaginated(initialRequest: ListStageSessionsRequest): Flow<ListStageSessionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStageSessionsPaginated.listStageSessions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStageSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStageSessionsResponse]
 */
public fun IvsRealTimeClient.listStageSessionsPaginated(block: ListStageSessionsRequest.Builder.() -> Unit): Flow<ListStageSessionsResponse> =
    listStageSessionsPaginated(ListStageSessionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListStorageConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStorageConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStorageConfigurationsResponse]
 */
public fun IvsRealTimeClient.listStorageConfigurationsPaginated(initialRequest: ListStorageConfigurationsRequest = ListStorageConfigurationsRequest { }): Flow<ListStorageConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStorageConfigurationsPaginated.listStorageConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStorageConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStorageConfigurationsResponse]
 */
public fun IvsRealTimeClient.listStorageConfigurationsPaginated(block: ListStorageConfigurationsRequest.Builder.() -> Unit): Flow<ListStorageConfigurationsResponse> =
    listStorageConfigurationsPaginated(ListStorageConfigurationsRequest.Builder().apply(block).build())
