// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Object specifying a stage.
 */
public class Stage private constructor(builder: Builder) {
    /**
     * ID of the active session within the stage.
     */
    public val activeSessionId: kotlin.String? = builder.activeSessionId
    /**
     * Stage ARN.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * Configuration object for individual participant recording, attached to the stage.
     */
    public val autoParticipantRecordingConfiguration: aws.sdk.kotlin.services.ivsrealtime.model.AutoParticipantRecordingConfiguration? = builder.autoParticipantRecordingConfiguration
    /**
     * Summary information about various endpoints for a stage.
     */
    public val endpoints: aws.sdk.kotlin.services.ivsrealtime.model.StageEndpoints? = builder.endpoints
    /**
     * Stage name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Tags attached to the resource. Array of maps, each of the form `string:string (key:value)`. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivsrealtime.model.Stage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Stage(")
        append("activeSessionId=$activeSessionId,")
        append("arn=$arn,")
        append("autoParticipantRecordingConfiguration=$autoParticipantRecordingConfiguration,")
        append("endpoints=$endpoints,")
        append("name=$name,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeSessionId?.hashCode() ?: 0
        result = 31 * result + (arn.hashCode())
        result = 31 * result + (autoParticipantRecordingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (endpoints?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Stage

        if (activeSessionId != other.activeSessionId) return false
        if (arn != other.arn) return false
        if (autoParticipantRecordingConfiguration != other.autoParticipantRecordingConfiguration) return false
        if (endpoints != other.endpoints) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivsrealtime.model.Stage = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * ID of the active session within the stage.
         */
        public var activeSessionId: kotlin.String? = null
        /**
         * Stage ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * Configuration object for individual participant recording, attached to the stage.
         */
        public var autoParticipantRecordingConfiguration: aws.sdk.kotlin.services.ivsrealtime.model.AutoParticipantRecordingConfiguration? = null
        /**
         * Summary information about various endpoints for a stage.
         */
        public var endpoints: aws.sdk.kotlin.services.ivsrealtime.model.StageEndpoints? = null
        /**
         * Stage name.
         */
        public var name: kotlin.String? = null
        /**
         * Tags attached to the resource. Array of maps, each of the form `string:string (key:value)`. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivsrealtime.model.Stage) : this() {
            this.activeSessionId = x.activeSessionId
            this.arn = x.arn
            this.autoParticipantRecordingConfiguration = x.autoParticipantRecordingConfiguration
            this.endpoints = x.endpoints
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivsrealtime.model.Stage = Stage(this)

        /**
         * construct an [aws.sdk.kotlin.services.ivsrealtime.model.AutoParticipantRecordingConfiguration] inside the given [block]
         */
        public fun autoParticipantRecordingConfiguration(block: aws.sdk.kotlin.services.ivsrealtime.model.AutoParticipantRecordingConfiguration.Builder.() -> kotlin.Unit) {
            this.autoParticipantRecordingConfiguration = aws.sdk.kotlin.services.ivsrealtime.model.AutoParticipantRecordingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ivsrealtime.model.StageEndpoints] inside the given [block]
         */
        public fun endpoints(block: aws.sdk.kotlin.services.ivsrealtime.model.StageEndpoints.Builder.() -> kotlin.Unit) {
            this.endpoints = aws.sdk.kotlin.services.ivsrealtime.model.StageEndpoints.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            return this
        }
    }
}
