// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Object describing a participant that has joined a stage.
 */
public class Participant private constructor(builder: Builder) {
    /**
     * Application-provided attributes to encode into the token and attach to a stage. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information*.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The participant’s browser.
     */
    public val browserName: kotlin.String? = builder.browserName
    /**
     * The participant’s browser version.
     */
    public val browserVersion: kotlin.String? = builder.browserVersion
    /**
     * ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.
     */
    public val firstJoinTime: aws.smithy.kotlin.runtime.time.Instant? = builder.firstJoinTime
    /**
     * The participant’s Internet Service Provider.
     */
    public val ispName: kotlin.String? = builder.ispName
    /**
     * The participant’s operating system.
     */
    public val osName: kotlin.String? = builder.osName
    /**
     * The participant’s operating system version.
     */
    public val osVersion: kotlin.String? = builder.osVersion
    /**
     * Unique identifier for this participant, assigned by IVS.
     */
    public val participantId: kotlin.String? = builder.participantId
    /**
     * Whether the participant ever published to the stage session.
     */
    public val published: kotlin.Boolean = builder.published
    /**
     * Name of the S3 bucket to where the participant is being recorded, if individual participant recording is enabled, or `""` (empty string), if recording is not enabled.
     */
    public val recordingS3BucketName: kotlin.String? = builder.recordingS3BucketName
    /**
     * S3 prefix of the S3 bucket where the participant is being recorded, if individual participant recording is enabled, or `""` (empty string), if recording is not enabled.
     */
    public val recordingS3Prefix: kotlin.String? = builder.recordingS3Prefix
    /**
     * The participant’s recording state.
     */
    public val recordingState: aws.sdk.kotlin.services.ivsrealtime.model.ParticipantRecordingState? = builder.recordingState
    /**
     * The participant’s SDK version.
     */
    public val sdkVersion: kotlin.String? = builder.sdkVersion
    /**
     * Whether the participant is connected to or disconnected from the stage.
     */
    public val state: aws.sdk.kotlin.services.ivsrealtime.model.ParticipantState? = builder.state
    /**
     * Customer-assigned name to help identify the token; this can be used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information*.
     */
    public val userId: kotlin.String? = builder.userId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivsrealtime.model.Participant = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Participant(")
        append("attributes=$attributes,")
        append("browserName=$browserName,")
        append("browserVersion=$browserVersion,")
        append("firstJoinTime=$firstJoinTime,")
        append("ispName=$ispName,")
        append("osName=$osName,")
        append("osVersion=$osVersion,")
        append("participantId=$participantId,")
        append("published=$published,")
        append("recordingS3BucketName=$recordingS3BucketName,")
        append("recordingS3Prefix=$recordingS3Prefix,")
        append("recordingState=$recordingState,")
        append("sdkVersion=$sdkVersion,")
        append("state=$state,")
        append("userId=$userId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (browserName?.hashCode() ?: 0)
        result = 31 * result + (browserVersion?.hashCode() ?: 0)
        result = 31 * result + (firstJoinTime?.hashCode() ?: 0)
        result = 31 * result + (ispName?.hashCode() ?: 0)
        result = 31 * result + (osName?.hashCode() ?: 0)
        result = 31 * result + (osVersion?.hashCode() ?: 0)
        result = 31 * result + (participantId?.hashCode() ?: 0)
        result = 31 * result + (published.hashCode())
        result = 31 * result + (recordingS3BucketName?.hashCode() ?: 0)
        result = 31 * result + (recordingS3Prefix?.hashCode() ?: 0)
        result = 31 * result + (recordingState?.hashCode() ?: 0)
        result = 31 * result + (sdkVersion?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Participant

        if (attributes != other.attributes) return false
        if (browserName != other.browserName) return false
        if (browserVersion != other.browserVersion) return false
        if (firstJoinTime != other.firstJoinTime) return false
        if (ispName != other.ispName) return false
        if (osName != other.osName) return false
        if (osVersion != other.osVersion) return false
        if (participantId != other.participantId) return false
        if (published != other.published) return false
        if (recordingS3BucketName != other.recordingS3BucketName) return false
        if (recordingS3Prefix != other.recordingS3Prefix) return false
        if (recordingState != other.recordingState) return false
        if (sdkVersion != other.sdkVersion) return false
        if (state != other.state) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivsrealtime.model.Participant = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Application-provided attributes to encode into the token and attach to a stage. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information*.
         */
        public var attributes: Map<String, String>? = null
        /**
         * The participant’s browser.
         */
        public var browserName: kotlin.String? = null
        /**
         * The participant’s browser version.
         */
        public var browserVersion: kotlin.String? = null
        /**
         * ISO 8601 timestamp (returned as a string) when the participant first joined the stage session.
         */
        public var firstJoinTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The participant’s Internet Service Provider.
         */
        public var ispName: kotlin.String? = null
        /**
         * The participant’s operating system.
         */
        public var osName: kotlin.String? = null
        /**
         * The participant’s operating system version.
         */
        public var osVersion: kotlin.String? = null
        /**
         * Unique identifier for this participant, assigned by IVS.
         */
        public var participantId: kotlin.String? = null
        /**
         * Whether the participant ever published to the stage session.
         */
        public var published: kotlin.Boolean = false
        /**
         * Name of the S3 bucket to where the participant is being recorded, if individual participant recording is enabled, or `""` (empty string), if recording is not enabled.
         */
        public var recordingS3BucketName: kotlin.String? = null
        /**
         * S3 prefix of the S3 bucket where the participant is being recorded, if individual participant recording is enabled, or `""` (empty string), if recording is not enabled.
         */
        public var recordingS3Prefix: kotlin.String? = null
        /**
         * The participant’s recording state.
         */
        public var recordingState: aws.sdk.kotlin.services.ivsrealtime.model.ParticipantRecordingState? = null
        /**
         * The participant’s SDK version.
         */
        public var sdkVersion: kotlin.String? = null
        /**
         * Whether the participant is connected to or disconnected from the stage.
         */
        public var state: aws.sdk.kotlin.services.ivsrealtime.model.ParticipantState? = null
        /**
         * Customer-assigned name to help identify the token; this can be used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information*.
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivsrealtime.model.Participant) : this() {
            this.attributes = x.attributes
            this.browserName = x.browserName
            this.browserVersion = x.browserVersion
            this.firstJoinTime = x.firstJoinTime
            this.ispName = x.ispName
            this.osName = x.osName
            this.osVersion = x.osVersion
            this.participantId = x.participantId
            this.published = x.published
            this.recordingS3BucketName = x.recordingS3BucketName
            this.recordingS3Prefix = x.recordingS3Prefix
            this.recordingState = x.recordingState
            this.sdkVersion = x.sdkVersion
            this.state = x.state
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivsrealtime.model.Participant = Participant(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
