// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration information specific to Grid layout, for server-side composition. See "Layouts" in [Server-Side Composition](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/server-side-composition.html).
 */
public class GridConfiguration private constructor(builder: Builder) {
    /**
     * This attribute name identifies the featured slot. A participant with this attribute set to `"true"` (as a string value) in ParticipantTokenConfiguration is placed in the featured slot. Default: `""` (no featured participant).
     */
    public val featuredParticipantAttribute: kotlin.String? = builder.featuredParticipantAttribute
    /**
     * Specifies the spacing between participant tiles in pixels. Default: `2`.
     */
    public val gridGap: kotlin.Int = builder.gridGap
    /**
     * Determines whether to omit participants with stopped video in the composition. Default: `false`.
     */
    public val omitStoppedVideo: kotlin.Boolean = builder.omitStoppedVideo
    /**
     * Sets the non-featured participant display mode, to control the aspect ratio of video tiles. `VIDEO` is 16:9, `SQUARE` is 1:1, and `PORTRAIT` is 3:4. Default: `VIDEO`.
     */
    public val videoAspectRatio: aws.sdk.kotlin.services.ivsrealtime.model.VideoAspectRatio? = builder.videoAspectRatio
    /**
     * Defines how video content fits within the participant tile: `FILL` (stretched), `COVER` (cropped), or `CONTAIN` (letterboxed). When not set, `videoFillMode` defaults to `COVER` fill mode for participants in the grid and to `CONTAIN` fill mode for featured participants.
     */
    public val videoFillMode: aws.sdk.kotlin.services.ivsrealtime.model.VideoFillMode? = builder.videoFillMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivsrealtime.model.GridConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GridConfiguration(")
        append("featuredParticipantAttribute=$featuredParticipantAttribute,")
        append("gridGap=$gridGap,")
        append("omitStoppedVideo=$omitStoppedVideo,")
        append("videoAspectRatio=$videoAspectRatio,")
        append("videoFillMode=$videoFillMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = featuredParticipantAttribute?.hashCode() ?: 0
        result = 31 * result + (gridGap)
        result = 31 * result + (omitStoppedVideo.hashCode())
        result = 31 * result + (videoAspectRatio?.hashCode() ?: 0)
        result = 31 * result + (videoFillMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GridConfiguration

        if (featuredParticipantAttribute != other.featuredParticipantAttribute) return false
        if (gridGap != other.gridGap) return false
        if (omitStoppedVideo != other.omitStoppedVideo) return false
        if (videoAspectRatio != other.videoAspectRatio) return false
        if (videoFillMode != other.videoFillMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivsrealtime.model.GridConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This attribute name identifies the featured slot. A participant with this attribute set to `"true"` (as a string value) in ParticipantTokenConfiguration is placed in the featured slot. Default: `""` (no featured participant).
         */
        public var featuredParticipantAttribute: kotlin.String? = null
        /**
         * Specifies the spacing between participant tiles in pixels. Default: `2`.
         */
        public var gridGap: kotlin.Int = 0
        /**
         * Determines whether to omit participants with stopped video in the composition. Default: `false`.
         */
        public var omitStoppedVideo: kotlin.Boolean = false
        /**
         * Sets the non-featured participant display mode, to control the aspect ratio of video tiles. `VIDEO` is 16:9, `SQUARE` is 1:1, and `PORTRAIT` is 3:4. Default: `VIDEO`.
         */
        public var videoAspectRatio: aws.sdk.kotlin.services.ivsrealtime.model.VideoAspectRatio? = null
        /**
         * Defines how video content fits within the participant tile: `FILL` (stretched), `COVER` (cropped), or `CONTAIN` (letterboxed). When not set, `videoFillMode` defaults to `COVER` fill mode for participants in the grid and to `CONTAIN` fill mode for featured participants.
         */
        public var videoFillMode: aws.sdk.kotlin.services.ivsrealtime.model.VideoFillMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivsrealtime.model.GridConfiguration) : this() {
            this.featuredParticipantAttribute = x.featuredParticipantAttribute
            this.gridGap = x.gridGap
            this.omitStoppedVideo = x.omitStoppedVideo
            this.videoAspectRatio = x.videoAspectRatio
            this.videoFillMode = x.videoFillMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivsrealtime.model.GridConfiguration = GridConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
