// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about a Composition.
 */
public class CompositionSummary private constructor(builder: Builder) {
    /**
     * ARN of the Composition resource.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * Array of Destination objects.
     */
    public val destinations: List<DestinationSummary> = requireNotNull(builder.destinations) { "A non-null value must be provided for destinations" }
    /**
     * UTC time of the Composition end. This is an ISO 8601 timestamp; *note that this is returned as a string*.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * ARN of the attached stage.
     */
    public val stageArn: kotlin.String = requireNotNull(builder.stageArn) { "A non-null value must be provided for stageArn" }
    /**
     * UTC time of the Composition start. This is an ISO 8601 timestamp; *note that this is returned as a string*.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * State of the Composition resource.
     */
    public val state: aws.sdk.kotlin.services.ivsrealtime.model.CompositionState = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * Tags attached to the resource. Array of maps, each of the form `string:string (key:value)`. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivsrealtime.model.CompositionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CompositionSummary(")
        append("arn=$arn,")
        append("destinations=$destinations,")
        append("endTime=$endTime,")
        append("stageArn=$stageArn,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (destinations.hashCode())
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (stageArn.hashCode())
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CompositionSummary

        if (arn != other.arn) return false
        if (destinations != other.destinations) return false
        if (endTime != other.endTime) return false
        if (stageArn != other.stageArn) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivsrealtime.model.CompositionSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * ARN of the Composition resource.
         */
        public var arn: kotlin.String? = null
        /**
         * Array of Destination objects.
         */
        public var destinations: List<DestinationSummary>? = null
        /**
         * UTC time of the Composition end. This is an ISO 8601 timestamp; *note that this is returned as a string*.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * ARN of the attached stage.
         */
        public var stageArn: kotlin.String? = null
        /**
         * UTC time of the Composition start. This is an ISO 8601 timestamp; *note that this is returned as a string*.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * State of the Composition resource.
         */
        public var state: aws.sdk.kotlin.services.ivsrealtime.model.CompositionState? = null
        /**
         * Tags attached to the resource. Array of maps, each of the form `string:string (key:value)`. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivsrealtime.model.CompositionSummary) : this() {
            this.arn = x.arn
            this.destinations = x.destinations
            this.endTime = x.endTime
            this.stageArn = x.stageArn
            this.startTime = x.startTime
            this.state = x.state
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivsrealtime.model.CompositionSummary = CompositionSummary(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (destinations == null) destinations = emptyList()
            if (stageArn == null) stageArn = ""
            if (state == null) state = CompositionState.SdkUnknown("no value provided")
            return this
        }
    }
}
