// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.ivsrealtime.auth.DefaultIvsRealTimeAuthSchemeProvider
import aws.sdk.kotlin.services.ivsrealtime.auth.IvsRealTimeAuthSchemeProvider
import aws.sdk.kotlin.services.ivsrealtime.endpoints.DefaultIvsRealTimeEndpointProvider
import aws.sdk.kotlin.services.ivsrealtime.endpoints.IvsRealTimeEndpointParameters
import aws.sdk.kotlin.services.ivsrealtime.endpoints.IvsRealTimeEndpointProvider
import aws.sdk.kotlin.services.ivsrealtime.model.CreateEncoderConfigurationRequest
import aws.sdk.kotlin.services.ivsrealtime.model.CreateEncoderConfigurationResponse
import aws.sdk.kotlin.services.ivsrealtime.model.CreateParticipantTokenRequest
import aws.sdk.kotlin.services.ivsrealtime.model.CreateParticipantTokenResponse
import aws.sdk.kotlin.services.ivsrealtime.model.CreateStageRequest
import aws.sdk.kotlin.services.ivsrealtime.model.CreateStageResponse
import aws.sdk.kotlin.services.ivsrealtime.model.CreateStorageConfigurationRequest
import aws.sdk.kotlin.services.ivsrealtime.model.CreateStorageConfigurationResponse
import aws.sdk.kotlin.services.ivsrealtime.model.DeleteEncoderConfigurationRequest
import aws.sdk.kotlin.services.ivsrealtime.model.DeleteEncoderConfigurationResponse
import aws.sdk.kotlin.services.ivsrealtime.model.DeletePublicKeyRequest
import aws.sdk.kotlin.services.ivsrealtime.model.DeletePublicKeyResponse
import aws.sdk.kotlin.services.ivsrealtime.model.DeleteStageRequest
import aws.sdk.kotlin.services.ivsrealtime.model.DeleteStageResponse
import aws.sdk.kotlin.services.ivsrealtime.model.DeleteStorageConfigurationRequest
import aws.sdk.kotlin.services.ivsrealtime.model.DeleteStorageConfigurationResponse
import aws.sdk.kotlin.services.ivsrealtime.model.DisconnectParticipantRequest
import aws.sdk.kotlin.services.ivsrealtime.model.DisconnectParticipantResponse
import aws.sdk.kotlin.services.ivsrealtime.model.GetCompositionRequest
import aws.sdk.kotlin.services.ivsrealtime.model.GetCompositionResponse
import aws.sdk.kotlin.services.ivsrealtime.model.GetEncoderConfigurationRequest
import aws.sdk.kotlin.services.ivsrealtime.model.GetEncoderConfigurationResponse
import aws.sdk.kotlin.services.ivsrealtime.model.GetParticipantRequest
import aws.sdk.kotlin.services.ivsrealtime.model.GetParticipantResponse
import aws.sdk.kotlin.services.ivsrealtime.model.GetPublicKeyRequest
import aws.sdk.kotlin.services.ivsrealtime.model.GetPublicKeyResponse
import aws.sdk.kotlin.services.ivsrealtime.model.GetStageRequest
import aws.sdk.kotlin.services.ivsrealtime.model.GetStageResponse
import aws.sdk.kotlin.services.ivsrealtime.model.GetStageSessionRequest
import aws.sdk.kotlin.services.ivsrealtime.model.GetStageSessionResponse
import aws.sdk.kotlin.services.ivsrealtime.model.GetStorageConfigurationRequest
import aws.sdk.kotlin.services.ivsrealtime.model.GetStorageConfigurationResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ImportPublicKeyRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ImportPublicKeyResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListCompositionsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListCompositionsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListEncoderConfigurationsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListEncoderConfigurationsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListParticipantEventsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListParticipantEventsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListParticipantsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListParticipantsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListPublicKeysRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListPublicKeysResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListStageSessionsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListStageSessionsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListStagesRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListStagesResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListStorageConfigurationsRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListStorageConfigurationsResponse
import aws.sdk.kotlin.services.ivsrealtime.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.ivsrealtime.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.ivsrealtime.model.StartCompositionRequest
import aws.sdk.kotlin.services.ivsrealtime.model.StartCompositionResponse
import aws.sdk.kotlin.services.ivsrealtime.model.StopCompositionRequest
import aws.sdk.kotlin.services.ivsrealtime.model.StopCompositionResponse
import aws.sdk.kotlin.services.ivsrealtime.model.TagResourceRequest
import aws.sdk.kotlin.services.ivsrealtime.model.TagResourceResponse
import aws.sdk.kotlin.services.ivsrealtime.model.UntagResourceRequest
import aws.sdk.kotlin.services.ivsrealtime.model.UntagResourceResponse
import aws.sdk.kotlin.services.ivsrealtime.model.UpdateStageRequest
import aws.sdk.kotlin.services.ivsrealtime.model.UpdateStageResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "IVS RealTime"
public const val SdkVersion: String = "1.3.14"
public const val ServiceApiVersion: String = "2020-07-14"

/**
 * The Amazon Interactive Video Service (IVS) real-time API is REST compatible, using a standard HTTP API and an AWS EventBridge event stream for responses. JSON is used for both requests and responses, including errors.
 *
 * **Key Concepts**
 * + **Stage** — A virtual space where participants can exchange video in real time.
 * + **Participant token** — A token that authenticates a participant when they join a stage.
 * + **Participant object** — Represents participants (people) in the stage and contains information about them. When a token is created, it includes a participant ID; when a participant uses that token to join a stage, the participant is associated with that participant ID. There is a 1:1 mapping between participant tokens and participants.
 *
 * For server-side composition:
 * + **Composition process** — Composites participants of a stage into a single video and forwards it to a set of outputs (e.g., IVS channels). Composition endpoints support this process.
 * + **Composition** — Controls the look of the outputs, including how participants are positioned in the video.
 *
 * For more information about your IVS live stream, also see [Getting Started with Amazon IVS Real-Time Streaming](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started.html).
 *
 * **Tagging**
 *
 * A *tag* is a metadata label that you assign to an AWS resource. A tag comprises a *key* and a *value*, both set by you. For example, you might set a tag as `topic:nature` to label a particular video category. See [Tagging AWS Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) for more information, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS stages has no service-specific constraints beyond what is documented there.
 *
 * Tags can help you identify and organize your AWS resources. For example, you can use the same tag for different resources to indicate that they are related. You can also use tags to manage access (see [Access Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html)).
 *
 * The Amazon IVS real-time API has these tag-related endpoints: TagResource, UntagResource, and ListTagsForResource. The following resource supports tagging: Stage.
 *
 * At most 50 tags can be applied to a resource.
 */
public interface IvsRealTimeClient : SdkClient {
    /**
     * IvsRealTimeClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, IvsRealTimeClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "IvsRealTime",
                "IVS_REALTIME",
                "ivs_realtime",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, IvsRealTimeClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): IvsRealTimeClient = DefaultIvsRealTimeClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: IvsRealTimeEndpointProvider = builder.endpointProvider ?: DefaultIvsRealTimeEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: IvsRealTimeAuthSchemeProvider = builder.authSchemeProvider ?: DefaultIvsRealTimeAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "IVS RealTime"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: IvsRealTimeEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: IvsRealTimeAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an EncoderConfiguration object.
     */
    public suspend fun createEncoderConfiguration(input: CreateEncoderConfigurationRequest = CreateEncoderConfigurationRequest { }): CreateEncoderConfigurationResponse

    /**
     * Creates an additional token for a specified stage. This can be done after stage creation or when tokens expire. Tokens always are scoped to the stage for which they are created.
     *
     * Encryption keys are owned by Amazon IVS and never used directly by your application.
     */
    public suspend fun createParticipantToken(input: CreateParticipantTokenRequest): CreateParticipantTokenResponse

    /**
     * Creates a new stage (and optionally participant tokens).
     */
    public suspend fun createStage(input: CreateStageRequest = CreateStageRequest { }): CreateStageResponse

    /**
     * Creates a new storage configuration, used to enable recording to Amazon S3. When a StorageConfiguration is created, IVS will modify the S3 bucketPolicy of the provided bucket. This will ensure that IVS has sufficient permissions to write content to the provided bucket.
     */
    public suspend fun createStorageConfiguration(input: CreateStorageConfigurationRequest): CreateStorageConfigurationResponse

    /**
     * Deletes an EncoderConfiguration resource. Ensures that no Compositions are using this template; otherwise, returns an error.
     */
    public suspend fun deleteEncoderConfiguration(input: DeleteEncoderConfigurationRequest): DeleteEncoderConfigurationResponse

    /**
     * Deletes the specified public key used to sign stage participant tokens. This invalidates future participant tokens generated using the key pair’s private key.
     */
    public suspend fun deletePublicKey(input: DeletePublicKeyRequest): DeletePublicKeyResponse

    /**
     * Shuts down and deletes the specified stage (disconnecting all participants).
     */
    public suspend fun deleteStage(input: DeleteStageRequest): DeleteStageResponse

    /**
     * Deletes the storage configuration for the specified ARN.
     *
     * If you try to delete a storage configuration that is used by a Composition, you will get an error (409 ConflictException). To avoid this, for all Compositions that reference the storage configuration, first use StopComposition and wait for it to complete, then use DeleteStorageConfiguration.
     */
    public suspend fun deleteStorageConfiguration(input: DeleteStorageConfigurationRequest): DeleteStorageConfigurationResponse

    /**
     * Disconnects a specified participant and revokes the participant permanently from a specified stage.
     */
    public suspend fun disconnectParticipant(input: DisconnectParticipantRequest): DisconnectParticipantResponse

    /**
     * Get information about the specified Composition resource.
     */
    public suspend fun getComposition(input: GetCompositionRequest): GetCompositionResponse

    /**
     * Gets information about the specified EncoderConfiguration resource.
     */
    public suspend fun getEncoderConfiguration(input: GetEncoderConfigurationRequest): GetEncoderConfigurationResponse

    /**
     * Gets information about the specified participant token.
     */
    public suspend fun getParticipant(input: GetParticipantRequest): GetParticipantResponse

    /**
     * Gets information for the specified public key.
     */
    public suspend fun getPublicKey(input: GetPublicKeyRequest): GetPublicKeyResponse

    /**
     * Gets information for the specified stage.
     */
    public suspend fun getStage(input: GetStageRequest): GetStageResponse

    /**
     * Gets information for the specified stage session.
     */
    public suspend fun getStageSession(input: GetStageSessionRequest): GetStageSessionResponse

    /**
     * Gets the storage configuration for the specified ARN.
     */
    public suspend fun getStorageConfiguration(input: GetStorageConfigurationRequest): GetStorageConfigurationResponse

    /**
     * Import a public key to be used for signing stage participant tokens.
     */
    public suspend fun importPublicKey(input: ImportPublicKeyRequest): ImportPublicKeyResponse

    /**
     * Gets summary information about all Compositions in your account, in the AWS region where the API request is processed.
     */
    public suspend fun listCompositions(input: ListCompositionsRequest = ListCompositionsRequest { }): ListCompositionsResponse

    /**
     * Gets summary information about all EncoderConfigurations in your account, in the AWS region where the API request is processed.
     */
    public suspend fun listEncoderConfigurations(input: ListEncoderConfigurationsRequest = ListEncoderConfigurationsRequest { }): ListEncoderConfigurationsResponse

    /**
     * Lists events for a specified participant that occurred during a specified stage session.
     */
    public suspend fun listParticipantEvents(input: ListParticipantEventsRequest): ListParticipantEventsResponse

    /**
     * Lists all participants in a specified stage session.
     */
    public suspend fun listParticipants(input: ListParticipantsRequest): ListParticipantsResponse

    /**
     * Gets summary information about all public keys in your account, in the AWS region where the API request is processed.
     */
    public suspend fun listPublicKeys(input: ListPublicKeysRequest = ListPublicKeysRequest { }): ListPublicKeysResponse

    /**
     * Gets all sessions for a specified stage.
     */
    public suspend fun listStageSessions(input: ListStageSessionsRequest): ListStageSessionsResponse

    /**
     * Gets summary information about all stages in your account, in the AWS region where the API request is processed.
     */
    public suspend fun listStages(input: ListStagesRequest = ListStagesRequest { }): ListStagesResponse

    /**
     * Gets summary information about all storage configurations in your account, in the AWS region where the API request is processed.
     */
    public suspend fun listStorageConfigurations(input: ListStorageConfigurationsRequest = ListStorageConfigurationsRequest { }): ListStorageConfigurationsResponse

    /**
     * Gets information about AWS tags for the specified ARN.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Starts a Composition from a stage based on the configuration provided in the request.
     *
     * A Composition is an ephemeral resource that exists after this endpoint returns successfully. Composition stops and the resource is deleted:
     * + When StopComposition is called.
     * + After a 1-minute timeout, when all participants are disconnected from the stage.
     * + After a 1-minute timeout, if there are no participants in the stage when StartComposition is called.
     * + When broadcasting to the IVS channel fails and all retries are exhausted.
     * + When broadcasting is disconnected and all attempts to reconnect are exhausted.
     */
    public suspend fun startComposition(input: StartCompositionRequest): StartCompositionResponse

    /**
     * Stops and deletes a Composition resource. Any broadcast from the Composition resource is stopped.
     */
    public suspend fun stopComposition(input: StopCompositionRequest): StopCompositionResponse

    /**
     * Adds or updates tags for the AWS resource with the specified ARN.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from the resource with the specified ARN.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a stage’s configuration.
     */
    public suspend fun updateStage(input: UpdateStageRequest): UpdateStageResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun IvsRealTimeClient.withConfig(block: IvsRealTimeClient.Config.Builder.() -> Unit): IvsRealTimeClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIvsRealTimeClient(newConfig)
}

/**
 * Creates an EncoderConfiguration object.
 */
public suspend inline fun IvsRealTimeClient.createEncoderConfiguration(crossinline block: CreateEncoderConfigurationRequest.Builder.() -> Unit): CreateEncoderConfigurationResponse = createEncoderConfiguration(CreateEncoderConfigurationRequest.Builder().apply(block).build())

/**
 * Creates an additional token for a specified stage. This can be done after stage creation or when tokens expire. Tokens always are scoped to the stage for which they are created.
 *
 * Encryption keys are owned by Amazon IVS and never used directly by your application.
 */
public suspend inline fun IvsRealTimeClient.createParticipantToken(crossinline block: CreateParticipantTokenRequest.Builder.() -> Unit): CreateParticipantTokenResponse = createParticipantToken(CreateParticipantTokenRequest.Builder().apply(block).build())

/**
 * Creates a new stage (and optionally participant tokens).
 */
public suspend inline fun IvsRealTimeClient.createStage(crossinline block: CreateStageRequest.Builder.() -> Unit): CreateStageResponse = createStage(CreateStageRequest.Builder().apply(block).build())

/**
 * Creates a new storage configuration, used to enable recording to Amazon S3. When a StorageConfiguration is created, IVS will modify the S3 bucketPolicy of the provided bucket. This will ensure that IVS has sufficient permissions to write content to the provided bucket.
 */
public suspend inline fun IvsRealTimeClient.createStorageConfiguration(crossinline block: CreateStorageConfigurationRequest.Builder.() -> Unit): CreateStorageConfigurationResponse = createStorageConfiguration(CreateStorageConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes an EncoderConfiguration resource. Ensures that no Compositions are using this template; otherwise, returns an error.
 */
public suspend inline fun IvsRealTimeClient.deleteEncoderConfiguration(crossinline block: DeleteEncoderConfigurationRequest.Builder.() -> Unit): DeleteEncoderConfigurationResponse = deleteEncoderConfiguration(DeleteEncoderConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the specified public key used to sign stage participant tokens. This invalidates future participant tokens generated using the key pair’s private key.
 */
public suspend inline fun IvsRealTimeClient.deletePublicKey(crossinline block: DeletePublicKeyRequest.Builder.() -> Unit): DeletePublicKeyResponse = deletePublicKey(DeletePublicKeyRequest.Builder().apply(block).build())

/**
 * Shuts down and deletes the specified stage (disconnecting all participants).
 */
public suspend inline fun IvsRealTimeClient.deleteStage(crossinline block: DeleteStageRequest.Builder.() -> Unit): DeleteStageResponse = deleteStage(DeleteStageRequest.Builder().apply(block).build())

/**
 * Deletes the storage configuration for the specified ARN.
 *
 * If you try to delete a storage configuration that is used by a Composition, you will get an error (409 ConflictException). To avoid this, for all Compositions that reference the storage configuration, first use StopComposition and wait for it to complete, then use DeleteStorageConfiguration.
 */
public suspend inline fun IvsRealTimeClient.deleteStorageConfiguration(crossinline block: DeleteStorageConfigurationRequest.Builder.() -> Unit): DeleteStorageConfigurationResponse = deleteStorageConfiguration(DeleteStorageConfigurationRequest.Builder().apply(block).build())

/**
 * Disconnects a specified participant and revokes the participant permanently from a specified stage.
 */
public suspend inline fun IvsRealTimeClient.disconnectParticipant(crossinline block: DisconnectParticipantRequest.Builder.() -> Unit): DisconnectParticipantResponse = disconnectParticipant(DisconnectParticipantRequest.Builder().apply(block).build())

/**
 * Get information about the specified Composition resource.
 */
public suspend inline fun IvsRealTimeClient.getComposition(crossinline block: GetCompositionRequest.Builder.() -> Unit): GetCompositionResponse = getComposition(GetCompositionRequest.Builder().apply(block).build())

/**
 * Gets information about the specified EncoderConfiguration resource.
 */
public suspend inline fun IvsRealTimeClient.getEncoderConfiguration(crossinline block: GetEncoderConfigurationRequest.Builder.() -> Unit): GetEncoderConfigurationResponse = getEncoderConfiguration(GetEncoderConfigurationRequest.Builder().apply(block).build())

/**
 * Gets information about the specified participant token.
 */
public suspend inline fun IvsRealTimeClient.getParticipant(crossinline block: GetParticipantRequest.Builder.() -> Unit): GetParticipantResponse = getParticipant(GetParticipantRequest.Builder().apply(block).build())

/**
 * Gets information for the specified public key.
 */
public suspend inline fun IvsRealTimeClient.getPublicKey(crossinline block: GetPublicKeyRequest.Builder.() -> Unit): GetPublicKeyResponse = getPublicKey(GetPublicKeyRequest.Builder().apply(block).build())

/**
 * Gets information for the specified stage.
 */
public suspend inline fun IvsRealTimeClient.getStage(crossinline block: GetStageRequest.Builder.() -> Unit): GetStageResponse = getStage(GetStageRequest.Builder().apply(block).build())

/**
 * Gets information for the specified stage session.
 */
public suspend inline fun IvsRealTimeClient.getStageSession(crossinline block: GetStageSessionRequest.Builder.() -> Unit): GetStageSessionResponse = getStageSession(GetStageSessionRequest.Builder().apply(block).build())

/**
 * Gets the storage configuration for the specified ARN.
 */
public suspend inline fun IvsRealTimeClient.getStorageConfiguration(crossinline block: GetStorageConfigurationRequest.Builder.() -> Unit): GetStorageConfigurationResponse = getStorageConfiguration(GetStorageConfigurationRequest.Builder().apply(block).build())

/**
 * Import a public key to be used for signing stage participant tokens.
 */
public suspend inline fun IvsRealTimeClient.importPublicKey(crossinline block: ImportPublicKeyRequest.Builder.() -> Unit): ImportPublicKeyResponse = importPublicKey(ImportPublicKeyRequest.Builder().apply(block).build())

/**
 * Gets summary information about all Compositions in your account, in the AWS region where the API request is processed.
 */
public suspend inline fun IvsRealTimeClient.listCompositions(crossinline block: ListCompositionsRequest.Builder.() -> Unit): ListCompositionsResponse = listCompositions(ListCompositionsRequest.Builder().apply(block).build())

/**
 * Gets summary information about all EncoderConfigurations in your account, in the AWS region where the API request is processed.
 */
public suspend inline fun IvsRealTimeClient.listEncoderConfigurations(crossinline block: ListEncoderConfigurationsRequest.Builder.() -> Unit): ListEncoderConfigurationsResponse = listEncoderConfigurations(ListEncoderConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists events for a specified participant that occurred during a specified stage session.
 */
public suspend inline fun IvsRealTimeClient.listParticipantEvents(crossinline block: ListParticipantEventsRequest.Builder.() -> Unit): ListParticipantEventsResponse = listParticipantEvents(ListParticipantEventsRequest.Builder().apply(block).build())

/**
 * Lists all participants in a specified stage session.
 */
public suspend inline fun IvsRealTimeClient.listParticipants(crossinline block: ListParticipantsRequest.Builder.() -> Unit): ListParticipantsResponse = listParticipants(ListParticipantsRequest.Builder().apply(block).build())

/**
 * Gets summary information about all public keys in your account, in the AWS region where the API request is processed.
 */
public suspend inline fun IvsRealTimeClient.listPublicKeys(crossinline block: ListPublicKeysRequest.Builder.() -> Unit): ListPublicKeysResponse = listPublicKeys(ListPublicKeysRequest.Builder().apply(block).build())

/**
 * Gets all sessions for a specified stage.
 */
public suspend inline fun IvsRealTimeClient.listStageSessions(crossinline block: ListStageSessionsRequest.Builder.() -> Unit): ListStageSessionsResponse = listStageSessions(ListStageSessionsRequest.Builder().apply(block).build())

/**
 * Gets summary information about all stages in your account, in the AWS region where the API request is processed.
 */
public suspend inline fun IvsRealTimeClient.listStages(crossinline block: ListStagesRequest.Builder.() -> Unit): ListStagesResponse = listStages(ListStagesRequest.Builder().apply(block).build())

/**
 * Gets summary information about all storage configurations in your account, in the AWS region where the API request is processed.
 */
public suspend inline fun IvsRealTimeClient.listStorageConfigurations(crossinline block: ListStorageConfigurationsRequest.Builder.() -> Unit): ListStorageConfigurationsResponse = listStorageConfigurations(ListStorageConfigurationsRequest.Builder().apply(block).build())

/**
 * Gets information about AWS tags for the specified ARN.
 */
public suspend inline fun IvsRealTimeClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts a Composition from a stage based on the configuration provided in the request.
 *
 * A Composition is an ephemeral resource that exists after this endpoint returns successfully. Composition stops and the resource is deleted:
 * + When StopComposition is called.
 * + After a 1-minute timeout, when all participants are disconnected from the stage.
 * + After a 1-minute timeout, if there are no participants in the stage when StartComposition is called.
 * + When broadcasting to the IVS channel fails and all retries are exhausted.
 * + When broadcasting is disconnected and all attempts to reconnect are exhausted.
 */
public suspend inline fun IvsRealTimeClient.startComposition(crossinline block: StartCompositionRequest.Builder.() -> Unit): StartCompositionResponse = startComposition(StartCompositionRequest.Builder().apply(block).build())

/**
 * Stops and deletes a Composition resource. Any broadcast from the Composition resource is stopped.
 */
public suspend inline fun IvsRealTimeClient.stopComposition(crossinline block: StopCompositionRequest.Builder.() -> Unit): StopCompositionResponse = stopComposition(StopCompositionRequest.Builder().apply(block).build())

/**
 * Adds or updates tags for the AWS resource with the specified ARN.
 */
public suspend inline fun IvsRealTimeClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from the resource with the specified ARN.
 */
public suspend inline fun IvsRealTimeClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a stage’s configuration.
 */
public suspend inline fun IvsRealTimeClient.updateStage(crossinline block: UpdateStageRequest.Builder.() -> Unit): UpdateStageResponse = updateStage(UpdateStageRequest.Builder().apply(block).build())
