// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A complex type that describes an S3 location where recorded videos will be stored.
 */
public class S3DestinationConfiguration private constructor(builder: Builder) {
    /**
     * ARNs of the EncoderConfiguration resource. The encoder configuration and stage resources must be in the same AWS account and region.
     */
    public val encoderConfigurationArns: List<String> = requireNotNull(builder.encoderConfigurationArns) { "A non-null value must be provided for encoderConfigurationArns" }
    /**
     * Array of maps, each of the form `string:string (key:value)`. This is an optional customer specification, currently used only to specify the recording format for storing a recording in Amazon S3.
     */
    public val recordingConfiguration: aws.sdk.kotlin.services.ivsrealtime.model.RecordingConfiguration? = builder.recordingConfiguration
    /**
     * ARN of the StorageConfiguration where recorded videos will be stored.
     */
    public val storageConfigurationArn: kotlin.String = requireNotNull(builder.storageConfigurationArn) { "A non-null value must be provided for storageConfigurationArn" }
    /**
     * A complex type that allows you to enable/disable the recording of thumbnails for a Composition and modify the interval at which thumbnails are generated for the live session.
     */
    public val thumbnailConfigurations: List<CompositionThumbnailConfiguration>? = builder.thumbnailConfigurations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivsrealtime.model.S3DestinationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3DestinationConfiguration(")
        append("encoderConfigurationArns=$encoderConfigurationArns,")
        append("recordingConfiguration=$recordingConfiguration,")
        append("storageConfigurationArn=$storageConfigurationArn,")
        append("thumbnailConfigurations=$thumbnailConfigurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encoderConfigurationArns.hashCode()
        result = 31 * result + (recordingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (storageConfigurationArn.hashCode())
        result = 31 * result + (thumbnailConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3DestinationConfiguration

        if (encoderConfigurationArns != other.encoderConfigurationArns) return false
        if (recordingConfiguration != other.recordingConfiguration) return false
        if (storageConfigurationArn != other.storageConfigurationArn) return false
        if (thumbnailConfigurations != other.thumbnailConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivsrealtime.model.S3DestinationConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * ARNs of the EncoderConfiguration resource. The encoder configuration and stage resources must be in the same AWS account and region.
         */
        public var encoderConfigurationArns: List<String>? = null
        /**
         * Array of maps, each of the form `string:string (key:value)`. This is an optional customer specification, currently used only to specify the recording format for storing a recording in Amazon S3.
         */
        public var recordingConfiguration: aws.sdk.kotlin.services.ivsrealtime.model.RecordingConfiguration? = null
        /**
         * ARN of the StorageConfiguration where recorded videos will be stored.
         */
        public var storageConfigurationArn: kotlin.String? = null
        /**
         * A complex type that allows you to enable/disable the recording of thumbnails for a Composition and modify the interval at which thumbnails are generated for the live session.
         */
        public var thumbnailConfigurations: List<CompositionThumbnailConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivsrealtime.model.S3DestinationConfiguration) : this() {
            this.encoderConfigurationArns = x.encoderConfigurationArns
            this.recordingConfiguration = x.recordingConfiguration
            this.storageConfigurationArn = x.storageConfigurationArn
            this.thumbnailConfigurations = x.thumbnailConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivsrealtime.model.S3DestinationConfiguration = S3DestinationConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.ivsrealtime.model.RecordingConfiguration] inside the given [block]
         */
        public fun recordingConfiguration(block: aws.sdk.kotlin.services.ivsrealtime.model.RecordingConfiguration.Builder.() -> kotlin.Unit) {
            this.recordingConfiguration = aws.sdk.kotlin.services.ivsrealtime.model.RecordingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (encoderConfigurationArns == null) encoderConfigurationArns = emptyList()
            if (storageConfigurationArn == null) storageConfigurationArn = ""
            return this
        }
    }
}
