// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Object specifying a participant token in a stage.
 *
 * **Important**: Treat tokens as opaque; i.e., do not build functionality based on token contents. The format of tokens could change in the future.
 */
public class ParticipantToken private constructor(builder: Builder) {
    /**
     * Application-provided attributes to encode into the token and attach to a stage. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.*
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * Set of capabilities that the user is allowed to perform in the stage.
     */
    public val capabilities: List<ParticipantTokenCapability>? = builder.capabilities
    /**
     * Duration (in minutes), after which the participant token expires. Default: 720 (12 hours).
     */
    public val duration: kotlin.Int? = builder.duration
    /**
     * ISO 8601 timestamp (returned as a string) for when this token expires.
     */
    public val expirationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationTime
    /**
     * Unique identifier for this participant token, assigned by IVS.
     */
    public val participantId: kotlin.String? = builder.participantId
    /**
     * The issued client token, encrypted.
     */
    public val token: kotlin.String? = builder.token
    /**
     * Customer-assigned name to help identify the token; this can be used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.*
     */
    public val userId: kotlin.String? = builder.userId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivsrealtime.model.ParticipantToken = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParticipantToken(")
        append("attributes=$attributes,")
        append("capabilities=$capabilities,")
        append("duration=$duration,")
        append("expirationTime=$expirationTime,")
        append("participantId=$participantId,")
        append("token=*** Sensitive Data Redacted ***,")
        append("userId=$userId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (capabilities?.hashCode() ?: 0)
        result = 31 * result + (duration ?: 0)
        result = 31 * result + (expirationTime?.hashCode() ?: 0)
        result = 31 * result + (participantId?.hashCode() ?: 0)
        result = 31 * result + (token?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParticipantToken

        if (attributes != other.attributes) return false
        if (capabilities != other.capabilities) return false
        if (duration != other.duration) return false
        if (expirationTime != other.expirationTime) return false
        if (participantId != other.participantId) return false
        if (token != other.token) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivsrealtime.model.ParticipantToken = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Application-provided attributes to encode into the token and attach to a stage. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.*
         */
        public var attributes: Map<String, String>? = null
        /**
         * Set of capabilities that the user is allowed to perform in the stage.
         */
        public var capabilities: List<ParticipantTokenCapability>? = null
        /**
         * Duration (in minutes), after which the participant token expires. Default: 720 (12 hours).
         */
        public var duration: kotlin.Int? = null
        /**
         * ISO 8601 timestamp (returned as a string) for when this token expires.
         */
        public var expirationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Unique identifier for this participant token, assigned by IVS.
         */
        public var participantId: kotlin.String? = null
        /**
         * The issued client token, encrypted.
         */
        public var token: kotlin.String? = null
        /**
         * Customer-assigned name to help identify the token; this can be used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.*
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivsrealtime.model.ParticipantToken) : this() {
            this.attributes = x.attributes
            this.capabilities = x.capabilities
            this.duration = x.duration
            this.expirationTime = x.expirationTime
            this.participantId = x.participantId
            this.token = x.token
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivsrealtime.model.ParticipantToken = ParticipantToken(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
