// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Object specifying an ingest configuration.
 */
public class IngestConfiguration private constructor(builder: Builder) {
    /**
     * Ingest configuration ARN.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * Application-provided attributes to to store in the IngestConfiguration and attach to a stage. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.*
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * Type of ingest protocol that the user employs for broadcasting.
     */
    public val ingestProtocol: aws.sdk.kotlin.services.ivsrealtime.model.IngestProtocol = requireNotNull(builder.ingestProtocol) { "A non-null value must be provided for ingestProtocol" }
    /**
     * Ingest name
     */
    public val name: kotlin.String? = builder.name
    /**
     * ID of the participant within the stage.
     */
    public val participantId: kotlin.String = requireNotNull(builder.participantId) { "A non-null value must be provided for participantId" }
    /**
     * ARN of the stage with which the IngestConfiguration is associated.
     */
    public val stageArn: kotlin.String = requireNotNull(builder.stageArn) { "A non-null value must be provided for stageArn" }
    /**
     * State of the ingest configuration. It is `ACTIVE` if a publisher currently is publishing to the stage associated with the ingest configuration.
     */
    public val state: aws.sdk.kotlin.services.ivsrealtime.model.IngestConfigurationState = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * Ingest-key value for the RTMP(S) protocol.
     */
    public val streamKey: kotlin.String = requireNotNull(builder.streamKey) { "A non-null value must be provided for streamKey" }
    /**
     * Tags attached to the resource. Array of maps, each of the form `string:string (key:value)`. See [Best practices and strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html) in *Tagging AWS Resources and Tag Editor* for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Customer-assigned name to help identify the participant using the IngestConfiguration; this can be used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.*
     */
    public val userId: kotlin.String? = builder.userId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivsrealtime.model.IngestConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IngestConfiguration(")
        append("arn=$arn,")
        append("attributes=$attributes,")
        append("ingestProtocol=$ingestProtocol,")
        append("name=$name,")
        append("participantId=$participantId,")
        append("stageArn=$stageArn,")
        append("state=$state,")
        append("streamKey=*** Sensitive Data Redacted ***,")
        append("tags=$tags,")
        append("userId=$userId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (ingestProtocol.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (participantId.hashCode())
        result = 31 * result + (stageArn.hashCode())
        result = 31 * result + (state.hashCode())
        result = 31 * result + (streamKey.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IngestConfiguration

        if (arn != other.arn) return false
        if (attributes != other.attributes) return false
        if (ingestProtocol != other.ingestProtocol) return false
        if (name != other.name) return false
        if (participantId != other.participantId) return false
        if (stageArn != other.stageArn) return false
        if (state != other.state) return false
        if (streamKey != other.streamKey) return false
        if (tags != other.tags) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivsrealtime.model.IngestConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Ingest configuration ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * Application-provided attributes to to store in the IngestConfiguration and attach to a stage. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.*
         */
        public var attributes: Map<String, String>? = null
        /**
         * Type of ingest protocol that the user employs for broadcasting.
         */
        public var ingestProtocol: aws.sdk.kotlin.services.ivsrealtime.model.IngestProtocol? = null
        /**
         * Ingest name
         */
        public var name: kotlin.String? = null
        /**
         * ID of the participant within the stage.
         */
        public var participantId: kotlin.String? = null
        /**
         * ARN of the stage with which the IngestConfiguration is associated.
         */
        public var stageArn: kotlin.String? = null
        /**
         * State of the ingest configuration. It is `ACTIVE` if a publisher currently is publishing to the stage associated with the ingest configuration.
         */
        public var state: aws.sdk.kotlin.services.ivsrealtime.model.IngestConfigurationState? = null
        /**
         * Ingest-key value for the RTMP(S) protocol.
         */
        public var streamKey: kotlin.String? = null
        /**
         * Tags attached to the resource. Array of maps, each of the form `string:string (key:value)`. See [Best practices and strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html) in *Tagging AWS Resources and Tag Editor* for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints on tags beyond what is documented there.
         */
        public var tags: Map<String, String>? = null
        /**
         * Customer-assigned name to help identify the participant using the IngestConfiguration; this can be used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.*
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivsrealtime.model.IngestConfiguration) : this() {
            this.arn = x.arn
            this.attributes = x.attributes
            this.ingestProtocol = x.ingestProtocol
            this.name = x.name
            this.participantId = x.participantId
            this.stageArn = x.stageArn
            this.state = x.state
            this.streamKey = x.streamKey
            this.tags = x.tags
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivsrealtime.model.IngestConfiguration = IngestConfiguration(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (ingestProtocol == null) ingestProtocol = IngestProtocol.SdkUnknown("no value provided")
            if (participantId == null) participantId = ""
            if (stageArn == null) stageArn = ""
            if (state == null) state = IngestConfigurationState.SdkUnknown("no value provided")
            if (streamKey == null) streamKey = ""
            return this
        }
    }
}
