// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An occurrence during a stage session.
 */
public class Event private constructor(builder: Builder) {
    /**
     * If the event is an error event, the error code is provided to give insight into the specific error that occurred. If the event is not an error event, this field is null.
     * + `B_FRAME_PRESENT` — The participant's stream includes B-frames. For details, see [ IVS RTMP Publishing](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/rt-rtmp-publishing.html).
     * + `BITRATE_EXCEEDED` — The participant exceeded the maximum supported bitrate. For details, see [ Service Quotas](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/service-quotas.html).
     * + `INSUFFICIENT_CAPABILITIES` — The participant tried to take an action that the participant’s token is not allowed to do. For details on participant capabilities, see the `capabilities` field in CreateParticipantToken.
     * + `INTERNAL_SERVER_EXCEPTION` — The participant failed to publish to the stage due to an internal server error.
     * + `INVALID_AUDIO_CODEC` — The participant is using an invalid audio codec. For details, see [ Stream Ingest](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/rt-stream-ingest.html).
     * + `INVALID_INPUT` — The participant is using an invalid input stream.
     * + `INVALID_PROTOCOL` — The participant's IngestConfiguration resource is configured for RTMPS but they tried streaming with RTMP. For details, see [ IVS RTMP Publishing](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/rt-rtmp-publishing.html).
     * + `INVALID_STREAM_KEY` — The participant is using an invalid stream key. For details, see [ IVS RTMP Publishing](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/rt-rtmp-publishing.html).
     * + `INVALID_VIDEO_CODEC` — The participant is using an invalid video codec. For details, see [ Stream Ingest](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/rt-stream-ingest.html).
     * + `PUBLISHER_NOT_FOUND` — The participant tried to subscribe to a publisher that doesn’t exist.
     * + `QUOTA_EXCEEDED` — The number of participants who want to publish/subscribe to a stage exceeds the quota. For details, see [ Service Quotas](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/service-quotas.html).
     * + `RESOLUTION_EXCEEDED` — The participant exceeded the maximum supported resolution. For details, see [ Service Quotas](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/service-quotas.html).
     * + `REUSE_OF_STREAM_KEY` — The participant tried to use a stream key that is associated with another active stage session.
     * + `STREAM_DURATION_EXCEEDED` — The participant exceeded the maximum allowed stream duration. For details, see [ Service Quotas](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/service-quotas.html).
     */
    public val errorCode: aws.sdk.kotlin.services.ivsrealtime.model.EventErrorCode? = builder.errorCode
    /**
     * ISO 8601 timestamp (returned as a string) for when the event occurred.
     */
    public val eventTime: aws.smithy.kotlin.runtime.time.Instant? = builder.eventTime
    /**
     * The name of the event.
     */
    public val name: aws.sdk.kotlin.services.ivsrealtime.model.EventName? = builder.name
    /**
     * Unique identifier for the participant who triggered the event. This is assigned by IVS.
     */
    public val participantId: kotlin.String? = builder.participantId
    /**
     * Unique identifier for the remote participant. For a subscribe event, this is the publisher. For a publish or join event, this is null. This is assigned by IVS.
     */
    public val remoteParticipantId: kotlin.String? = builder.remoteParticipantId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivsrealtime.model.Event = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Event(")
        append("errorCode=$errorCode,")
        append("eventTime=$eventTime,")
        append("name=$name,")
        append("participantId=$participantId,")
        append("remoteParticipantId=$remoteParticipantId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode?.hashCode() ?: 0
        result = 31 * result + (eventTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (participantId?.hashCode() ?: 0)
        result = 31 * result + (remoteParticipantId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Event

        if (errorCode != other.errorCode) return false
        if (eventTime != other.eventTime) return false
        if (name != other.name) return false
        if (participantId != other.participantId) return false
        if (remoteParticipantId != other.remoteParticipantId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivsrealtime.model.Event = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If the event is an error event, the error code is provided to give insight into the specific error that occurred. If the event is not an error event, this field is null.
         * + `B_FRAME_PRESENT` — The participant's stream includes B-frames. For details, see [ IVS RTMP Publishing](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/rt-rtmp-publishing.html).
         * + `BITRATE_EXCEEDED` — The participant exceeded the maximum supported bitrate. For details, see [ Service Quotas](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/service-quotas.html).
         * + `INSUFFICIENT_CAPABILITIES` — The participant tried to take an action that the participant’s token is not allowed to do. For details on participant capabilities, see the `capabilities` field in CreateParticipantToken.
         * + `INTERNAL_SERVER_EXCEPTION` — The participant failed to publish to the stage due to an internal server error.
         * + `INVALID_AUDIO_CODEC` — The participant is using an invalid audio codec. For details, see [ Stream Ingest](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/rt-stream-ingest.html).
         * + `INVALID_INPUT` — The participant is using an invalid input stream.
         * + `INVALID_PROTOCOL` — The participant's IngestConfiguration resource is configured for RTMPS but they tried streaming with RTMP. For details, see [ IVS RTMP Publishing](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/rt-rtmp-publishing.html).
         * + `INVALID_STREAM_KEY` — The participant is using an invalid stream key. For details, see [ IVS RTMP Publishing](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/rt-rtmp-publishing.html).
         * + `INVALID_VIDEO_CODEC` — The participant is using an invalid video codec. For details, see [ Stream Ingest](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/rt-stream-ingest.html).
         * + `PUBLISHER_NOT_FOUND` — The participant tried to subscribe to a publisher that doesn’t exist.
         * + `QUOTA_EXCEEDED` — The number of participants who want to publish/subscribe to a stage exceeds the quota. For details, see [ Service Quotas](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/service-quotas.html).
         * + `RESOLUTION_EXCEEDED` — The participant exceeded the maximum supported resolution. For details, see [ Service Quotas](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/service-quotas.html).
         * + `REUSE_OF_STREAM_KEY` — The participant tried to use a stream key that is associated with another active stage session.
         * + `STREAM_DURATION_EXCEEDED` — The participant exceeded the maximum allowed stream duration. For details, see [ Service Quotas](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/service-quotas.html).
         */
        public var errorCode: aws.sdk.kotlin.services.ivsrealtime.model.EventErrorCode? = null
        /**
         * ISO 8601 timestamp (returned as a string) for when the event occurred.
         */
        public var eventTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the event.
         */
        public var name: aws.sdk.kotlin.services.ivsrealtime.model.EventName? = null
        /**
         * Unique identifier for the participant who triggered the event. This is assigned by IVS.
         */
        public var participantId: kotlin.String? = null
        /**
         * Unique identifier for the remote participant. For a subscribe event, this is the publisher. For a publish or join event, this is null. This is assigned by IVS.
         */
        public var remoteParticipantId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivsrealtime.model.Event) : this() {
            this.errorCode = x.errorCode
            this.eventTime = x.eventTime
            this.name = x.name
            this.participantId = x.participantId
            this.remoteParticipantId = x.remoteParticipantId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivsrealtime.model.Event = Event(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
