// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A stage session begins when the first participant joins a stage and ends after the last participant leaves the stage. A stage session helps with debugging stages by grouping events and participants into shorter periods of time (i.e., a session), which is helpful when stages are used over long periods of time.
 */
public class StageSession private constructor(builder: Builder) {
    /**
     * ISO 8601 timestamp (returned as a string) when the stage session ended. This is null if the stage is active.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * ID of the session within the stage.
     */
    public val sessionId: kotlin.String? = builder.sessionId
    /**
     * ISO 8601 timestamp (returned as a string) when this stage session began.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivsrealtime.model.StageSession = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StageSession(")
        append("endTime=$endTime,")
        append("sessionId=$sessionId,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StageSession

        if (endTime != other.endTime) return false
        if (sessionId != other.sessionId) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivsrealtime.model.StageSession = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * ISO 8601 timestamp (returned as a string) when the stage session ended. This is null if the stage is active.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * ID of the session within the stage.
         */
        public var sessionId: kotlin.String? = null
        /**
         * ISO 8601 timestamp (returned as a string) when this stage session began.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivsrealtime.model.StageSession) : this() {
            this.endTime = x.endTime
            this.sessionId = x.sessionId
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivsrealtime.model.StageSession = StageSession(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
