// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Object specifying the status of a Destination.
 */
public class Destination private constructor(builder: Builder) {
    /**
     * Configuration used to create this destination.
     */
    public val configuration: aws.sdk.kotlin.services.ivsrealtime.model.DestinationConfiguration? = builder.configuration
    /**
     * Optional details regarding the status of the destination.
     */
    public val detail: aws.sdk.kotlin.services.ivsrealtime.model.DestinationDetail? = builder.detail
    /**
     * UTC time of the destination end. This is an ISO 8601 timestamp; *note that this is returned as a string*.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Unique identifier for this destination, assigned by IVS.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * UTC time of the destination start. This is an ISO 8601 timestamp; *note that this is returned as a string*.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * State of the Composition Destination.
     */
    public val state: aws.sdk.kotlin.services.ivsrealtime.model.DestinationState = requireNotNull(builder.state) { "A non-null value must be provided for state" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivsrealtime.model.Destination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Destination(")
        append("configuration=$configuration,")
        append("detail=$detail,")
        append("endTime=$endTime,")
        append("id=$id,")
        append("startTime=$startTime,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (detail?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Destination

        if (configuration != other.configuration) return false
        if (detail != other.detail) return false
        if (endTime != other.endTime) return false
        if (id != other.id) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivsrealtime.model.Destination = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Configuration used to create this destination.
         */
        public var configuration: aws.sdk.kotlin.services.ivsrealtime.model.DestinationConfiguration? = null
        /**
         * Optional details regarding the status of the destination.
         */
        public var detail: aws.sdk.kotlin.services.ivsrealtime.model.DestinationDetail? = null
        /**
         * UTC time of the destination end. This is an ISO 8601 timestamp; *note that this is returned as a string*.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Unique identifier for this destination, assigned by IVS.
         */
        public var id: kotlin.String? = null
        /**
         * UTC time of the destination start. This is an ISO 8601 timestamp; *note that this is returned as a string*.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * State of the Composition Destination.
         */
        public var state: aws.sdk.kotlin.services.ivsrealtime.model.DestinationState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivsrealtime.model.Destination) : this() {
            this.configuration = x.configuration
            this.detail = x.detail
            this.endTime = x.endTime
            this.id = x.id
            this.startTime = x.startTime
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivsrealtime.model.Destination = Destination(this)

        /**
         * construct an [aws.sdk.kotlin.services.ivsrealtime.model.DestinationConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.ivsrealtime.model.DestinationConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.ivsrealtime.model.DestinationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ivsrealtime.model.DestinationDetail] inside the given [block]
         */
        public fun detail(block: aws.sdk.kotlin.services.ivsrealtime.model.DestinationDetail.Builder.() -> kotlin.Unit) {
            this.detail = aws.sdk.kotlin.services.ivsrealtime.model.DestinationDetail.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (state == null) state = DestinationState.SdkUnknown("no value provided")
            return this
        }
    }
}
