// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ivsrealtime.model



/**
 * Object specifying a participant token configuration in a stage.
 */
public class ParticipantTokenConfiguration private constructor(builder: Builder) {
    /**
     * Application-provided attributes to encode into the corresponding participant token and attach to a stage. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.*
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * Set of capabilities that the user is allowed to perform in the stage.
     */
    public val capabilities: List<ParticipantTokenCapability>? = builder.capabilities
    /**
     * Duration (in minutes), after which the corresponding participant token expires. Default: 720 (12 hours).
     */
    public val duration: kotlin.Int? = builder.duration
    /**
     * Customer-assigned name to help identify the token; this can be used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.*
     */
    public val userId: kotlin.String? = builder.userId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ivsrealtime.model.ParticipantTokenConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParticipantTokenConfiguration(")
        append("attributes=$attributes,")
        append("capabilities=$capabilities,")
        append("duration=$duration,")
        append("userId=$userId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (capabilities?.hashCode() ?: 0)
        result = 31 * result + (duration ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParticipantTokenConfiguration

        if (attributes != other.attributes) return false
        if (capabilities != other.capabilities) return false
        if (duration != other.duration) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ivsrealtime.model.ParticipantTokenConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Application-provided attributes to encode into the corresponding participant token and attach to a stage. Map keys and values can contain UTF-8 encoded text. The maximum length of this field is 1 KB total. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.*
         */
        public var attributes: Map<String, String>? = null
        /**
         * Set of capabilities that the user is allowed to perform in the stage.
         */
        public var capabilities: List<ParticipantTokenCapability>? = null
        /**
         * Duration (in minutes), after which the corresponding participant token expires. Default: 720 (12 hours).
         */
        public var duration: kotlin.Int? = null
        /**
         * Customer-assigned name to help identify the token; this can be used to link a participant to a user in the customer’s own systems. This can be any UTF-8 encoded text. *This field is exposed to all stage participants and should not be used for personally identifying, confidential, or sensitive information.*
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ivsrealtime.model.ParticipantTokenConfiguration) : this() {
            this.attributes = x.attributes
            this.capabilities = x.capabilities
            this.duration = x.duration
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ivsrealtime.model.ParticipantTokenConfiguration = ParticipantTokenConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
